package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiConfigurationMapper;
import com.els.base.performance.entity.KpiConfiguration;
import com.els.base.performance.entity.KpiConfigurationExample;
import com.els.base.performance.service.KpiConfigurationService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiConfigurationService")
public class KpiConfigurationServiceImpl implements KpiConfigurationService {
    @Resource
    protected KpiConfigurationMapper kpiConfigurationMapper;

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    @Override
    public void addObj(KpiConfiguration t) {
        this.kpiConfigurationMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    @Override
    public void addAll(List<KpiConfiguration> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiConfigurationMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiConfigurationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    @Override
    public void deleteByExample(KpiConfigurationExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiConfigurationMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    @Override
    public void modifyObj(KpiConfiguration t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiConfigurationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiConfiguration", keyGenerator="redisKeyGenerator")
    @Override
    public KpiConfiguration queryObjById(String id) {
        return this.kpiConfigurationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiConfiguration", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiConfiguration> queryAllObjByExample(KpiConfigurationExample example) {
        return this.kpiConfigurationMapper.selectByExample(example);
    }

    @Cacheable(value="kpiConfiguration", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiConfiguration> queryObjByPage(KpiConfigurationExample example) {
        PageView<KpiConfiguration> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiConfigurationMapper.selectByExampleByPage(example));
        return pageView;
    }
}