package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiDeliveryRateMapper;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiDeliveryRateService")
public class KpiDeliveryRateServiceImpl implements KpiDeliveryRateService {
    @Resource
    protected KpiDeliveryRateMapper kpiDeliveryRateMapper;

    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void addObj(KpiDeliveryRate t) {
        this.kpiDeliveryRateMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void addAll(List<KpiDeliveryRate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiDeliveryRateMapper.insertBatch(list);
    }

    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiDeliveryRateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void deleteByExample(KpiDeliveryRateExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiDeliveryRateMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void modifyObj(KpiDeliveryRate t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiDeliveryRateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiDeliveryRate", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiDeliveryRate queryObjById(String id) {
        return this.kpiDeliveryRateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiDeliveryRate", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiDeliveryRate> queryAllObjByExample(KpiDeliveryRateExample example) {
        return this.kpiDeliveryRateMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiDeliveryRate", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiDeliveryRate> queryObjByPage(KpiDeliveryRateExample example) {
        PageView<KpiDeliveryRate> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiDeliveryRateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"kpiDeliveryRate"}, allEntries = true)
    @Override
    public void ImportFromExcel(List<KpiDeliveryRate> list) {
        List<KpiDeliveryRate> kpiDeliveryRatesAdd = new ArrayList<>();
        for (KpiDeliveryRate kpiDeliveryRate : list) {
            KpiDeliveryRateExample example = new KpiDeliveryRateExample();
            example.createCriteria().andSupCompanySapCodeEqualTo(kpiDeliveryRate.getSupCompanySapCode())
                    .andYearEqualTo(kpiDeliveryRate.getYear())
                    .andMonthEqualTo(kpiDeliveryRate.getMonth());
            List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                kpiDeliveryRate.setId(kpiDeliveryRates.get(0).getId());
                this.modifyObj(kpiDeliveryRate);
            } else {
                kpiDeliveryRate.setId(UUIDGenerator.generateUUID());
                kpiDeliveryRate.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                kpiDeliveryRate.setCreateTime(new Date());
                kpiDeliveryRate.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                kpiDeliveryRatesAdd.add(kpiDeliveryRate);
            }
        }
        if (kpiDeliveryRatesAdd.size() > 0) {
            this.kpiDeliveryRateMapper.insertBatch(kpiDeliveryRatesAdd);
        }

    }


    @Override
    public PageView<KpiOriginalExport> queryReportObjByPage(KpiOriginalExportExample example) {
        PageView<KpiOriginalExport> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiDeliveryRateMapper.selectReportByExampleByPage(example));
        return pageView;
    }


    @Override
    public List<KpiOriginalExport> queryReportAllObjByExample(KpiOriginalExportExample example) {
        return this.kpiDeliveryRateMapper.selectReportByExample(example);
    }
}