package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiEvaluateSectionMapper;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.service.KpiEvaluateSectionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiEvaluateSectionService")
public class KpiEvaluateSectionServiceImpl implements KpiEvaluateSectionService {
    @Resource
    protected KpiEvaluateSectionMapper kpiEvaluateSectionMapper;

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    @Override
    public void addObj(KpiEvaluateSection t) {
        this.kpiEvaluateSectionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    @Override
    public void addAll(List<KpiEvaluateSection> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiEvaluateSectionMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiEvaluateSectionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    @Override
    public void deleteByExample(KpiEvaluateSectionExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiEvaluateSectionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    @Override
    public void modifyObj(KpiEvaluateSection t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiEvaluateSectionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiEvaluateSection", keyGenerator="redisKeyGenerator")
    @Override
    public KpiEvaluateSection queryObjById(String id) {
        return this.kpiEvaluateSectionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiEvaluateSection", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiEvaluateSection> queryAllObjByExample(KpiEvaluateSectionExample example) {
        return this.kpiEvaluateSectionMapper.selectByExample(example);
    }

    @Cacheable(value="kpiEvaluateSection", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiEvaluateSection> queryObjByPage(KpiEvaluateSectionExample example) {
        PageView<KpiEvaluateSection> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiEvaluateSectionMapper.selectByExampleByPage(example));
        return pageView;
    }
}