package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiFormAndCompanyMapper;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.service.KpiFormAndCompanyService;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultKpiFormAndCompanyService")
public class KpiFormAndCompanyServiceImpl implements KpiFormAndCompanyService {
    @Resource
    protected KpiFormAndCompanyMapper kpiFormAndCompanyMapper;

    @CacheEvict(value = { "kpiFormAndCompany" }, allEntries = true)
    @Override
    public void addObj(KpiFormAndCompany t) {
        this.kpiFormAndCompanyMapper.insertSelective(t);
    }

    @CacheEvict(value = { "kpiFormAndCompany" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiFormAndCompanyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiFormAndCompany" }, allEntries = true)
    @Override
    public void modifyObj(KpiFormAndCompany t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.kpiFormAndCompanyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiFormAndCompany", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiFormAndCompany queryObjById(String id) {
        return this.kpiFormAndCompanyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiFormAndCompany", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiFormAndCompany> queryAllObjByExample(KpiFormAndCompanyExample example) {
        return this.kpiFormAndCompanyMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiFormAndCompany", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiFormAndCompany> queryObjByPage(KpiFormAndCompanyExample example) {
        PageView<KpiFormAndCompany> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiFormAndCompanyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<String> queryCompanyIdsByFormCode(String formCode) {
        KpiFormAndCompanyExample companyExample = new KpiFormAndCompanyExample();
        companyExample.createCriteria().andFormCodeEqualTo(formCode);
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.kpiFormAndCompanyMapper
                .selectByExample(companyExample);
        List<String> supCompanyIdList = new ArrayList<String>();
        for (int j = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && j < kpiFormAndCompanyList.size(); j++) {
            supCompanyIdList.add(kpiFormAndCompanyList.get(j).getSupCompanyId());
        }
        return supCompanyIdList;
    }
}