package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiFormAndPersonMapper;
import com.els.base.performance.entity.KpiFormAndPerson;
import com.els.base.performance.entity.KpiFormAndPersonExample;
import com.els.base.performance.service.KpiFormAndPersonService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultKpiFormAndPersonService")
public class KpiFormAndPersonServiceImpl implements KpiFormAndPersonService {
    @Resource
    protected KpiFormAndPersonMapper kpiFormAndPersonMapper;

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    @Override
    public void addObj(KpiFormAndPerson t) {
        this.kpiFormAndPersonMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiFormAndPersonMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    @Override
    public void modifyObj(KpiFormAndPerson t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.kpiFormAndPersonMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiFormAndPerson", keyGenerator="redisKeyGenerator")
    @Override
    public KpiFormAndPerson queryObjById(String id) {
        return this.kpiFormAndPersonMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiFormAndPerson", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiFormAndPerson> queryAllObjByExample(KpiFormAndPersonExample example) {
        return this.kpiFormAndPersonMapper.selectByExample(example);
    }

    @Cacheable(value="kpiFormAndPerson", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiFormAndPerson> queryObjByPage(KpiFormAndPersonExample example) {
        PageView<KpiFormAndPerson> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiFormAndPersonMapper.selectByExampleByPage(example));
        return pageView;
    }
}