package com.els.base.performance.service.impl;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import javax.annotation.Resource;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.performance.entity.*;
import com.els.base.performance.service.*;
import com.els.base.performance.utils.CalculateItem;
import com.els.base.performance.utils.DataGather;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.performance.dao.KpiFormMapper;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.entity.vo.KpiReport;
import com.els.base.performance.enums.KpiFormStatus;

/**
 * code is far away from bug with the animal protecting
 * ┏┓　　　┏┓
 * ┏┛┻━━━┛┻┓
 * ┃　　　　　　　┃
 * ┃　　　━　　　┃
 * ┃　┳┛　┗┳　┃
 * ┃　　　　　　　┃
 * ┃　　　┻　　　┃
 * ┃　　　　　　　┃
 * ┗━┓　　　┏━┛
 * 　　┃　　　┃神兽保佑
 * 　　┃　　　┃代码无BUG！
 * 　　┃　　　┗━━━┓
 * 　　┃　　　　　　　┣┓
 * 　　┃　　　　　　　┏┛
 * 　　┗┓┓┏━┳┓┏┛
 * 　　　┃┫┫　┃┫┫
 * 　　　┗┻┛　┗┻┛
 *
 * @Description :
 * ---------------------------------
 * @Author :
 * @Date :
 */
@Service("defaultKpiFormService")
public class KpiFormServiceImpl implements KpiFormService, ITaskListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected KpiFormMapper kpiFormMapper;

    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;

    @Resource
    protected KpiFormAndPersonService kpiFormAndPersonService;

    @Resource
    protected KpiRankingService kpiRankingService;

    @Resource
    protected KpiTemplateService kpiTemplateService;

    @Resource
    protected GenerateCodeService generateCodeService;

    @Resource
    protected KpiScoreService kpiScoreService;

    @Resource
    protected KpiProjectService kpiProjectService;

    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;

    @Resource
    protected KpiTemplateWeightService kpiTemplateWeightService;

    @Resource
    protected UserService userService;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected KpiAdverseEventService kpiAdverseEventService;

    @Resource
    protected WorkFlowService workFlowService;

    @Resource
    protected KpiConfigurationService kpiConfigurationService;

    @Resource
    protected KpiOriginalScoreService kpiOriginalScoreService;

    @Resource
    protected KpiQualifiedRateService kpiQualifiedRateService;
    @Resource
    protected KpiQualifiedBatchService kpiQualifiedBatchService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;
    @Resource
    protected KpiServiceFormService kpiServiceFormService;
    @Resource
    protected KpiServiceService kpiServiceService;
    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;

    @Resource
    private CompanyUserRefService companyUserRefService;

    static ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void addObj(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        t.setFormCode(formCode);
        this.kpiFormMapper.insertSelective(t);
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void modifyObj(KpiForm t) {
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void addObject(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        Company currentCompany = t.getCompany();
        com.els.base.auth.entity.User user = t.getUser();
        t.setCreateTime(new Date());
        t.setFormState(KpiFormStatus.NEW.getValue());
        t.setFormCalculation(Constant.NO_INT.toString());// 是否已计算，1：已计算，0或NULL为未计算
        t.setFormCode(formCode);
        t.setPurCompanyId(currentCompany.getId());
        t.setPurCompanyCode(currentCompany.getCompanyCode());
        t.setPurCompanyName(currentCompany.getCompanyName());
        t.setPurUserId(user.getId());
        t.setPurUserName(user.getNickName());
        KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(t.getKpiTemplateId());
        t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
        t.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        this.kpiFormMapper.insertSelective(t);
        addCompanyAndPersonInfo(t);
    }

    private void addCompanyAndPersonInfo(KpiForm t) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = t.getKpiFormAndCompanyList();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            addKpiCompany(t, kpiFormAndCompany);
        }
        for (KpiFormAndPerson kpiFormAndPerson : t.getKpiFormAndPersonList()) {
            addKpiPerson(t, kpiFormAndPerson);
        }
    }


    private void addKpiCompany(KpiForm t, KpiFormAndCompany kpiFormAndCompany) {
        Company currentCompany = t.getCompany();
        com.els.base.auth.entity.User user = t.getUser();

        kpiFormAndCompany.setKpiFormId(t.getId());
        kpiFormAndCompany.setFormCode(t.getFormCode());
        kpiFormAndCompany.setPurCompanyId(currentCompany.getId());
        kpiFormAndCompany.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndCompany.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndCompany.setPurUserId(user.getId());
        kpiFormAndCompany.setPurUserName(user.getNickName());
        kpiFormAndCompany.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndCompany.setLastUpdateUser(t.getLastUpdateUser());
        kpiFormAndCompany.setCategoryName(companyService.queryCompanyByCode(kpiFormAndCompany.getSupCompanySrmCode()).getCategoryName());
        this.kpiFormAndCompanyService.addObj(kpiFormAndCompany);
    }

    private void addKpiPerson(KpiForm t, KpiFormAndPerson kpiFormAndPerson) {
        Company currentCompany = t.getCompany();
        com.els.base.auth.entity.User user = t.getUser();
        kpiFormAndPerson.setKpiFormId(t.getId());
        kpiFormAndPerson.setFormCode(t.getFormCode());
        kpiFormAndPerson.setPurCompanyId(currentCompany.getId());
        kpiFormAndPerson.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndPerson.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndPerson.setPurUserId(user.getId());
        kpiFormAndPerson.setPurUserName(user.getNickName());
        kpiFormAndPerson.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndPerson.setLastUpdateUser(t.getLastUpdateUser());
        this.kpiFormAndPersonService.addObj(kpiFormAndPerson);
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        deleteKpiCompanyAndPerson(id);
        this.kpiFormMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void modifyObject(KpiForm t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        com.els.base.auth.entity.User user = t.getUser();
        KpiForm kpiForm = this.kpiFormMapper.selectByPrimaryKey(t.getId());
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(user.getNickName());
        t.setFormCode(kpiForm.getFormCode());
        deleteKpiCompanyAndPerson(t.getId());
        addCompanyAndPersonInfo(t);
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    private void deleteKpiCompanyAndPerson(String kpiId) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = queryCompanyInfoByKpiId(kpiId);
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            this.kpiFormAndCompanyService.deleteObjById(kpiFormAndCompany.getId());
        }
        List<KpiFormAndPerson> kpiFormAndPersonList = queryPersonInfoByKpiId(kpiId);
        for (KpiFormAndPerson kpiFormAndPerson : kpiFormAndPersonList) {
            this.kpiFormAndPersonService.deleteObjById(kpiFormAndPerson.getId());
        }
    }

    @Cacheable(value = "kpiForm", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiForm queryObjById(String id) {
        return this.kpiFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiForm", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiForm> queryAllObjByExample(KpiFormExample example) {
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormList) && i < kpiFormList.size(); i++) {
            KpiForm kpiForm = kpiFormList.get(i);
            kpiForm.setKpiFormAndCompanyList(queryCompanyInfoByKpiId(kpiForm.getId()));
            kpiForm.setKpiFormAndPersonList(queryPersonInfoByKpiId(kpiForm.getId()));
        }
        return kpiFormList;
    }

    // @Cacheable(value = "kpiForm", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiForm> queryAllObjByExampleCoustom(KpiFormExample example) {
        return this.kpiFormMapper.selectByExample(example);
    }

    //    @Cacheable(value = "kpiForm", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiForm> queryObjByPage(KpiFormExample example) {
        PageView<KpiForm> pageView = example.getPageView();
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExampleByPage(example);
        pageView.setQueryResult(kpiFormList);
        return pageView;
    }

    private List<KpiFormAndPerson> queryPersonInfoByKpiId(String kpiFormId) {
        KpiFormAndPersonExample example = new KpiFormAndPersonExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService
                .queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); i++) {
            User user = this.userService.queryObjById(kpiFormAndPersonList.get(i).getPersonUserId());
            kpiFormAndPersonList.get(i).setLoginName(user.getLoginName());
        }
        return kpiFormAndPersonList;
    }

    @Override
    public List<KpiFormAndCompany> queryCompanyInfoByKpiId(String kpiFormId) {
        KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.kpiFormAndCompanyService
                .queryAllObjByExample(example);

        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); i++) {
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeEqualTo(
                    kpiFormAndCompanyList.get(i).getSupCompanySrmCode());
            List<Company> companyList = this.companyService.queryAllObjByExample(companyExample);
            kpiFormAndCompanyList.get(i).setPurCompanyCategory(companyList.get(0).getFirstCompanyType());
            kpiFormAndCompanyList.get(i).setPurCompanyRank(companyList.get(0).getGrade());
        }

        return kpiFormAndCompanyList;
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    @Transactional
    public void finishForm(KpiForm kpiForm) {
        // 根据主键获取评估表信息
        KpiForm form = queryObjById(kpiForm.getId());
        if (form == null) {
            throw new CommonException("对应的评估表数据不存在不能进行结案", "do_not_exists", "评估表数据");
        }

        // 根据模板id获取评估模板的供应商等级
        KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(form.getKpiTemplateId());
        if (kpiTemplate == null) {
            throw new CommonException("对应的模板数据不存在不能进行结案", "do_not_exists", "评估模板数据");
        }

        // =========================begin更新评估表信息============
        Date date = new Date();
        KpiForm kpiFormVO = new KpiForm();
        kpiFormVO.setId(kpiForm.getId());// 主键id
        kpiFormVO.setFormCode(kpiForm.getFormCode());// 评估表编码
        kpiFormVO.setFormState("2");// 状态 0-新建,1-进行中,2-已完成
        kpiFormVO.setFormFactTime(date);// 实际完成时间
        kpiFormVO.setLastUpdateUser(kpiForm.getUser().getNickName());// 最后更新人
        kpiFormVO.setLastUpdateTime(date);// 最后更新时间

        // 根据主键更新评估表信息
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVO);
        // =========================end更新评估表信息============

        // 插入数据前先删除
        // 拼接条件
        KpiRankingExample kpiRankingExample = new KpiRankingExample();
        KpiRankingExample.Criteria rankingCriteria = kpiRankingExample.createCriteria();
        rankingCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        rankingCriteria.andFormCodeEqualTo(kpiForm.getFormCode());

        this.kpiRankingService.deleteByExample(kpiRankingExample);

        // 根据评估表id和编码获取评估的供应商列表
        // 拼接条件
        KpiFormAndCompanyExample kpiFormAndCompanyExample = new KpiFormAndCompanyExample();
        KpiFormAndCompanyExample.Criteria formAndCompanyCriteria = kpiFormAndCompanyExample.createCriteria();
        formAndCompanyCriteria.andKpiFormIdEqualTo(kpiForm.getId());// 评估表id
        formAndCompanyCriteria.andFormCodeEqualTo(kpiForm.getFormCode());// 评估表编码
        List<KpiFormAndCompany> kpiFormAndCompany = this.kpiFormAndCompanyService
                .queryAllObjByExample(kpiFormAndCompanyExample);
        // 循环评估表的每个供应商
        for (KpiFormAndCompany formAndCompany : kpiFormAndCompany) {
            // 获取同一个供应商，分类，等级的最近一次评估的分数
            KpiRanking t = new KpiRanking();
            t.setSupCompanyId(formAndCompany.getSupCompanyId());
            t.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());

            // 根据供应商id和编码获取上次评分的等级信息,此处是一条记录
            KpiRanking lastKpiRanking = this.kpiRankingService.selectByCustom(t);

            KpiRanking currKpiRanking = new KpiRanking();
            currKpiRanking.setPurCompanyId(kpiForm.getCompany().getId());//
            currKpiRanking.setPurCompanyCode(kpiForm.getCompany().getCompanyCode());
            currKpiRanking.setPurCompanyName(kpiForm.getCompany().getCompanyName());
            currKpiRanking.setPurUserId(kpiForm.getUser().getId());
            currKpiRanking.setPurUserName(kpiForm.getUser().getNickName());
            currKpiRanking.setKpiFormId(form.getId());// 评估表id
            currKpiRanking.setFormName(form.getFormName());// 评估表名称
            currKpiRanking.setFormPublishTime(form.getFormStartTime());// 开始时间
            currKpiRanking.setFormFactTime(date);//
            currKpiRanking.setSupCompanyId(formAndCompany.getSupCompanyId());//
            currKpiRanking.setSupCompanySapCode(formAndCompany.getSupCompanySapCode());//
            currKpiRanking.setSupCompanyName(formAndCompany.getSupCompanyName());//
            currKpiRanking.setSupUserName(formAndCompany.getSupUserName());//
            currKpiRanking.setSupUserId(formAndCompany.getSupUserId());//
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setCreateTime(new Date());// 创建时间
            currKpiRanking.setLastUpdateTime(new Date());// 最后更新时间
            currKpiRanking.setLastUpdateUser(kpiForm.getUser().getNickName());// 最后更新人
            // 条件
            currKpiRanking.setFormCode(kpiForm.getFormCode());// 评估表编码
            currKpiRanking.setTemplateCode(kpiTemplate.getTemplateCode());// 模板编码
            currKpiRanking.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());// 供应商编码
            currKpiRanking.setRankingScore(lastKpiRanking == null ? null : lastKpiRanking.getRankingScore());// 上次评估结果的分数
            // 更新原始值
            this.kpiRankingService.insertCustom(currKpiRanking);
        }

    }

    /**
     * 更新原始分数
     *
     * @param currKpiRanking 记录
     */
    private void updateOriginalScore(KpiRanking currKpiRanking) {
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(currKpiRanking.getKpiFormId())
                .andCompanySrmCodeEqualTo(currKpiRanking.getSupCompanySrmCode());
        List<KpiOriginalScore> kpiOriginalScores = kpiOriginalScoreService.queryAllObjByExample(example);
        logger.info("kpiOriginalScores.size:" + kpiOriginalScores.size());
        if (CollectionUtils.isNotEmpty(kpiOriginalScores)) {
            KpiOriginalScore score = kpiOriginalScores.get(0);
            logger.info("score:" + score);
            KpiRanking ranking = new KpiRanking();
            //ranking.setOriginalService(score.getOriginalService());
            //ranking.setOriginalQualityCount(score.getOriginalQualityCount());
            //ranking.setOriginalQuality(score.getOriginalQuality());
            //ranking.setOriginalPrice(score.getOriginalPrice());
            //ranking.setOriginalDeliver(score.getOriginalDeliver());
            KpiRankingExample example1 = new KpiRankingExample();
            example.createCriteria().andKpiFormIdEqualTo(currKpiRanking.getKpiFormId())
                    .andCompanySrmCodeEqualTo(currKpiRanking.getSupCompanySrmCode());
            kpiRankingService.updateByExampleSelective(ranking, example1);
        }
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void releaseKpiFrom(KpiForm kpiForm) {
        if (kpiForm.getFormState() != null && !kpiForm.getFormState().equals(KpiFormStatus.NEW.getValue())) {
            throw new CommonException("已经发布，不可重复操作", "repeat_release");
        }
        Company currentCompany = kpiForm.getCompany();
        com.els.base.auth.entity.User user = kpiForm.getUser();
        KpiForm form = new KpiForm();
        form.setId(kpiForm.getId());
        form.setFormPlanTime(kpiForm.getFormPlanTime());
        form.setFormState(KpiFormStatus.ONGOING.getValue());
        form.setFormPublishTime(new Date());
        this.kpiFormMapper.updateByPrimaryKeySelective(form);
        // 查询评估项
        List<KpiTemplateItem> kpiTemplateItemList = queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        // 数据插入评分表
        List<KpiFormAndCompany> kpiFormAndCompanyList = queryCompanyInfoByKpiId(kpiForm.getId());
        Date time = kpiForm.getFormStartTime();
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        int month = ca.get(Calendar.MONTH) + 1;//第几个月
        int year = ca.get(Calendar.YEAR);//年份数值
        //服务全部打分
        KpiServiceExample serviceExample = new KpiServiceExample();
        serviceExample.createCriteria().andYearEqualTo(String.valueOf(year))
                .andMonthEqualTo(String.valueOf(month));
        List<KpiService> kpiServices = this.kpiServiceService.queryAllObjByExample(serviceExample);
        //合格率全部原始数据
        KpiQualifiedRateExample qualifiedRateExample = new KpiQualifiedRateExample();
        qualifiedRateExample.createCriteria().andYearEqualTo(String.valueOf(year))
                .andMonthEqualTo(String.valueOf(month));
        List<KpiQualifiedRate> kpiQualifiedRates = this.kpiQualifiedRateService.queryAllObjByExample(qualifiedRateExample);

        //交付率全部原始数据
        KpiDeliveryRateExample deliveryRateExample = new KpiDeliveryRateExample();
        deliveryRateExample.createCriteria().andYearEqualTo(String.valueOf(year))
                .andMonthEqualTo(String.valueOf(month));
        List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample(deliveryRateExample);
        //质量次数全部原始数据
        KpiQualifiedBatchExample qualifiedBatchExample = new KpiQualifiedBatchExample();
        qualifiedBatchExample.createCriteria().andYearEqualTo(String.valueOf(year))
                .andMonthEqualTo(String.valueOf(month));
        List<KpiQualifiedBatch> kpiQualifiedBatchs = this.kpiQualifiedBatchService.queryAllObjByExample(qualifiedBatchExample);
        //交付及时率计算区间值
        KpiEvaluateSectionExample kpiEvaluateSectionExample = new KpiEvaluateSectionExample();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("deliver");
        List<KpiEvaluateSection> kpiEvaluateSectionsDeliver = kpiEvaluateSectionService.queryAllObjByExample(kpiEvaluateSectionExample);
        //交付合格率计算区间值
        kpiEvaluateSectionExample.clear();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("quality");
        List<KpiEvaluateSection> kpiEvaluateSectionsQuality = kpiEvaluateSectionService.queryAllObjByExample(kpiEvaluateSectionExample);
        //质量次数计算区间值
        kpiEvaluateSectionExample.clear();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("qualityCount");
        List<KpiEvaluateSection> kpiEvaluateSectionsQualityCount = kpiEvaluateSectionService.queryAllObjByExample(kpiEvaluateSectionExample);


        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); i++) {
            KpiScore kpiScore = new KpiScore();
            kpiScore.setPurCompanyId(currentCompany.getId());
            kpiScore.setPurCompanyCode(currentCompany.getCompanyCode());
            kpiScore.setPurCompanyName(currentCompany.getCompanyName());
            kpiScore.setPurUserId(user.getId());
            kpiScore.setPurUserName(user.getUsername());
            kpiScore.setKpiFormId(kpiForm.getId());
            kpiScore.setFormCode(kpiForm.getFormCode());
            kpiScore.setFormName(kpiForm.getFormName());
            kpiScore.setSupCompanyId(kpiFormAndCompanyList.get(i).getSupCompanyId());
            kpiScore.setSupCompanySrmCode(kpiFormAndCompanyList.get(i).getSupCompanySrmCode());
            kpiScore.setSupCompanySapCode(kpiFormAndCompanyList.get(i).getSupCompanySapCode());
            kpiScore.setSupCompanyName(kpiFormAndCompanyList.get(i).getSupCompanyName());
            kpiScore.setSupUserId(kpiFormAndCompanyList.get(i).getSupUserId());
            kpiScore.setSupUserName(kpiFormAndCompanyList.get(i).getSupUserName());
            for (int j = 0; CollectionUtils.isNotEmpty(kpiTemplateItemList) && j < kpiTemplateItemList.size(); j++) {
                kpiScore.setKpiTemplateId(kpiTemplateItemList.get(j).getKpiTemplateId());
                kpiScore.setTemplateCode(kpiTemplateItemList.get(j).getTemplateCode());
                KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(kpiTemplateItemList.get(j)
                        .getKpiTemplateId());
                kpiScore.setTemplateName(kpiTemplate.getTemplateName());
                // 查询评估人id和name
                KpiFormAndPersonExample personExample = new KpiFormAndPersonExample();
                personExample.createCriteria().andFormCodeEqualTo(kpiForm.getFormCode())
                        .andProjectTypeEqualTo(kpiTemplateItemList.get(j).getProjectType());
                List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService
                        .queryAllObjByExample(personExample);
                if (CollectionUtils.isNotEmpty(kpiFormAndPersonList)) {
                    kpiScore.setPersonUserId(kpiFormAndPersonList.get(0).getPersonUserId());
                    kpiScore.setPersonUserName(kpiFormAndPersonList.get(0).getPersonUserName());
                }
                kpiScore.setKpiProjectId(kpiTemplateItemList.get(j).getKpiProjectId());
                kpiScore.setProjectCode(kpiTemplateItemList.get(j).getProjectCode());
                kpiScore.setProjectName(kpiTemplateItemList.get(j).getProjectName());
                kpiScore.setProjectType(kpiTemplateItemList.get(j).getProjectType());
                kpiScore.setProjectHandlType(kpiTemplateItemList.get(j).getProjectHandlType());
                kpiScore.setProjectMethodType(kpiTemplateItemList.get(j).getProjectMethodType());
                kpiScore.setProjectMethodParameter(kpiTemplateItemList.get(j).getProjectMethodParameter());
                kpiScore.setProjectTypeName(kpiTemplateItemList.get(j).getProjectTypeName());
                kpiScore.setProjectWeight(kpiTemplateItemList.get(j).getProjectWeight());
                kpiScore.setScoreState(Constant.NO_INT.toString());// 状态: 1 未提交，2 已提交
                kpiScore.setCreateTime(new Date());
                kpiScore.setId(null);
                kpiScore.setScoreScore("");
                kpiScore.setOriginalValue("");
                kpiScore.setCorrectionValue("");
                switch (kpiScore.getProjectType()) {
                    case "service"://服务
                        for (KpiService kpiService : kpiServices) {
                            if (kpiService.getSupCompanySapCode().equals(kpiScore.getSupCompanySapCode())) {
                                kpiScore.setScoreScore(String.valueOf(kpiService.getScore()));
                                kpiScore.setOriginalValue(String.valueOf(kpiService.getScore()));
                                kpiScore.setCorrectionValue(String.valueOf(kpiService.getScore()));
                                break;
                            }
                        }
                        break;
                    case "quality"://交付合格率
                        boolean qualityCorrectionValue = false;
                        for (KpiQualifiedRate kpiQualifiedRate : kpiQualifiedRates) {
                            if (StringUtils.isNotEmpty(kpiQualifiedRate.getSupCompanySapCode())) {
                                if (kpiScore.getSupCompanySapCode().equals(kpiQualifiedRate.getSupCompanySapCode())) {
                                    kpiScore.setOriginalValue(kpiQualifiedRate.getQualifieDrate());
                                    kpiScore.setCorrectionValue(kpiQualifiedRate.getQualifieDrate());
                                    qualityCorrectionValue = true;
                                    break;
                                }
                            } else {
                                if (kpiScore.getSupCompanyName().equals(kpiQualifiedRate.getSupCompanyName())) {
                                    kpiScore.setOriginalValue(kpiQualifiedRate.getQualifieDrate());
                                    kpiScore.setCorrectionValue(kpiQualifiedRate.getQualifieDrate());
                                    qualityCorrectionValue = true;
                                    break;
                                }
                            }
                        }
                        if (qualityCorrectionValue) {
                            //String originalValue = kpiScore.getOriginalValue();
                            String originalValue = kpiScore.getCorrectionValue();

                            for (KpiEvaluateSection kpiEvaluateSectionQR : kpiEvaluateSectionsQuality) {
                                originalValue = originalValue.replace(kpiEvaluateSectionQR.getSectionType(), "");
                                double qualityOriginalValue = Double.valueOf(originalValue);
                                if (qualityOriginalValue >= kpiEvaluateSectionQR.getStartSection()
                                        && qualityOriginalValue <= kpiEvaluateSectionQR.getEndSection()) {
                                    if (StringUtils.isEmpty(kpiEvaluateSectionQR.getCoefficient())
                                            && !"0".equals(kpiEvaluateSectionQR.getCoefficient())) {
                                        kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionQR.getScore()));
                                    } else {
                                        double coefficient = Double.valueOf(kpiEvaluateSectionQR.getCoefficient());
                                        double scorequality = qualityOriginalValue * coefficient;
                                        DecimalFormat df = new DecimalFormat("#.00");
                                        String str = df.format(scorequality);
                                        kpiScore.setScoreScore(str);
                                    }

                                }
                            }
                        }
                        break;
                    case "deliver"://交付及时率
                        boolean diverCorrectionValue = false;
                        for (KpiDeliveryRate kpiDeliveryRate : kpiDeliveryRates) {
                            if (kpiScore.getSupCompanySapCode().equals(kpiDeliveryRate.getSupCompanySapCode())) {
                                kpiScore.setOriginalValue(kpiDeliveryRate.getFirstEdition());
                                kpiScore.setCorrectionValue(kpiDeliveryRate.getSecondEdition());
                                diverCorrectionValue = true;
                                break;
                            }
                        }
                        if (diverCorrectionValue) {
                            //String originalValue = kpiScore.getOriginalValue();
                            String originalValue = kpiScore.getCorrectionValue();
                            for (KpiEvaluateSection kpiEvaluateSectionD : kpiEvaluateSectionsDeliver) {
                                originalValue = originalValue.replace(kpiEvaluateSectionD.getSectionType(), "");
                                double deliverOriginalValue = Double.valueOf(originalValue);
                                if (deliverOriginalValue >= kpiEvaluateSectionD.getStartSection()
                                        && deliverOriginalValue <= kpiEvaluateSectionD.getEndSection()) {
                                    if (StringUtils.isEmpty(kpiEvaluateSectionD.getCoefficient())
                                            && !"0".equals(kpiEvaluateSectionD.getCoefficient())) {
                                        kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionD.getScore()));
                                    } else {
                                        double coefficient = Double.valueOf(kpiEvaluateSectionD.getCoefficient());
                                        double scorequality = deliverOriginalValue * coefficient;
                                        DecimalFormat df = new DecimalFormat("#.00");
                                        String str = df.format(scorequality);
                                        kpiScore.setScoreScore(str);
                                    }

                                }
                            }
                        }

                        break;
                    case "qualityCount"://质量次数
                        int qualitycount = 0;
                        for (KpiQualifiedBatch kpiQualifiedBatch:kpiQualifiedBatchs) {
                            if (kpiScore.getSupCompanySapCode().equals(kpiQualifiedBatch.getSupCompanySapCode())) {
                                qualitycount++;
                            }
                        }
                        for (KpiEvaluateSection kpiEvaluateSectionQC : kpiEvaluateSectionsQualityCount) {
                            if (qualitycount >= kpiEvaluateSectionQC.getStartSection() && qualitycount <= kpiEvaluateSectionQC.getEndSection()) {
                                kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionQC.getScore()));
                                break;
                            }
                        }
                        kpiScore.setOriginalValue(String.valueOf(qualitycount));
                        kpiScore.setCorrectionValue(String.valueOf(qualitycount));
                        break;
                }
                this.kpiScoreService.addObj(kpiScore);
            }
        }
    }

    @Override
    public KpiFormVo lookAtTheScore(KpiForm kpiForm) {
        KpiFormVo kpiFormVo = new KpiFormVo();
        kpiFormVo.setKpiFormId(kpiForm.getId());
        kpiFormVo.setFormCode(kpiForm.getFormCode());
        kpiFormVo.setFormName(kpiForm.getFormName());
        kpiFormVo.setKpiTemplateId(kpiForm.getKpiTemplateId());
        kpiFormVo.setTemplateCode(kpiForm.getTemplateCode());
        kpiFormVo.setFormStartTime(kpiForm.getFormStartTime());
        kpiFormVo.setFormEndTime(kpiForm.getFormEndTime());
        KpiFormVo stateAndPersonAndWeight = queryStateAndPersonAndWeight(kpiForm);// 查询评分状态，评分人，类别权重
        kpiFormVo.setScoreState(stateAndPersonAndWeight.getScoreState());
        kpiFormVo.setScorePerson(stateAndPersonAndWeight.getScorePerson());
        kpiFormVo.setClassWeight(stateAndPersonAndWeight.getClassWeight());
        KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(kpiForm.getKpiTemplateId());
        if (kpiTemplate != null) {
            kpiFormVo.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            kpiFormVo.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        }
        KpiFormVo kFormVo = assembleKpiFormData(kpiForm, kpiFormVo);
        return kFormVo;
    }

//    @Override
//    public KpiFormVo lookAtTheScoreAll(KpiForm kpiForm) {
//        KpiFormVo kpiFormVo = new KpiFormVo();
//        kpiFormVo.setKpiFormId(kpiForm.getId());
//        kpiFormVo.setFormCode(kpiForm.getFormCode());
//        kpiFormVo.setFormName(kpiForm.getFormName());
//        kpiFormVo.setKpiTemplateId(kpiForm.getKpiTemplateId());
//        kpiFormVo.setTemplateCode(kpiForm.getTemplateCode());
//        kpiFormVo.setFormStartTime(kpiForm.getFormStartTime());
//        kpiFormVo.setFormEndTime(kpiForm.getFormEndTime());
//        KpiFormVo stateAndPersonAndWeight = queryStateAndPersonAndWeight(kpiForm);// 查询评分状态，评分人，类别权重
//        kpiFormVo.setScoreState(stateAndPersonAndWeight.getScoreState());
//        kpiFormVo.setScorePerson(stateAndPersonAndWeight.getScorePerson());
//        kpiFormVo.setClassWeight(stateAndPersonAndWeight.getClassWeight());
//        KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(kpiForm.getKpiTemplateId());
//        if (kpiTemplate != null) {
//            kpiFormVo.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
//            kpiFormVo.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
//        }
//        KpiFormVo kFormVo = assembleKpiFormDataAll(kpiForm, kpiFormVo);
//        return kFormVo;
//    }


    private KpiFormVo queryStateAndPersonAndWeight(KpiForm kpiForm) {
        KpiFormVo kpiFormVo = new KpiFormVo();
        // 状态: 0 未提交，1 已提交
        List<String> scoreStateList = new ArrayList<String>();
        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());

        List<String> roleCodeList = kpiForm.getRoleCodeList();
        // 如果当前用户没有对应的三种角色，则不可以查看所有评分，只能查看分配给自己的数据
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                && !roleCodeList.contains("supplier")) {
            criteria.andPersonUserIdEqualTo(kpiForm.getUser().getId());
        }

        List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiScoreList) && i < kpiScoreList.size(); i++) {
            scoreStateList.add(kpiScoreList.get(i).getScoreState());
        }
        if (CollectionUtils.isNotEmpty(scoreStateList)) {
            if (Collections.frequency(scoreStateList, "1") == scoreStateList.size()) {
                kpiFormVo.setScoreState(Constant.YES_INT.toString());
            } else {
                kpiFormVo.setScoreState(Constant.NO_INT.toString());
            }
        }

        // 评估人名称
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                && !roleCodeList.contains("supplier")) {
            kpiFormVo.setScorePerson(kpiForm.getUser().getNickName() == null ? "【"
                    + kpiForm.getUser().getLoginName() + "】" : kpiForm.getUser().getNickName() + "【"
                    + kpiForm.getUser().getLoginName() + "】");
        } else {
            List<KpiFormAndPerson> infoByKpiId = queryPersonInfoByKpiId(kpiForm.getId());
            List<String> stringList = new ArrayList<String>();
            for (KpiFormAndPerson kpiFormAndPerson : infoByKpiId) {
                User user = this.userService.queryObjById(kpiFormAndPerson.getPersonUserId());
                stringList.add(kpiFormAndPerson.getPersonUserName() == null ? "【" + user.getLoginName() + "】"
                        : kpiFormAndPerson.getPersonUserName() + "【" + user.getLoginName() + "】");
            }
            kpiFormVo.setScorePerson(stringList.toString().replaceAll("[\\[\\]]", ""));
        }

        // 评估项权重
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                && !roleCodeList.contains("supplier")) {
            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId())
                    .andKpiFormIdEqualTo(kpiForm.getId());
            List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService
                    .queryAllObjByExample(example);
            StringBuffer weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList)
                    && i < kpiFormAndPersonList.size(); i++) {
                KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
                weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId())
                        .andProjectTypeEqualTo(kpiFormAndPersonList.get(i).getProjectType());
                List<KpiTemplateWeight> kpiTemplateWeightList = this.kpiTemplateWeightService
                        .queryAllObjByExample(weightExample);
                for (int j = 0; CollectionUtils.isNotEmpty(kpiTemplateWeightList)
                        && j < kpiTemplateWeightList.size(); j++) {
                    weightBuffer.append("【").append(kpiTemplateWeightList.get(j).getProjectTypeName())
                            .append("】").append(":")
                            .append(kpiTemplateWeightList.get(j).getProjectTypeWeight()).append(",");
                }
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        } else {
            KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
            weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId());
            List<KpiTemplateWeight> kpiTemplateWeightList = this.kpiTemplateWeightService
                    .queryAllObjByExample(weightExample);
            StringBuffer weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty(kpiTemplateWeightList)
                    && i < kpiTemplateWeightList.size(); i++) {
                weightBuffer.append("【").append(kpiTemplateWeightList.get(i).getProjectTypeName())
                        .append("】").append(":").append(kpiTemplateWeightList.get(i).getProjectTypeWeight())
                        .append(",");
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        }
        return kpiFormVo;
    }

    private KpiFormVo assembleKpiFormData(KpiForm kpiForm, KpiFormVo kpiFormVo) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        List<KpiTemplateItem> kpiTemplateItemList = new ArrayList<KpiTemplateItem>();
        // 查询评估項
        // 如果当前用户没有对应的三种角色，则不可以查看所有评分，只能查看分配给自己的数据
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                && !roleCodeList.contains("supplier")) {
            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId())
                    .andKpiFormIdEqualTo(kpiForm.getId());
            List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService
                    .queryAllObjByExample(example);
            for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList)
                    && i < kpiFormAndPersonList.size(); i++) {
                KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
                templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId())
                        .andProjectTypeEqualTo(kpiFormAndPersonList.get(i).getProjectType());
                kpiTemplateItemList.addAll(this.kpiTemplateItemService
                        .queryAllObjByExample(templateItemExample));
            }
        } else if (CollectionUtils.isEmpty(kpiTemplateItemList)) {
            kpiTemplateItemList = queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        }
        List<String> ProjectCodeArray = new ArrayList<>();
        List<Map<String, String>> titles = new ArrayList<>();// 标题
        StringBuffer titleBuffer = new StringBuffer();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {

            Map<String, String> titleMap = new HashMap<String, String>();
            titleBuffer.setLength(0);
            titleBuffer.append("【").append(kpiTemplateItem.getProjectTypeName()).append("】")
                    .append(kpiTemplateItem.getProjectName());
            titleMap.put("projectCode", kpiTemplateItem.getProjectCode());
            titleMap.put("projectName", titleBuffer.toString());
            titleMap.put("projectStandard", kpiTemplateItem.getProjectStandard());
            titleMap.put("projectInstruction", kpiTemplateItem.getProjectInstruction());
            KpiProjectExample kpiProjectExample = new KpiProjectExample();
            kpiProjectExample.createCriteria().andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
            List<KpiProject> KpiProjectList = this.kpiProjectService.queryAllObjByExample(kpiProjectExample);
            if (CollectionUtils.isNotEmpty(KpiProjectList)
                    && KpiProjectList.get(0).getProjectHandlType() != null
                    && KpiProjectList.get(0).getProjectHandlType().equals("2")) {
                titleMap.put("getOfApi", Constant.YES_STRING);
            }
            titleMap.put("latitude", KpiProjectList.get(0).getProjectDimension());
            if (SpringSecurityUtils.getLoginUserId().equals("1")) {
                titles.add(titleMap);
            } else {
                KpiFormAndPersonExample kpiFormAndPersonExample = new KpiFormAndPersonExample();
                kpiFormAndPersonExample.createCriteria().andKpiFormIdEqualTo(kpiForm.getId())
                        .andPersonUserIdEqualTo(SpringSecurityUtils.getLoginUserId())
                        .andFormCodeEqualTo(kpiForm.getFormCode())
                        .andProjectTypeEqualTo(kpiTemplateItem.getProjectType());
                List<KpiFormAndPerson> KpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(kpiFormAndPersonExample);

                if (CollectionUtils.isNotEmpty(KpiFormAndPersonList)) {
                    titles.add(titleMap);
                    ProjectCodeArray.add(kpiTemplateItem.getProjectCode());
                }
            }

        }

        // 查询供应商
        List<KpiFormAndCompany> kpiFormAndCompanyList = queryCompanyInfoByKpiId(kpiForm.getId());

        List<Map<String, Object>> kpiFormVoItemList = new ArrayList<>();// 内容
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            Map<String, Object> kpiFormVoItem = new HashMap<>();
            kpiFormVoItem.put("supplierSapCode", kpiFormAndCompany.getSupCompanySapCode());
            kpiFormVoItem.put("supplierSrmCode", kpiFormAndCompany.getSupCompanySrmCode());
            kpiFormVoItem.put("supplierSrmName", kpiFormAndCompany.getSupCompanyName());
            kpiFormVoItem.put("categoryName", kpiFormAndCompany.getCategoryName());
            // 根据模板id,评估表id,供应商编码，评估项编码获取评分表对应评估项的分数

            List<KpiScore> scoreList = getScore(kpiFormAndCompany, kpiTemplateItemList);
            for (KpiScore score : scoreList) {
                if (StringUtils.isNotEmpty(score.getScoreScore())) {
                    kpiFormVoItem.put(score.getProjectCode(), new HashMap<String, String>() {{
                        put("originalScore", score.getOriginalValue());
                        put("correctionValue", score.getCorrectionValue());
                        put("score", score.getScoreScore());
                    }});
                } else {
                    kpiFormVoItem.put(score.getProjectCode(), new HashMap<String, Integer>() {{
                        put("originalScore", null);
                        put("correctionValue", null);
                        put("score", null);
                    }});
                }
            }
            kpiFormVoItemList.add(kpiFormVoItem);
        }
        kpiFormVo.setTitles(titles);
        kpiFormVo.setKpiFormVoItemList(kpiFormVoItemList);
        return kpiFormVo;
    }

    private Map<String, String> getScoreMap(KpiScore score) {
        Map<String, String> map = new HashMap<>();
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(score.getKpiFormId())
                .andCompanySrmCodeEqualTo(score.getSupCompanySrmCode());
        List<KpiOriginalScore> originalScores = kpiOriginalScoreService.queryAllObjByExample(example);
        map.put("score", score.getScoreScore());
        if (CollectionUtils.isEmpty(originalScores)) {
            map.put("originalScore", null);
            return map;
        }
        KpiOriginalScore originalScore = originalScores.get(0);
        switch (score.getProjectType()) {
            case "deliver":
                map.put("originalScore", originalScore.getOriginalDeliver());
                break;
            case "service":
                map.put("originalScore", originalScore.getOriginalService());
                break;
            case "price":
                map.put("originalScore", originalScore.getOriginalPrice());
                break;
            case "quality":
                map.put("originalScore", originalScore.getOriginalQuality());
                break;
            case "qualityCount":
                map.put("originalScore", originalScore.getOriginalQualityCount());
                break;
        }
        return map;
    }

//    private KpiFormVo assembleKpiFormDataAll(KpiForm kpiForm, KpiFormVo kpiFormVo) {
//        List<String> roleCodeList = kpiForm.getRoleCodeList();
//        List<KpiTemplateItem> kpiTemplateItemList = new ArrayList<KpiTemplateItem>();
//        // 查询评估項
//        // 如果当前用户没有对应的三种角色，则不可以查看所有评分，只能查看分配给自己的数据
//        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
//                && !roleCodeList.contains("supplier")) {
//            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
//            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId())
//                    .andKpiFormIdEqualTo(kpiForm.getId());
//            List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService
//                    .queryAllObjByExample(example);
//            for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList)
//                    && i < kpiFormAndPersonList.size(); i++) {
//                KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
//                templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId())
//                        .andProjectTypeEqualTo(kpiFormAndPersonList.get(i).getProjectType());
//                kpiTemplateItemList.addAll(this.kpiTemplateItemService
//                        .queryAllObjByExample(templateItemExample));
//            }
//        } else if (CollectionUtils.isEmpty(kpiTemplateItemList)) {
//            kpiTemplateItemList = queryKpiTemplateItem(kpiForm.getKpiTemplateId());
//        }
//        List<String> ProjectCodeArray = new ArrayList<>();
//        List<Map<String, String>> titles = new ArrayList<Map<String, String>>();// 标题
//        StringBuffer titleBuffer = new StringBuffer();
//        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
//
//            Map<String, String> titleMap = new HashMap<String, String>();
//            titleBuffer.setLength(0);
//            titleBuffer.append("【").append(kpiTemplateItem.getProjectTypeName()).append("】")
//                    .append(kpiTemplateItem.getProjectName());
//            titleMap.put("projectCode", kpiTemplateItem.getProjectCode());
//            titleMap.put("projectName", titleBuffer.toString());
//            titleMap.put("projectStandard", kpiTemplateItem.getProjectStandard());
//            titleMap.put("projectInstruction", kpiTemplateItem.getProjectInstruction());
//            KpiProjectExample kpiProjectExample = new KpiProjectExample();
//            kpiProjectExample.createCriteria().andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
//            List<KpiProject> KpiProjectList = this.kpiProjectService.queryAllObjByExample(kpiProjectExample);
//            if (CollectionUtils.isNotEmpty(KpiProjectList)
//                    && KpiProjectList.get(0).getProjectHandlType() != null
//                    && KpiProjectList.get(0).getProjectHandlType().equals("2")) {
//                titleMap.put("getOfApi", Constant.YES_STRING);
//            }
//            titleMap.put("latitude", KpiProjectList.get(0).getProjectDimension());
//            titles.add(titleMap);
//
//        }
//
//        // 查询供应商
//        List<KpiFormAndCompany> kpiFormAndCompanyList = queryCompanyInfoByKpiId(kpiForm.getId());
//
//        List<Map<String, Object>> kpiFormVoItemList = new ArrayList<Map<String, Object>>();// 内容
//        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
//            Map<String, Object> kpiFormVoItem = new HashMap<String, Object>();
//
//            // 根据模板id,评估表id,供应商编码，评估项编码获取评分表对应评估项的分数
//
//            List<KpiScore> scoreList = getScore(kpiForm, kpiFormAndCompany, kpiTemplateItemList);
//            for (KpiScore score : scoreList) {
//                // HashMap相同的key，会被覆盖。
//                int isHaveRole = 0;
//                kpiFormVoItem.put("supplierSrmCode", kpiFormAndCompany.getSupCompanySrmCode());
//                kpiFormVoItem.put("supplierSrmName", kpiFormAndCompany.getSupCompanyName());
//                //kpiFormVoItem.put(score.getProjectCode(), score.getScoreScore() == null ? null: new BigDecimal(score.getScoreScore()));
//                if (CollectionUtils.isNotEmpty(ProjectCodeArray)) {
//                    for (String projectCode : ProjectCodeArray) {
//                        if (projectCode.equals(score.getProjectCode())) {
//                            isHaveRole = 1;
//                            break;
//                        }
//                    }
//                }
//                KpiProjectExample kpiProjectExample = new KpiProjectExample();
//                kpiProjectExample.createCriteria().andProjectCodeEqualTo(score.getProjectCode());
//                List<KpiProject> KpiProjectList = this.kpiProjectService.queryAllObjByExample(kpiProjectExample);
//                if (CollectionUtils.isNotEmpty(KpiProjectList)
//                        && KpiProjectList.get(0).getProjectHandlType() != null
//                        && KpiProjectList.get(0).getProjectHandlType().equals("2")) {
//                    if (StringUtils.isNotEmpty(score.getScoreScore())) {
//                        kpiFormVoItem.put(score.getProjectCode(), new BigDecimal(score.getScoreScore()));
//                    } else {
//                        try {
//
//                            Class<?> clazz = Class.forName(KpiProjectList.get(0).getProjectHandlNamespace());
//                            DataGather obj = (DataGather) clazz.newInstance();
//                            //
//                            obj.setFromCode(kpiForm.getFormCode());
//                            obj.setSupCompanySapCode(kpiFormAndCompany.getSupCompanySapCode());
//                            obj.setParameter(KpiProjectList.get(0).getProjectMethodParameterName());
//                            //
//                            String expression = obj.getExpression();
//                            List<CalculateItem> list = obj.GatherData();
//                            for (CalculateItem calculateItem : list) {
//                                //
//                                expression = expression.replace(calculateItem.getName(), calculateItem.getValue());
//                            }
//                            try {
//                                //
//                                double douNumber1 = Double.parseDouble(jse.eval(expression).toString());
//                                double scoreScore = Double.parseDouble(KpiProjectList.get(0).getProjectSource());
//                                if (SpringSecurityUtils.getLoginUserId().equals("1")) {
//                                    kpiFormVoItem.put(score.getProjectCode(), douNumber1 * scoreScore);
//                                } else {
//                                    if (isHaveRole == 1) {
//                                        kpiFormVoItem.put(score.getProjectCode(), douNumber1 * scoreScore);
//                                    }
//                                }
//
//                            } catch (Exception t) {
//                                if (SpringSecurityUtils.getLoginUserId().equals("1")) {
//                                    kpiFormVoItem.put(score.getProjectCode(), null);
//                                } else {
//                                    if (isHaveRole == 1) {
//                                        kpiFormVoItem.put(score.getProjectCode(), null);
//                                    }
//                                }
//                            }
//                        } catch (Exception e) {
//                            e.printStackTrace();
//                            if (SpringSecurityUtils.getLoginUserId().equals("1")) {
//                                kpiFormVoItem.put(score.getProjectCode(), null);
//                            } else {
//                                if (isHaveRole == 1) {
//                                    kpiFormVoItem.put(score.getProjectCode(), null);
//                                }
//                            }
//                        }
//                    }
//                } else {
//                    kpiFormVoItem.put(score.getProjectCode(), score.getScoreScore() == null ? null : new BigDecimal(score.getScoreScore()));
//                }
//            }
//            kpiFormVoItemList.add(kpiFormVoItem);
//
//        }
//        kpiFormVo.setTitles(titles);
//        kpiFormVo.setKpiFormVoItemList(kpiFormVoItemList);
//        return kpiFormVo;
//    }

    private List<KpiScore> getScore(KpiFormAndCompany kpiFormAndCompany, List<KpiTemplateItem> kpiTemplateItemList) {
        List<KpiScore> scoreList = new ArrayList<>();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andSupCompanySrmCodeEqualTo(kpiFormAndCompany.getSupCompanySrmCode())
                    .andProjectCodeEqualTo(kpiTemplateItem.getProjectCode())
                    .andKpiTemplateIdEqualTo(kpiTemplateItem.getKpiTemplateId())
                    .andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId());
            List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            scoreList.addAll(kpiScoreList);
        }
        return scoreList;
    }

    @Override
    public List<KpiTemplateItem> queryKpiTemplateItem(String kpiTemplateId) {
        KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
        templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiTemplateId);
        List<KpiTemplateItem> kpiTemplateItemList = this.kpiTemplateItemService
                .queryAllObjByExample(templateItemExample);
        return kpiTemplateItemList;
    }

    @Override
    public KpiForm lookKpiFormDetails(String kpiFormId) {
        KpiForm form = this.kpiFormMapper.selectByPrimaryKey(kpiFormId);
        form.setKpiFormAndCompanyList(queryCompanyInfoByKpiId(kpiFormId));
        form.setKpiFormAndPersonList(queryPersonInfoByKpiId(kpiFormId));
        return form;
    }

    @CacheEvict(value = {"kpiForm","kpiScore"}, allEntries = true)
    @Override
    @Transactional
    public void saveAtTheScore(KpiFormVo kpiFormVo, String saveOrSubmit) {
        List<Map<String, Object>> kpiFormVoItemList = kpiFormVo.getKpiFormVoItemList();
        List<KpiScore> kpiScores = new ArrayList<>();
        for (Map<String, Object> map : kpiFormVoItemList) {

            String supplierSrmCode = (String) map.get("supplierSrmCode");
            String supplierSapCode = (String) map.get("supplierSapCode");
            String supplierSrmName = (String) map.get("supplierSrmName");
            map.remove("supplierSapCode");
            map.remove("supplierSrmCode");
            map.remove("supplierSrmName");
            map.remove("categoryName");

            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                KpiScore kpiScore = new KpiScore();
                kpiScore.setSupCompanySrmCode(supplierSrmCode);
                kpiScore.setSupCompanySapCode(supplierSapCode);
                kpiScore.setSupCompanyName(supplierSrmName);
                kpiScore.setFormCode(kpiFormVo.getFormCode());
                String key = iter.next();
                kpiScore.setProjectCode(key);
                Map<String, String> map1=(Map<String, String>)  map.get(key);
                String originalScore=map1.get("originalScore");
                String score=String.valueOf(map1.get("score"));
                String correctionValue=map1.get("correctionValue");

                kpiScore.setCorrectionValue(correctionValue);
                kpiScore.setScoreScore(score);
                kpiScore.setOriginalValue(originalScore);
                //kpiScore.setScoreScore(map.get(key) == null ? null : map.get(key).toString());
                kpiScore.setLastUpdateUser(kpiFormVo.getUser().getNickName());
                kpiScores.add(kpiScore);

            }
        }
        updateKpiScoreData(kpiScores, saveOrSubmit);// 修改评分表数据
        if (saveOrSubmit.equals("submit")) {
            //判断是否完全打分完成
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andFormCodeEqualTo(kpiFormVo.getFormCode());// 评估项表编码
            criteria.andScoreStateEqualTo("0");// 状态
            List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            if (kpiScoreList == null || kpiScoreList.size() <= 0) {
                Date date = new Date();
                KpiFormExample fromExample = new KpiFormExample();
                fromExample.createCriteria().andFormCodeEqualTo(kpiFormVo.getFormCode());
                KpiForm existKpiForm = this.kpiFormMapper.selectByExample(fromExample).get(0);
                KpiForm kpiFormVOUpdate = new KpiForm();

                kpiFormVOUpdate.setId(existKpiForm.getId());// 主键id
                kpiFormVOUpdate.setFormCode(existKpiForm.getFormCode());// 评估表编码
                kpiFormVOUpdate.setFormState("2");// 状态 0-新建,1-进行中,2-已完成
                kpiFormVOUpdate.setFormFactTime(date);// 实际完成时间
                kpiFormVOUpdate.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());// 最后更新人
                kpiFormVOUpdate.setLastUpdateTime(date);// 最后更新时间
                // 根据主键更新评估表信息
                this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVOUpdate);
            }
        }
    }

//    @CacheEvict(value = {"kpiForm"}, allEntries = true)
//    @Override
//    public void saveAtTheScore(KpiFormVo kpiFormVo, String saveOrSubmit) {
//        List<Map<String, Object>> kpiFormVoItemList = kpiFormVo.getKpiFormVoItemList();
//        List<KpiScore> kpiScores = new ArrayList<>();
//        for (Map<String, Object> map : kpiFormVoItemList) {
//            KpiScore kpiScore = new KpiScore();
//            String supplierSrmCode = (String) map.get("supplierSrmCode");
//            map.remove("supplierSapCode");
//            map.remove("supplierSrmCode");
//            map.remove("supplierSrmName");
//            kpiScore.setSupCompanySrmCode(supplierSrmCode);
//            kpiScore.setFormCode(kpiFormVo.getFormCode());
//            Iterator<String> iter = map.keySet().iterator();
//            while (iter.hasNext()) {
//                String key = iter.next();
//                kpiScore.setProjectCode(key);
//                kpiScore.setScoreScore(map.get(key) == null ? null : map.get(key).toString());
//                kpiScore.setLastUpdateUser(kpiFormVo.getUser().getNickName());
//                kpiScores.add(kpiScore);
//                updateKpiScoreData(kpiScores, saveOrSubmit);// 修改评分表数据
//            }
//        }
//        if (saveOrSubmit.equals("submit")) {
//            //判断是否完全打分完成
//            KpiScoreExample kpiScoreExample = new KpiScoreExample();
//            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
//            criteria.andFormCodeEqualTo(kpiFormVo.getFormCode());// 评估项表编码
//            criteria.andScoreStateEqualTo("0");// 状态
//            List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
//            if (kpiScoreList == null || kpiScoreList.size() <= 0) {
//                Date date = new Date();
//                KpiFormExample fromExample = new KpiFormExample();
//                fromExample.createCriteria().andFormCodeEqualTo(kpiFormVo.getFormCode());
//                KpiForm existKpiForm = this.kpiFormMapper.selectByExample(fromExample).get(0);
//                KpiForm kpiFormVOUpdate = new KpiForm();
//
//                kpiFormVOUpdate.setId(existKpiForm.getId());// 主键id
//                kpiFormVOUpdate.setFormCode(existKpiForm.getFormCode());// 评估表编码
//                kpiFormVOUpdate.setFormState("2");// 状态 0-新建,1-进行中,2-已完成
//                kpiFormVOUpdate.setFormFactTime(date);// 实际完成时间
//                kpiFormVOUpdate.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());// 最后更新人
//                kpiFormVOUpdate.setLastUpdateTime(date);// 最后更新时间
//                // 根据主键更新评估表信息
//                this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVOUpdate);
//            }
//        }
//    }

    private void updateKpiScoreData(List<KpiScore> kpiScores, String saveOrSubmit) {
        for (int i = 0; CollectionUtils.isNotEmpty(kpiScores) && i < kpiScores.size(); i++) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            kpiScoreExample.createCriteria()
                    .andSupCompanySrmCodeEqualTo(kpiScores.get(i).getSupCompanySrmCode())
                    .andFormCodeEqualTo(kpiScores.get(i).getFormCode())
                    .andProjectCodeEqualTo(kpiScores.get(i).getProjectCode());
            List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            for (int j = 0; CollectionUtils.isNotEmpty(kpiScoreList) && j < kpiScoreList.size(); j++) {
                KpiScore kpiScore = new KpiScore();
                kpiScore.setId(kpiScoreList.get(j).getId());
                kpiScore.setScoreScore(kpiScores.get(i).getScoreScore());
                kpiScore.setCorrectionValue(kpiScores.get(i).getCorrectionValue());//修正值
                kpiScore.setLastUpdateTime(new Date());
                kpiScore.setLastUpdateUser(kpiScores.get(i).getLastUpdateUser());
                if (saveOrSubmit.equals("submit")) {
                    kpiScore.setScoreState(Constant.YES_INT.toString());
                }
                this.kpiScoreService.modifyObj(kpiScore);
            }
        }

    }

    @CacheEvict(value = {"company"}, allEntries = true)
    @Override
    public void rankAdjustMent(String supplierSrmCode, String classLevel) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(supplierSrmCode);
        List<Company> companyList = this.companyService.queryAllObjByExample(companyExample);
        for (int i = 0; CollectionUtils.isNotEmpty(companyList) && i < companyList.size(); i++) {
            Company company = new Company();
            company.setId(companyList.get(i).getId());
            company.setGrade(classLevel);
            this.companyService.modifyObj(company);
        }
    }

    @Override
    public String getSRMKpiScore(String sapCompanyCode, Date startTime, Date endTime, String projectDimension) {
        KpiAdverseEventExample eventExample = new KpiAdverseEventExample();
        eventExample.createCriteria().andSupplierSapCodeEqualTo(sapCompanyCode)
                .andStartTimeEqualTo(startTime).andEndTimeEqualTo(endTime).andMatterEqualTo(projectDimension);
        List<KpiAdverseEvent> kpiAdverseEventList = this.kpiAdverseEventService
                .queryAllObjByExample(eventExample);
        int points = 0;
        for (int i = 0; CollectionUtils.isNotEmpty(kpiAdverseEventList) && i < kpiAdverseEventList.size(); i++) {
            String point = kpiAdverseEventList.get(i).getPoints() == null ? "0" : kpiAdverseEventList.get(i)
                    .getPoints();
            points = Integer.parseInt(point) + points;
        }
        return String.valueOf(points);
    }

    @Override
    public List<KpiForm> queryfinalKpiForms(List<String> srmCompanyIdList, List<String> roleCodeList,
                                            com.els.base.auth.entity.User loginUser, List<KpiForm> queryAllObjByExample) {
        List<KpiForm> finalKpiForms = new ArrayList<KpiForm>();
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                && !roleCodeList.contains("supplier")) {
            for (int i = 0; CollectionUtils.isNotEmpty(queryAllObjByExample)
                    && i < queryAllObjByExample.size(); i++) {
                KpiForm kpiForm = queryAllObjByExample.get(i);
                List<String> stringIds = this.kpiFormAndCompanyService.queryCompanyIdsByFormCode(kpiForm
                        .getFormCode());
                boolean anyMatch = stringIds.stream().anyMatch(
                        id -> srmCompanyIdList.stream().anyMatch(id2 -> id2.equals(id)));
                // 按照分配供应商权限评分
                if (StringUtils.isNotBlank(kpiForm.getIsScoreBySupPower())
                        && kpiForm.getIsScoreBySupPower().equals("1") && anyMatch == false) {
                    continue;
                }
                finalKpiForms.add(kpiForm);
            }
        } else {
            finalKpiForms = queryAllObjByExample;
        }
        return finalKpiForms;
    }

    @Override
    public ReportShow queryMonthlyReport(ReportQueryParams reportQueryParams) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String monthStart = reportQueryParams.getMonthStart() + "-10";
            reportQueryParams.setMonthStart(sdf.format(sdf.parse(monthStart)));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        // 默认拿最新创建的模板进行查询
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank(reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());//如果模板编码不为空则更加模板编码查询
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");

        List<KpiTemplate> kpiTemplates = this.kpiTemplateService.queryAllObjByExample(templateExample);
        if (CollectionUtils.isEmpty(kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(kpiTemplates.get(0).getTemplateCode());

        List<KpiReport> reportList = this.kpiFormMapper.queryMonthlyReport(reportQueryParams);

        ReportShow monthlyReportShow = new ReportShow();
        List<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();// 一级标题
        List<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();// 2级标题
        List<Map<String, String>> dataToTypeMapList = new ArrayList<Map<String, String>>();// 最后拼装的评估项和事项分数的对应数据体
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); i++) {
            // 一级标题
            Map<String, String> titleMapFristList = new HashMap<String, String>();
            titleMapFristList.put("projectType", reportList.get(i).getProjectType());
            titleMapFristList.put("projectTypeName", reportList.get(i).getProjectTypeName());
            fristTitleList.add(titleMapFristList);
            // 2级标题
            Map<String, String> titleMapSecondList = new HashMap<String, String>();
            titleMapSecondList.put("projectType", reportList.get(i).getProjectType());
            titleMapSecondList.put("projectCode", reportList.get(i).getProjectCode());
            titleMapSecondList.put("projectName", reportList.get(i).getProjectName());
            secondTitleList.add(titleMapSecondList);
            // 最后拼装的评估项和事项分数的对应数据体and3级标题
            Map<String, String> mapFinalData = new HashMap<String, String>();
            mapFinalData.put("projectCode", reportList.get(i).getProjectCode());
            mapFinalData.put("matter", reportList.get(i).getMatter());
            mapFinalData.put("points", reportList.get(i).getPoints());
            mapFinalData.put("supCompanyId", reportList.get(i).getSupCompanyId());
            dataToTypeMapList.add(mapFinalData);
        }
        monthlyReportShow.setFristTitleList(removalOfRepetitionList(fristTitleList, "projectType"));
        monthlyReportShow.setSecondTitleList(removalOfRepetitionList(secondTitleList, "projectCode"));

        // 去掉重复的供应商数据,然后遍历的时候根据供应商的id取到相对应的事项和评估项的分数
        Set<KpiReport> personSet = new TreeSet<>((o1, o2) -> o1.getSupCompanyId().compareTo(
                o2.getSupCompanyId()));
        personSet.addAll(reportList);
        List<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); i++) {
            String supCompanyId = finalDataList.get(i).getSupCompanyId();
            KpiReport kpiMonthReport = finalDataList.get(i);
            kpiMonthReport.setDataToTypeMapList(selectPointsOfSupCompanyId(supCompanyId, dataToTypeMapList));
        }
        monthlyReportShow.setFinalDataList(finalDataList);
        return monthlyReportShow;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyId(String supCompanyId,
                                                                 List<Map<String, String>> dataToTypeMapList) {
        List<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); j++) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank(map.get("supCompanyId"))) {
                continue;
            }
            if (map.get("supCompanyId").equals(supCompanyId)) {
                maps.add(map);
            }
        }
        return maps;
    }

    private List<Map<String, String>> removalOfRepetitionList(List<Map<String, String>> titleList,
                                                              String string) {
        List<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(titleList) && i < titleList.size(); i++) {
            Map<String, String> oldMap = titleList.get(i);
            if (StringUtils.isBlank(oldMap.get(string))) {
                continue;
            }
            if (newList.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < newList.size(); j++) {
                    Map<String, String> newMap = newList.get(j);
                    if (newMap.get(string).equals(oldMap.get(string))) {
                        for (String key : oldMap.keySet()) {
                            newMap.put(key, oldMap.get(key));
                        }
                        isContain = true;
                        break;
                    }
                }
                if (!isContain) {
                    newList.add(oldMap);
                }
            } else {
                newList.add(oldMap);
            }
        }
        return newList;
    }

    @Override
    public void toVoidDocument(String id) {
        KpiForm kpiForm = new KpiForm();
        kpiForm.setId(id);
        kpiForm.setFormState("3");
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiForm);
    }

    @Override
    public ReportShow queryQuarterOrYearReport(ReportQueryParams reportQueryParams) {
        // 默认拿最新创建的模板进行查询
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank(reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());//如果模板编码不为空则更加模板编码查询
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");

        List<KpiTemplate> kpiTemplates = this.kpiTemplateService.queryAllObjByExample(templateExample);
        if (CollectionUtils.isEmpty(kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(kpiTemplates.get(0).getTemplateCode());

        ReportShow quarterReportShow = new ReportShow();
        // 如果年份不為空，则查询的是年度的报表数据，否则查询季度
        List<KpiReport> reportList = new ArrayList<KpiReport>();

        if (StringUtils.isNotBlank(reportQueryParams.getYear())) {
            reportList = this.kpiFormMapper.queryYearReport(reportQueryParams);
        } else {
            String quarter = reportQueryParams.getQuarter();
            String monthSrart = null;
            Calendar date = Calendar.getInstance();
            String year = String.valueOf(date.get(Calendar.YEAR));
            switch (quarter) {
                case "1":
                    monthSrart = "-04-01";
                    break;
                case "2":
                    monthSrart = "-07-01";
                    break;
                case "3":
                    monthSrart = "-10-01";
                    break;
                case "4":
                    monthSrart = "-01-01";
                    break;
            }
            reportQueryParams.setQuarterAnyDay(year + monthSrart);
            reportList = this.kpiFormMapper.queryQuarterReport(reportQueryParams);
        }
        List<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();// 一级标题
        List<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();// 2级标题和数据
        List<Map<String, String>> supStatusList = new ArrayList<Map<String, String>>();// 供应商评价状态
        List<Map<String, String>> supStatusDevelList = new ArrayList<Map<String, String>>();// 供应商评价等级
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); i++) {
            KpiReport kpiquarterReport = reportList.get(i);
            String projectType = kpiquarterReport.getProjectType();
            String projectCode = kpiquarterReport.getProjectCode();
            // 一级标题
            Map<String, String> titleMapFristList = new HashMap<String, String>();
            if (StringUtils.isNotBlank(projectType)) {
                titleMapFristList.put("projectType", projectType);
                titleMapFristList.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                fristTitleList.add(titleMapFristList);
            }
            // 2级标题和数据
            Map<String, String> titleMapSecondList = new HashMap<String, String>();
            if (StringUtils.isNotBlank(projectCode)) {
                titleMapSecondList.put("projectType", projectType);
                titleMapSecondList.put("projectCode", projectCode);
                titleMapSecondList.put("projectName", kpiquarterReport.getProjectName());
                titleMapSecondList.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                titleMapSecondList.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                secondTitleList.add(titleMapSecondList);
            }
            // 如果评估项编码为空，评估类别不为空，则为供应商评价状态栏的评估类别统计数据
            Map<String, String> supStatusType = new HashMap<String, String>();
            if (StringUtils.isBlank(projectCode) && StringUtils.isNotBlank(projectType)) {
                supStatusType.put("projectType", projectType);
                supStatusType.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                supStatusType.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                supStatusType.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                supStatusList.add(supStatusType);
            }
            // 如果评估项编码为空，评估类别为空，则为供应商评价状态栏的评估类别等級数据
            Map<String, String> supStatusDevel = new HashMap<String, String>();
            if (StringUtils.isBlank(projectCode) && StringUtils.isBlank(projectType)) {
                supStatusDevel.put("devel", kpiquarterReport.getProjectCodeScore());
                supStatusDevel.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                supStatusDevelList.add(supStatusDevel);
            }
        }
        quarterReportShow.setFristTitleList(removalOfRepetitionList(fristTitleList, "projectType"));
        // 去掉重复的供应商数据,然后遍历的时候根据供应商的id取到相对应的评估项的分数
        Set<KpiReport> personSet = new TreeSet<>((o1, o2) -> o1.getSupCompanyId().compareTo(
                o2.getSupCompanyId()));
        personSet.addAll(reportList);
        List<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); i++) {
            String supCompanyId = finalDataList.get(i).getSupCompanyId();
            KpiReport kpiquarterReport = finalDataList.get(i);
            kpiquarterReport.setDataToTypeMapList(selectPointsOfSupCompanyId(supCompanyId, secondTitleList));
            kpiquarterReport.setProjectTypeList(selectPointsOfSupCompanyId(supCompanyId, supStatusList));
            for (int j = 0; CollectionUtils.isNotEmpty(supStatusDevelList) && j < supStatusDevelList.size(); j++) {
                if (supCompanyId.equals(supStatusDevelList.get(j).get("supCompanyId"))) {
                    kpiquarterReport.setDevel(supStatusDevelList.get(j).get("devel"));
                    break;
                }
            }
        }
        quarterReportShow.setFinalDataList(finalDataList);

        return quarterReportShow;
    }


    /**
     * 送签
     */
    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Override
    public void sendToSing(String id) {

        KpiForm kpiForm = this.queryObjById(id);
        if (kpiForm == null) {
            throw new CommonException("单据不存在，请核实!");
        }
        if (!kpiForm.getFormState().equals(KpiFormStatus.DONE.getValue()) && !kpiForm.getFormState().equals(KpiFormStatus.REFUSED.getValue())) {
            throw new CommonException("只有完成、审批拒绝的单据才可以送签!");
        }
        ProcessStartVO vo = ProcessStartVO.newInstance("jxsh", kpiForm.getFormCode(), kpiForm.getId(), "supplierEFM?Action=View&formCode=" + kpiForm.getFormCode());
        vo.setListenerClass(this.getClass());
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess != null) {
            kpiForm.setFormState(KpiFormStatus.APPROVING.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
        }

    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Transactional
    @Override
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        //获取业务ID
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank(businessId)) {
            return;
        }
        KpiForm kpiForm = this.queryObjById(businessId);
        String assignee = StringUtils.defaultIfBlank(event.getAssignee(), "");
        String fullMessage = StringUtils.defaultIfBlank(event.getApproveDesc(), "");
        String result = "审批人：" + assignee + "，审批意见：" + fullMessage + " ; ";

        //1、审批流完成而且通过
        if (event.isFinished() && event.isPass()) {
            //做修改业务操作
            kpiForm.setFormState(KpiFormStatus.APPROVED.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
            //
            // 获取当前登录人公司信息
            Company company = CompanyUtils.currentCompany();
            // 获取当前登录人用户信息
            com.els.base.auth.entity.User user = SpringSecurityUtils.getLoginUser();

            kpiForm.setCompany(company);
            kpiForm.setUser(user);
            this.finishFormAppove(kpiForm); //审批通过直接生成绩效结果表
            //
            //2、审批流完成但被驳回
        } else if (event.isFinished() && !event.isPass()) {
            kpiForm.setFormState(KpiFormStatus.REFUSED.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
            KpiScoreExample example = new KpiScoreExample();
            example.createCriteria().andFormCodeEqualTo(kpiForm.getFormCode())
                    .andKpiFormIdEqualTo(kpiForm.getId());
            List<KpiScore> KpiScoreArray = this.kpiScoreService.queryAllObjByExample(example);
            for (KpiScore kpiscore : KpiScoreArray) {
                kpiscore.setScoreState("0");
                kpiscore.setLastUpdateTime(new Date());
                kpiscore.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
                this.kpiScoreService.modifyObj(kpiscore);
            }
        } else {

        }
    }

    @CacheEvict(value = {"kpiForm"}, allEntries = true)
    @Transactional
    public void finishFormAppove(KpiForm kpiForm) {
        // 根据主键获取评估表信息
        KpiForm form = queryObjById(kpiForm.getId());
        if (form == null) {
            throw new CommonException("对应的评估表数据不存在不能进行结案", "do_not_exists", "评估表数据");
        }

        // 根据模板id获取评估模板的供应商等级
        KpiTemplate kpiTemplate = this.kpiTemplateService.queryObjById(form.getKpiTemplateId());
        if (kpiTemplate == null) {
            throw new CommonException("对应的模板数据不存在不能进行结案", "do_not_exists", "评估模板数据");
        }

        // =========================begin更新评估表信息============
        Date date = new Date();
        KpiForm kpiFormVO = new KpiForm();
        kpiFormVO.setId(kpiForm.getId());// 主键id
        kpiFormVO.setFormCode(kpiForm.getFormCode());// 评估表编码
        kpiFormVO.setFormState("4");// 0-新建,1-进行中,2-已完成 3-审核中 4-审核完成 5 审核拒绝
        kpiFormVO.setFormFactTime(date);// 实际完成时间
        kpiFormVO.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());// 最后更新人
        kpiFormVO.setLastUpdateTime(date);// 最后更新时间

        // 根据主键更新评估表信息
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVO);
        // =========================end更新评估表信息============

        // 插入数据前先删除
        // 拼接条件
        KpiRankingExample kpiRankingExample = new KpiRankingExample();
        KpiRankingExample.Criteria rankingCriteria = kpiRankingExample.createCriteria();
        rankingCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        rankingCriteria.andFormCodeEqualTo(kpiForm.getFormCode());

        this.kpiRankingService.deleteByExample(kpiRankingExample);

        // 根据评估表id和编码获取评估的供应商列表
        // 拼接条件
        KpiFormAndCompanyExample kpiFormAndCompanyExample = new KpiFormAndCompanyExample();
        KpiFormAndCompanyExample.Criteria formAndCompanyCriteria = kpiFormAndCompanyExample.createCriteria();
        formAndCompanyCriteria.andKpiFormIdEqualTo(kpiForm.getId());// 评估表id
        formAndCompanyCriteria.andFormCodeEqualTo(kpiForm.getFormCode());// 评估表编码
        List<KpiFormAndCompany> kpiFormAndCompany = this.kpiFormAndCompanyService
                .queryAllObjByExample(kpiFormAndCompanyExample);
        // 循环评估表的每个供应商
        //根据绩效考核设置 评定
        KpiConfigurationExample example = new KpiConfigurationExample();
        List<KpiConfiguration> KpiConfigurationArray = kpiConfigurationService.queryAllObjByExample(example);

        for (KpiFormAndCompany formAndCompany : kpiFormAndCompany) {
            // 获取同一个供应商，分类，等级的最近一次评估的分数
            KpiRanking t = new KpiRanking();
            t.setSupCompanyId(formAndCompany.getSupCompanyId());
            t.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());

            // 根据供应商id和编码获取上次评分的等级信息,此处是一条记录
            KpiRanking lastKpiRanking = this.kpiRankingService.selectByCustom(t);

            KpiRanking currKpiRanking = new KpiRanking();
            currKpiRanking.setPurCompanyId(kpiForm.getCompany().getId());//
            currKpiRanking.setPurCompanyCode(kpiForm.getCompany().getCompanyCode());
            currKpiRanking.setPurCompanyName(kpiForm.getCompany().getCompanyName());
            currKpiRanking.setPurUserId(kpiForm.getUser().getId());
            currKpiRanking.setPurUserName(kpiForm.getUser().getNickName());
            currKpiRanking.setKpiFormId(form.getId());// 评估表id
            currKpiRanking.setFormName(form.getFormName());// 评估表名称
            currKpiRanking.setFormPublishTime(form.getFormStartTime());// 开始时间
            currKpiRanking.setFormFactTime(date);//
            currKpiRanking.setSupCompanyId(formAndCompany.getSupCompanyId());//
            currKpiRanking.setSupCompanySapCode(formAndCompany.getSupCompanySapCode());//
            currKpiRanking.setSupCompanyName(formAndCompany.getSupCompanyName());//
            currKpiRanking.setSupUserName(formAndCompany.getSupUserName());//
            currKpiRanking.setSupUserId(formAndCompany.getSupUserId());//
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setCreateTime(new Date());// 创建时间
            currKpiRanking.setLastUpdateTime(new Date());// 最后更新时间
            currKpiRanking.setLastUpdateUser(kpiForm.getUser().getNickName());// 最后更新人
            // 条件
            currKpiRanking.setFormCode(kpiForm.getFormCode());// 评估表编码
            currKpiRanking.setTemplateCode(kpiTemplate.getTemplateCode());// 模板编码
            currKpiRanking.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());// 供应商编码
            currKpiRanking.setRankingScore(lastKpiRanking == null ? null : lastKpiRanking.getRankingScore());// 上次评估结果的分数

            this.kpiRankingService.insertCustom(currKpiRanking);

            if (CollectionUtils.isNotEmpty(KpiConfigurationArray)) {

                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(kpiForm.getId())
                        .andFormCodeEqualTo(kpiForm.getFormCode())
                        .andSupCompanyIdEqualTo(formAndCompany.getSupCompanyId());
                KpiRanking KpiRankingEdit = this.kpiRankingService.queryAllObjByExample(rankingExample).get(0);
                if (KpiRankingEdit != null) {
                    String purCheckRank = "";
                    for (KpiConfiguration configuration : KpiConfigurationArray) {
                        //KpiRankingEdit.setPurCheckRank();
                        if (configuration.getStartScore() < Double.valueOf(KpiRankingEdit.getRankingScore())
                                && configuration.getEndScore() >= Double.valueOf(KpiRankingEdit.getRankingScore())) {
                            purCheckRank = configuration.getLevel();
                            break;
                        }
                    }
                    KpiRanking KpiRankingObj = new KpiRanking();
                    KpiRankingObj.setId(KpiRankingEdit.getId());
                    KpiRankingObj.setPurCheckRank(purCheckRank);
                    this.kpiRankingService.modifyObj(KpiRankingObj);
                }

            }
            //updateOriginalScore(currKpiRanking);
            // 评估完成给供应商发送信息
            this.sendInformationToSupplier(kpiForm, formAndCompany);
        }
        // 根据供应商品类排名
        rankingByCategory(kpiFormAndCompany, kpiForm.getId());
    }

    /**
     * 根据供应商品类排名
     *
     * @param kpiFormAndCompanies 参加评分的供应商
     */
    private void rankingByCategory(List<KpiFormAndCompany> kpiFormAndCompanies, String formId) {
        // 根据供应商类别分类
        Map<String, List<KpiFormAndCompany>> companyMap = kpiFormAndCompanies.stream()
                .collect(Collectors.groupingBy(KpiFormAndCompany::getCategoryName));
        Iterator<Map.Entry<String, List<KpiFormAndCompany>>> iterator = companyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<KpiFormAndCompany>> entry = iterator.next();
            // 供应商列表
            List<KpiFormAndCompany> companyList = entry.getValue();
            // 供应商分数
            Map<String, Integer> scoreMap = new HashMap<>();
            // 遍历供应商集合,获取分数
            for (KpiFormAndCompany kpiFormAndCompany : companyList) {
                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId())
                        .andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
                List<KpiRanking> kpiRankings = kpiRankingService.queryAllObjByExample(rankingExample);
                if (CollectionUtils.isNotEmpty(kpiRankings)) {
                    scoreMap.put(kpiFormAndCompany.getSupCompanySrmCode(), NumberUtils.toInt(kpiRankings.get(0).getRankingScore(), 0));
                }
            }
            // 创建比较器
            Comparator<Map.Entry<String, Integer>> scoreComparator = Comparator.comparingInt(Map.Entry::getValue);
            // 将map转成list进行排序
            List<Map.Entry<String, Integer>> list = new ArrayList<>(scoreMap.entrySet());
            // 排序
            Collections.sort(list, scoreComparator);
            // 反转list
            Collections.reverse(list);
            for (Map.Entry<String, Integer> scoreEntry : list) {
                // 排名
                int index = 1;
                // 供应商编码
                String companyCode = scoreEntry.getKey();
                // 分数

                Integer score = scoreEntry.getValue();
                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(formId)
                        .andSupCompanySrmCodeEqualTo(companyCode);
                KpiRanking kpiRanking = new KpiRanking();
                kpiRanking.setRankingCount(index++);
                kpiRanking.setCategoryName(entry.getKey());
                kpiRanking.setCompanyNumber(list.size());
                kpiRankingService.updateByExampleSelective(kpiRanking, rankingExample);
            }
        }
    }

    private void sendInformationToSupplier(KpiForm kpiForm, KpiFormAndCompany formAndCompany) {
        Map<String, Object> msg = new HashMap<String, Object>();
        msg.put("formCode", kpiForm.getFormCode());
        // 根据供应商ID查出与供应商对应的用户ID
        User user = this.companyUserRefService.queryMainUserOfCompany(formAndCompany.getSupCompanyId());
        if (null != user) {
            Message<Map<String, Object>> message = Message.init(msg)
                    .setCompanyCode(kpiForm.getPurCompanyCode())// 发送者公司srmcode
                    .setSenderId(kpiForm.getPurUserId())// 发送者 userId
                    .setBusinessTypeCode("KPIFORM_PUR_SEND_INFORMATION")// 业务类型
                    .addReceiverId(user.getId())// 接受者 userId
                    .setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
            MessageSendUtils.sendMessage(message);
        }

    }


    @Override
    public List<String> queryCompanySapCode(String year, String month) {
        return this.kpiFormMapper.selectDistinctCompanySapCode(year, month);
    }
}
