package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiOriginalScoreMapper;
import com.els.base.performance.entity.KpiOriginalScore;
import com.els.base.performance.entity.KpiOriginalScoreExample;
import com.els.base.performance.service.KpiOriginalScoreService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiOriginalScoreService")
public class KpiOriginalScoreServiceImpl implements KpiOriginalScoreService {
    @Resource
    protected KpiOriginalScoreMapper kpiOriginalScoreMapper;

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void addObj(KpiOriginalScore t) {
        this.kpiOriginalScoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void addAll(List<KpiOriginalScore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiOriginalScoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiOriginalScoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void deleteByExample(KpiOriginalScoreExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiOriginalScoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void modifyObj(KpiOriginalScore t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiOriginalScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiOriginalScore", keyGenerator="redisKeyGenerator")
    @Override
    public KpiOriginalScore queryObjById(String id) {
        return this.kpiOriginalScoreMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiOriginalScore", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiOriginalScore> queryAllObjByExample(KpiOriginalScoreExample example) {
        return this.kpiOriginalScoreMapper.selectByExample(example);
    }

    @Cacheable(value="kpiOriginalScore", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiOriginalScore> queryObjByPage(KpiOriginalScoreExample example) {
        PageView<KpiOriginalScore> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiOriginalScoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    @Override
    public void updateByExampleSelective(KpiOriginalScoreExample example, KpiOriginalScore score) {
        kpiOriginalScoreMapper.updateByExampleSelective(score, example);
    }
}