package com.els.base.performance.service.impl;

import java.util.Date;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;

import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiProjectMapper;
import com.els.base.performance.entity.KpiProject;
import com.els.base.performance.entity.KpiProjectExample;
import com.els.base.performance.service.KpiProjectService;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiProjectService")
public class KpiProjectServiceImpl implements KpiProjectService {
    @Resource
    protected KpiProjectMapper kpiProjectMapper;

    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value = { "kpiProject" }, allEntries = true)
    @Override
    public void addObj(KpiProject t) {

        t.setProjectCode(generateCodeService.getNextCode("KPI_PROJECT_CODE"));
        // 采购方信息
        t.setPurCompanyId(t.company.getId());
        t.setPurCompanyCode(t.company.getCompanyCode());
        t.setPurCompanyName(t.company.getCompanyName());
        t.setPurUserId(t.user.getId());
        t.setPurUserName(t.user.getNickName());

        t.setCreateTime(new Date());// 创建时间
        t.setLastUpdateUser(t.user.getNickName());// 最后更新人
        t.setLastUpdateTime(new Date());// 最后更新时间

        this.kpiProjectMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiProject"}, allEntries=true)
    @Override
    public void addAll(List<KpiProject> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiProjectMapper.insertBatch(list);
    }

    @CacheEvict(value = { "kpiProject" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiProjectMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiProject" }, allEntries = true)
    @Override
    public void modifyObj(KpiProject t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        // 采购方信息
        t.setPurCompanyId(t.company.getId());
        t.setPurCompanyCode(t.company.getCompanyCode());
        t.setPurCompanyName(t.company.getCompanyName());
        t.setPurUserId(t.user.getId());
        t.setPurUserName(t.user.getNickName());

        t.setLastUpdateUser(t.user.getNickName());// 最后更新人
        t.setLastUpdateTime(new Date());// 最后更新时间

        this.kpiProjectMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiProject", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiProject queryObjById(String id) {
        return this.kpiProjectMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiProject", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiProject> queryAllObjByExample(KpiProjectExample example) {
        return this.kpiProjectMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiProject", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiProject> queryObjByPage(KpiProjectExample example) {
        PageView<KpiProject> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiProjectMapper.selectByExampleByPage(example));
        return pageView;
    }
}