package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiQualifiedBatchMapper;
import com.els.base.performance.entity.KpiQualifiedBatch;
import com.els.base.performance.entity.KpiQualifiedBatchExample;
import com.els.base.performance.service.KpiQualifiedBatchService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiQualifiedBatchService")
public class KpiQualifiedBatchServiceImpl implements KpiQualifiedBatchService {
    @Resource
    protected KpiQualifiedBatchMapper kpiQualifiedBatchMapper;

    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void addObj(KpiQualifiedBatch t) {
        this.kpiQualifiedBatchMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void addAll(List<KpiQualifiedBatch> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiQualifiedBatchMapper.insertBatch(list);
    }

    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiQualifiedBatchMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void deleteByExample(KpiQualifiedBatchExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiQualifiedBatchMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void modifyObj(KpiQualifiedBatch t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiQualifiedBatchMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiQualifiedBatch queryObjById(String id) {
        return this.kpiQualifiedBatchMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiQualifiedBatch> queryAllObjByExample(KpiQualifiedBatchExample example) {
        return this.kpiQualifiedBatchMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiQualifiedBatch", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiQualifiedBatch> queryObjByPage(KpiQualifiedBatchExample example) {
        PageView<KpiQualifiedBatch> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiQualifiedBatchMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"kpiQualifiedBatch"}, allEntries = true)
    @Override
    public void ImportFromExcel(List<KpiQualifiedBatch> list) {
        List<KpiQualifiedBatch> kpiQualifiedBatcheAdd = new ArrayList<>();
        for (KpiQualifiedBatch kpiQualifiedBatch : list) {
            if (StringUtils.isNotEmpty(kpiQualifiedBatch.getSupCompanySapCode())) {
                KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
                example.createCriteria().andSupCompanySapCodeEqualTo(kpiQualifiedBatch.getSupCompanySapCode())
                        .andYearEqualTo(kpiQualifiedBatch.getYear())
                        .andMonthEqualTo(kpiQualifiedBatch.getMonth());
                List<KpiQualifiedBatch> kpiDeliveryRates = this.kpiQualifiedBatchMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                    kpiQualifiedBatch.setId(kpiDeliveryRates.get(0).getId());
                    this.modifyObj(kpiQualifiedBatch);
                } else {
                    kpiQualifiedBatch.setId(UUIDGenerator.generateUUID());
                    kpiQualifiedBatch.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                    kpiQualifiedBatch.setCreateTime(new Date());
                    kpiQualifiedBatch.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                    kpiQualifiedBatcheAdd.add(kpiQualifiedBatch);
                }
            } else {
                KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
                example.createCriteria().andSupCompanyNameEqualTo(kpiQualifiedBatch.getSupCompanyName())
                        .andYearEqualTo(kpiQualifiedBatch.getYear())
                        .andMonthEqualTo(kpiQualifiedBatch.getMonth());
                List<KpiQualifiedBatch> kpiDeliveryRates = this.kpiQualifiedBatchMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                    kpiQualifiedBatch.setId(kpiDeliveryRates.get(0).getId());
                    this.modifyObj(kpiQualifiedBatch);
                } else {
                    kpiQualifiedBatch.setId(UUIDGenerator.generateUUID());
                    kpiQualifiedBatch.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                    kpiQualifiedBatch.setCreateTime(new Date());
                    kpiQualifiedBatch.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                    kpiQualifiedBatcheAdd.add(kpiQualifiedBatch);
                }
            }
        }
        if (kpiQualifiedBatcheAdd.size() > 0) {
            this.kpiQualifiedBatchMapper.insertBatch(kpiQualifiedBatcheAdd);
        }

    }
}