package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiQualifiedRateMapper;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.entity.KpiQualifiedRate;
import com.els.base.performance.entity.KpiQualifiedRateExample;
import com.els.base.performance.service.KpiQualifiedRateService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiQualifiedRateService")
public class KpiQualifiedRateServiceImpl implements KpiQualifiedRateService {
    @Resource
    protected KpiQualifiedRateMapper kpiQualifiedRateMapper;

    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void addObj(KpiQualifiedRate t) {
        this.kpiQualifiedRateMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void addAll(List<KpiQualifiedRate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiQualifiedRateMapper.insertBatch(list);
    }

    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiQualifiedRateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void deleteByExample(KpiQualifiedRateExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiQualifiedRateMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void modifyObj(KpiQualifiedRate t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiQualifiedRateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiQualifiedRate", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiQualifiedRate queryObjById(String id) {
        return this.kpiQualifiedRateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiQualifiedRate", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiQualifiedRate> queryAllObjByExample(KpiQualifiedRateExample example) {
        return this.kpiQualifiedRateMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiQualifiedRate", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiQualifiedRate> queryObjByPage(KpiQualifiedRateExample example) {
        PageView<KpiQualifiedRate> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiQualifiedRateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"kpiQualifiedRate"}, allEntries = true)
    @Override
    public void ImportFromExcel(List<KpiQualifiedRate> list) {
        List<KpiQualifiedRate> kpiQualifiedRateAdd = new ArrayList<>();
        for (KpiQualifiedRate kpiQualifiedRate : list) {
            if (StringUtils.isNotEmpty(kpiQualifiedRate.getSupCompanySapCode())) {
                KpiQualifiedRateExample example = new KpiQualifiedRateExample();
                example.createCriteria().andSupCompanySapCodeEqualTo(kpiQualifiedRate.getSupCompanySapCode())
                        .andYearEqualTo(kpiQualifiedRate.getYear())
                        .andMonthEqualTo(kpiQualifiedRate.getMonth());
                List<KpiQualifiedRate> kpiDeliveryRates = this.kpiQualifiedRateMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                    kpiQualifiedRate.setId(kpiDeliveryRates.get(0).getId());
                    this.modifyObj(kpiQualifiedRate);
                } else {
                    kpiQualifiedRate.setId(UUIDGenerator.generateUUID());
                    kpiQualifiedRate.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                    kpiQualifiedRate.setCreateTime(new Date());
                    kpiQualifiedRate.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                    kpiQualifiedRateAdd.add(kpiQualifiedRate);
                }
            } else {
                KpiQualifiedRateExample example = new KpiQualifiedRateExample();
                example.createCriteria().andSupCompanyNameEqualTo(kpiQualifiedRate.getSupCompanyName())
                        .andYearEqualTo(kpiQualifiedRate.getYear())
                        .andMonthEqualTo(kpiQualifiedRate.getMonth());
                List<KpiQualifiedRate> kpiDeliveryRates = this.kpiQualifiedRateMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                    kpiQualifiedRate.setId(kpiDeliveryRates.get(0).getId());
                    this.modifyObj(kpiQualifiedRate);
                } else {
                    kpiQualifiedRate.setId(UUIDGenerator.generateUUID());
                    kpiQualifiedRate.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                    kpiQualifiedRate.setCreateTime(new Date());
                    kpiQualifiedRate.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                    kpiQualifiedRateAdd.add(kpiQualifiedRate);
                }
            }

        }
        if (kpiQualifiedRateAdd.size() > 0) {
            this.kpiQualifiedRateMapper.insertBatch(kpiQualifiedRateAdd);
        }

    }

    @Cacheable(value = "kpiOriginalExport", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiOriginalExport> queryReportObjByPage(KpiOriginalExportExample example) {
        PageView<KpiOriginalExport> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiQualifiedRateMapper.selectReportByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<KpiOriginalExport> queryReportAllObjByExample(KpiOriginalExportExample example) {
        return this.kpiQualifiedRateMapper.selectReportByExample(example);
    }
}