package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiRankingMapper;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;

import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiRankingService")
public class KpiRankingServiceImpl implements KpiRankingService {
    @Resource
    protected KpiRankingMapper kpiRankingMapper;

    @CacheEvict(value = { "kpiRanking" }, allEntries = true)
    @Override
    public void addObj(KpiRanking t) {
        this.kpiRankingMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    @Override
    public void addAll(List<KpiRanking> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiRankingMapper.insertBatch(list);
    }
    @CacheEvict(value = { "kpiRanking" }, allEntries = true)
    @Override
    public void insertCustom(KpiRanking t) {
        this.kpiRankingMapper.insertCustom(t);
    }

    @CacheEvict(value = { "kpiRanking" }, allEntries = true)
    @Override
    public int updateByExampleSelective(KpiRanking kpiRanking, KpiRankingExample example) {
        return kpiRankingMapper.updateByExampleSelective(kpiRanking, example);
    }

    @CacheEvict(value = { "kpiRanking" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiRankingMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    @Override
    public void deleteByExample(KpiRankingExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiRankingMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    @Override
    public void modifyObj(KpiRanking t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiRankingMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiRanking", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiRanking queryObjById(String id) {
        return this.kpiRankingMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiRanking", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiRanking> queryAllObjByExample(KpiRankingExample example) {
        return this.kpiRankingMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiRanking", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiRanking> queryObjByPage(KpiRankingExample example) {
        PageView<KpiRanking> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiRankingMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public KpiRanking selectByCustom(KpiRanking t) {
        return this.kpiRankingMapper.selectByCustom(t);
    }

}