package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiScoreMapper;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiScoreService")
public class KpiScoreServiceImpl implements KpiScoreService {
    @Resource
    protected KpiScoreMapper kpiScoreMapper;

    @CacheEvict(value = {"kpiScore"}, allEntries = true)
    @Override
    public void addObj(KpiScore t) {
        this.kpiScoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiScore"}, allEntries=true)
    @Override
    public void addAll(List<KpiScore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiScoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiScoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    @Override
    public void deleteByExample(KpiScoreExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiScoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    @Override
    public void modifyObj(KpiScore t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiScore", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiScore queryObjById(String id) {
        return this.kpiScoreMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiScore", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiScore> queryAllObjByExample(KpiScoreExample example) {
        return this.kpiScoreMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiScore", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiScore> queryObjByPage(KpiScoreExample example) {
        PageView<KpiScore> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiScoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int queryDeliveryRateTimely(String fromCode, String supCompanySapCode) {
        return this.kpiScoreMapper.selectDeliveryRateTimely(fromCode, supCompanySapCode);
    }

    @Override
    public int queryDeliveryRateTotal(String fromCode, String supCompanySapCode) {
        return this.kpiScoreMapper.selectDeliveryRateTotal(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateStandard(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateStandard(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateStandardOutNCR(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateStandard(fromCode, supCompanySapCode) - this.kpiScoreMapper.selectQualityRateStandardOutNCR(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateTotal(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateTotal(fromCode, supCompanySapCode);
    }
}