package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiServiceFormMapper;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceExample;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.entity.KpiServiceFormExample;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiServiceFormService")
public class KpiServiceFormServiceImpl implements KpiServiceFormService {
    @Resource
    protected KpiServiceFormMapper kpiServiceFormMapper;
    @Resource
    protected KpiServiceService kpiServiceService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @CacheEvict(value = {"kpiServiceForm","kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void addObj(KpiServiceForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_SERVICRE_FORM");
        t.setFormNo(formCode);
        t.setId(UUIDGenerator.generateUUID());
        t.setCreateTime(new Date());
        t.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        t.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        t.setUpdateTime(new Date());
        t.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        t.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        t.setFormStatus(KpiServiceFormStatus.NEW.getValue());
        this.kpiServiceFormMapper.insertSelective(t);
        List<KpiService> kpiServices = t.getKpiServiceList();
        for (KpiService kpiService : kpiServices) {
            kpiService.setFormId(t.getId());
            kpiService.setFormNo(formCode);
            kpiService.setYear(t.getYear());
            kpiService.setMonth(t.getMonth());
            kpiService.setStatus(KpiServiceFormStatus.NEW.getValue());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        }
        kpiServiceService.addAll(kpiServices);
    }

    @Transactional
    @CacheEvict(value = {"kpiServiceForm"}, allEntries = true)
    @Override
    public void addAll(List<KpiServiceForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiServiceFormMapper.insertBatch(list);
    }

    @CacheEvict(value = {"kpiServiceForm"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiServiceFormMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiServiceForm"}, allEntries = true)
    @Override
    public void deleteByExample(KpiServiceFormExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiServiceFormMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"kpiServiceForm"}, allEntries = true)
    @Override
    public void modifyObj(KpiServiceForm t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiServiceFormMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiServiceForm", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiServiceForm queryObjById(String id) {
        return this.kpiServiceFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiServiceForm", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiServiceForm> queryAllObjByExample(KpiServiceFormExample example) {
        return this.kpiServiceFormMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiServiceForm", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiServiceForm> queryObjByPage(KpiServiceFormExample example) {
        PageView<KpiServiceForm> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceFormMapper.selectByExampleByPage(example));
        return pageView;
    }


    @CacheEvict(value = {"kpiServiceForm", "kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void deleteByIdArray(List<String> list) {
        for (String id : list) {
            this.deleteObjById(id);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            this.kpiServiceService.deleteByExample(example);
        }
    }

    @CacheEvict(value = {"kpiServiceForm", "kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void publishByIds(List<String> list) {
        for (String id : list) {
            KpiServiceForm form = this.queryObjById(id);
            form.setFormStatus(KpiServiceFormStatus.PUBLIC.getValue());
            form.setUpdateTime(new Date());
            form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(form);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            List<KpiService> kpiServices = this.kpiServiceService.queryAllObjByExample(example);
            for (KpiService kpiService : kpiServices) {
                kpiService.setStatus(KpiServiceFormStatus.PUBLIC.getValue());
                kpiService.setUpdateTime(new Date());
                kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                this.kpiServiceService.modifyObj(kpiService);
            }
        }
    }

    @CacheEvict(value = {"kpiServiceForm", "kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void invalidByIds(List<String> list) {
        for (String id : list) {
            KpiServiceForm form = this.queryObjById(id);
            form.setFormStatus(KpiServiceFormStatus.INVAILD.getValue());
            form.setUpdateTime(new Date());
            form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(form);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            List<KpiService> kpiServices = this.kpiServiceService.queryAllObjByExample(example);
            for (KpiService kpiService : kpiServices) {
                kpiService.setStatus(KpiServiceFormStatus.INVAILD.getValue());
                kpiService.setUpdateTime(new Date());
                kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                this.kpiServiceService.modifyObj(kpiService);
            }
        }
    }

    @Override
    public KpiServiceForm viewById(String id) {
        KpiServiceForm form = this.queryObjById(id);
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(id);
        List<KpiService> kpiServices = this.kpiServiceService.queryAllObjByExample(example);
        form.setKpiServiceList(kpiServices);
        return  form;
    }

    @Override
    public KpiServiceForm scoreById(String id) {
        List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        List<String> companySapCodes = new ArrayList<String>();
        for (Company company : companyList) {
            companySapCodes.add(company.getCompanySapCode());
        }
        KpiServiceForm form = this.queryObjById(id);
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(id).andSupCompanySapCodeIn(companySapCodes);

        List<KpiService> kpiServices = this.kpiServiceService.queryAllObjByExample(example);
        form.setKpiServiceList(kpiServices);
        return  form;
    }
    @CacheEvict(value = {"kpiServiceForm", "kpiService"}, allEntries = true)
    @Override
    public void saveKpiServiceForm(KpiServiceForm kpiServiceForm) {
        KpiServiceForm serviceFormUpdate=this.queryObjById(kpiServiceForm.getId());
        serviceFormUpdate.setUpdateTime(new Date());
        serviceFormUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        serviceFormUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        serviceFormUpdate.setYear(kpiServiceForm.getYear());
        serviceFormUpdate.setMonth(kpiServiceForm.getMonth());
        serviceFormUpdate.setFormDescription(kpiServiceForm.getFormDescription());
        this.modifyObj(serviceFormUpdate);

        KpiServiceExample example=new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(kpiServiceForm.getId());
        this.kpiServiceService.deleteByExample(example);
        List<KpiService> kpiServices = kpiServiceForm.getKpiServiceList();
        for (KpiService kpiService : kpiServices) {
            kpiService.setFormId(kpiServiceForm.getId());
            kpiService.setFormNo(kpiServiceForm.getFormNo());
            kpiService.setYear(kpiServiceForm.getYear());
            kpiService.setMonth(kpiServiceForm.getMonth());
            kpiService.setStatus(KpiServiceFormStatus.NEW.getValue());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        }
        kpiServiceService.addAll(kpiServices);
    }
}