package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiServiceMapper;
import com.els.base.performance.entity.*;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiQualifiedRateService;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.swing.*;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiServiceService")
public class KpiServiceServiceImpl implements KpiServiceService {
    @Resource
    protected KpiServiceMapper kpiServiceMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiServiceFormService kpiServiceFormService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    public void addObj(KpiService t) {
        this.kpiServiceMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    public void addAll(List<KpiService> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiServiceMapper.insertBatch(list);
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiServiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    public void deleteByExample(KpiServiceExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiServiceMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    public void modifyObj(KpiService t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiServiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiService", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiService queryObjById(String id) {
        return this.kpiServiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiService", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiService> queryAllObjByExample(KpiServiceExample example) {
        return this.kpiServiceMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiService", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiService> queryObjByPage(KpiServiceExample example) {
        PageView<KpiService> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void AddSupplerByIds(List<String> list, String FormId) {
        List<KpiService> kpiServices = new ArrayList<>();
        for (String companyId : list) {
            Company company = this.companyService.queryObjById(companyId);
            KpiServiceForm kpiServiceForm = this.kpiServiceFormService.queryObjById(companyId);
            KpiService kpiService = new KpiService();
            kpiService.setId(UUIDGenerator.generateUUID());
            kpiService.setFormId(kpiServiceForm.getId());
            kpiService.setFormNo(kpiServiceForm.getFormNo());
            kpiService.setStatus(kpiServiceForm.getFormStatus());
            kpiService.setSupCompanyName(company.getCompanyName());
            kpiService.setSupCompanySapCode(company.getCompanySapCode());
            kpiService.setSupCompanySrmCode(company.getCompanyCode());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setYear(kpiServiceForm.getYear());
            kpiService.setMonth(kpiServiceForm.getMonth());

            KpiDeliveryRateExample example = new KpiDeliveryRateExample();
            example.createCriteria().andMonthEqualTo(kpiService.getMonth())
                    .andYearEqualTo(kpiService.getYear())
                    .andSupCompanySapCodeEqualTo(kpiService.getSupCompanySapCode());
            List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample(example);
            if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                kpiService.setSalesMan(kpiDeliveryRates.get(0).getSalesMan());
                kpiService.setDevelopmentManager(kpiDeliveryRates.get(0).getDevelopmentManager());
            }
            kpiServices.add(kpiService);
        }
        if (CollectionUtils.isNotEmpty(kpiServices)) {
            this.kpiServiceMapper.insertBatch(kpiServices);
        }
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void saveScore(List<KpiService> kpiServiceList) {
        for (KpiService kpiService : kpiServiceList) {
            KpiService kpiServiceUpdate = this.queryObjById(kpiService.getId());
            kpiServiceUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiServiceUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiServiceUpdate.setUpdateTime(new Date());
            kpiServiceUpdate.setLaterCount(kpiService.getLaterCount());
            kpiServiceUpdate.setScore(kpiService.getScore());
            kpiService.setScoreStatus(1);
            this.modifyObj(kpiService);
        }
    }

    @CacheEvict(value = {"kpiService"}, allEntries = true)
    @Override
    @Transactional
    public void submitScore(List<KpiService> kpiServiceList) {
        for (KpiService kpiService : kpiServiceList) {
            KpiService kpiServiceUpdate = this.queryObjById(kpiService.getId());
            kpiServiceUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiServiceUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiServiceUpdate.setUpdateTime(new Date());
            kpiServiceUpdate.setLaterCount(kpiService.getLaterCount());
            kpiServiceUpdate.setScore(kpiService.getScore());
            kpiService.setScoreStatus(2);
            this.modifyObj(kpiService);
        }
        //
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(kpiServiceList.get(0).getFormId())
                .andScoreStatusEqualTo(1);
        List<KpiService> kpiServiceList1 = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(kpiServiceList1)) {
            KpiServiceForm form = this.kpiServiceFormService.queryObjById(kpiServiceList.get(0).getFormId());
            form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            form.setUpdateTime(new Date());
            form.setFormStatus(KpiServiceFormStatus.CONFIRM.getValue());
            this.kpiServiceFormService.modifyObj(form);
        }

    }

    @Cacheable(value = "kpiOriginalExport", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiOriginalExport> queryReportObjByPage(KpiOriginalExportExample example) {
        PageView<KpiOriginalExport> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceMapper.selectReportByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<KpiOriginalExport> queryReportAllObjByExample(KpiOriginalExportExample example) {
        return this.kpiServiceMapper.selectReportByExample(example);
    }
}