package com.els.base.performance.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Constant;
import com.els.base.performance.dao.KpiSupAuditMapper;
import com.els.base.performance.entity.KpiSupAudit;
import com.els.base.performance.entity.KpiSupAuditExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiSupAuditService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultKpiSupAuditService")
public class KpiSupAuditServiceImpl implements KpiSupAuditService {
    @Resource
    protected KpiSupAuditMapper kpiSupAuditMapper;

    @Resource
    protected CompanyUserRefService companyUserRefService;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected DicGroupItemService dicGroupItemService;

    @CacheEvict(value = { "kpiSupAudit" }, allEntries = true)
    @Override
    public void addObj(KpiSupAudit t) {
        t.setCreateTime(new Date());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        this.kpiSupAuditMapper.insertSelective(t);
    }

    @CacheEvict(value = { "kpiSupAudit" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiSupAuditMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiSupAudit" }, allEntries = true)
    @Override
    public void modifyObj(KpiSupAudit t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(t.getUser().getUsername());
        this.kpiSupAuditMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiSupAudit", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiSupAudit queryObjById(String id) {
        return this.kpiSupAuditMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiSupAudit", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiSupAudit> queryAllObjByExample(KpiSupAuditExample example) {
        return this.kpiSupAuditMapper.selectByExample(example);
    }

    // @Cacheable(value = "kpiSupAudit", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiSupAudit> queryObjByPage(KpiSupAuditExample example) {
        PageView<KpiSupAudit> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupAuditMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void submit(String id) {
        KpiSupAudit kpiSupAudit = new KpiSupAudit();
        kpiSupAudit.setId(id);
        kpiSupAudit.setStatus("1");
        this.kpiSupAuditMapper.updateByPrimaryKeySelective(kpiSupAudit);
    }

    @Override
    public void addObject(KpiSupAudit t) {
        // 时间格式修改
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        try {
            t.setAuditDate(sdf.parse(sdf.format(t.getAuditDate())));
            t.setPlanReviewTime(sdf.parse(sdf.format(t.getPlanReviewTime())));
            t.setShouldSubTime(sdf.parse(sdf.format(t.getShouldSubTime())));
            t.setSubTime(sdf.parse(sdf.format(t.getSubTime())));
            t.setProblemCloseTime(sdf.parse(sdf.format(t.getProblemCloseTime())));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank(t.getQsv()) && t.getQsv().equals("是")) {
            t.setQsv(Constant.YES_INT.toString());
        } else {
            t.setQsv(Constant.NO_INT.toString());
        }
        if (StringUtils.isNotBlank(t.getQtp()) && t.getQtp().equals("是")) {
            t.setQtp(Constant.YES_INT.toString());
        } else {
            t.setQsv(Constant.NO_INT.toString());
        }

        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());

        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(t.getSupCompanySrmCode());
        List<Company> companies = this.companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isEmpty(companies)) {
            throw new CommonException("供应商SRM编码:" + t.getSupCompanySrmCode() + "不存在，请确认修改", "do_not_exists",
                    "供应商SRM编码:" + t.getSupCompanySrmCode());
        }
        User user = this.companyUserRefService.queryMainUserOfCompany(companies.get(0).getId());// 供应商的角色info
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        t.setSupCompanyId(companies.get(0).getId());
        t.setSupCompanySapCode(companies.get(0).getCompanySapCode());
        t.setSupCompanyName(companies.get(0).getCompanyName());
        t.setSupplierAddress(companies.get(0).getAddress());
        t.setServiceType(companies.get(0).getFirstCompanyType());
        t.setServiceCategory(companies.get(0).getFirstCompanyType());
        t.setType(companies.get(0).getClassificationThree());
        // 采购类别
        if (StringUtils.isNotBlank(companies.get(0).getBusinessType())) {
            DicGroupItem dicItem = this.dicGroupItemService.queryItems("sap_business_type", companies.get(0)
                    .getBusinessType());
            if (dicItem != null) {
                t.setPurCategory(dicItem.getName());
            }
        }
        this.kpiSupAuditMapper.insert(t);

    }
}