package com.els.base.performance.service.impl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiSupWeightRankMapper;
import com.els.base.performance.entity.KpiSupWeightRank;
import com.els.base.performance.entity.KpiSupWeightRankExample;
import com.els.base.performance.entity.KpiWeightRank;
import com.els.base.performance.entity.KpiWeightRankExample;
import com.els.base.performance.entity.vo.KpiSupWeightRankVO;
import com.els.base.performance.service.KpiSupWeightRankService;
import com.els.base.performance.service.KpiWeightRankService;

import java.util.Date;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiSupWeightRankService")
public class KpiSupWeightRankServiceImpl implements KpiSupWeightRankService {
    @Resource
    protected KpiSupWeightRankMapper kpiSupWeightRankMapper;

    @Resource
    protected KpiWeightRankService kpiWeightRankService;
    
    @CacheEvict(value = { "kpiSupWeightRank" }, allEntries = true)
    @Override
    public void addObj(KpiSupWeightRank t) {
        this.kpiSupWeightRankMapper.insertSelective(t);
    }

    @CacheEvict(value = { "kpiSupWeightRank" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiSupWeightRankMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiSupWeightRank" }, allEntries = true)
    @Override
    public void modifyObj(KpiSupWeightRank t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiSupWeightRankMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiSupWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiSupWeightRank queryObjById(String id) {
        return this.kpiSupWeightRankMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiSupWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiSupWeightRank> queryAllObjByExample(KpiSupWeightRankExample example) {
        return this.kpiSupWeightRankMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiSupWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiSupWeightRank> queryObjByPage(KpiSupWeightRankExample example) {
        PageView<KpiSupWeightRank> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupWeightRankMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
	@Override
	@Transactional
	public void addSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
		// TODO Auto-generated method stub
     
        // 采购方信息
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurUserId(kpiSupWeightRankVO.user.getId());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurUserName(kpiSupWeightRankVO.user.getNickName());

        kpiSupWeightRankVO.kpiSupWeightRank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
        kpiSupWeightRankVO.kpiSupWeightRank.setRemark(kpiSupWeightRankVO.getKpiSupWeightRank().getRemark());//备注
        kpiSupWeightRankVO.kpiSupWeightRank.setCreateTime(new Date());// 创建时间
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateTime(new Date());// 最后更新时间

        // 保存评供应商权重等级关系信息
        this.kpiSupWeightRankMapper.insertSelective(kpiSupWeightRankVO.kpiSupWeightRank);

        // 供应商权重
        List<KpiWeightRank> kpiWeight = kpiSupWeightRankVO.getKpiWeight();// 获取供应商权重
        if (kpiWeight != null && kpiWeight.size() > 0) {
            for (KpiWeightRank weight : kpiWeight) {
                // 采购方信息
                weight.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                weight.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                weight.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                weight.setPurUserId(kpiSupWeightRankVO.user.getId());
                weight.setPurUserName(kpiSupWeightRankVO.user.getNickName());

                weight.setFunctionType("1");//类别，1:权重，2:等级
                weight.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
                weight.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
                weight.setProjectCode(weight.getProjectCode());//评估类别编码
                weight.setProjectName(weight.getProjectName());//评估类别名称
                weight.setWeightValue(weight.getWeightValue());//权重值

                weight.setCreateTime(new Date());// 创建时间
                weight.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
                weight.setLastUpdateTime(new Date());// 最后更新时间

                // 保存供应商权重
                this.kpiWeightRankService.addObj(weight);
            }
        }
        //供应商等级
        List<KpiWeightRank> kpiRank = kpiSupWeightRankVO.getKpiRank();// 获取供应商等级
        if (kpiRank != null && kpiRank.size() > 0) {
            for (KpiWeightRank rank : kpiRank) {
            	 // 采购方信息
                rank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                rank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                rank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                rank.setPurUserId(kpiSupWeightRankVO.user.getId());
                rank.setPurUserName(kpiSupWeightRankVO.user.getNickName());

                rank.setFunctionType("2");//类别，1:权重，2:等级
                rank.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
                rank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
                rank.setProjectCode(rank.getProjectCode());//评估类别编码
                rank.setProjectName(rank.getProjectName());//评估类别名称
                rank.setBeginNumber(rank.getBeginNumber());//等级开始值
                rank.setEndNumber(rank.getEndNumber());//等级结束值

                rank.setCreateTime(new Date());// 创建时间
                rank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
                rank.setLastUpdateTime(new Date());// 最后更新时间

                // 保存供应商权重
                this.kpiWeightRankService.addObj(rank);
            }

        }

	}
    
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
	@Override
	@Transactional
	public void editSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
		// TODO Auto-generated method stub
     
    	KpiSupWeightRank kpiSupWeightRank = new KpiSupWeightRank();
    	kpiSupWeightRank.setId(kpiSupWeightRankVO.getKpiSupWeightRank().getId());//主键
    	kpiSupWeightRank.setRemark(kpiSupWeightRankVO.getKpiSupWeightRank().getRemark());//备注
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateTime(new Date());// 最后更新时间

        // 保存评供应商权重等级关系信息
        this.kpiSupWeightRankMapper.updateByPrimaryKeySelective(kpiSupWeightRankVO.kpiSupWeightRank);

        // 更新供应商权重, 先删除后重新添加
        KpiWeightRankExample kpiWeightExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiWeightCriteria = kpiWeightExample.createCriteria();
        kpiWeightCriteria.andFunctionTypeEqualTo("1");//类别，1:权重，2:等级
        kpiWeightCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
        kpiWeightCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
        
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
        
        // 重新添加,供应商权重
        List<KpiWeightRank> kpiWeight = kpiSupWeightRankVO.getKpiWeight();// 获取供应商权重
        if (kpiWeight != null && kpiWeight.size() > 0) {
            for (KpiWeightRank weight : kpiWeight) {
                // 采购方信息
                weight.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                weight.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                weight.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                weight.setPurUserId(kpiSupWeightRankVO.user.getId());
                weight.setPurUserName(kpiSupWeightRankVO.user.getNickName());

                weight.setFunctionType("1");//类别，1:权重，2:等级
                weight.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
                weight.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
                weight.setProjectCode(weight.getProjectCode());//评估类别编码
                weight.setProjectName(weight.getProjectName());//评估类别名称
                weight.setWeightValue(weight.getWeightValue());//权重值

                weight.setCreateTime(new Date());// 创建时间
                weight.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
                weight.setLastUpdateTime(new Date());// 最后更新时间

                // 保存供应商权重
                this.kpiWeightRankService.addObj(weight);
            }
        }
        
        // 更新供应商等级，先删除后重新添加
        KpiWeightRankExample kpiRankExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiRankCriteria = kpiRankExample.createCriteria();
        kpiRankCriteria.andFunctionTypeEqualTo("2");//类别，1:权重，2:等级
        kpiRankCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
        kpiRankCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
        
        this.kpiWeightRankService.deleteByExample(kpiRankExample);
        
        // 重新添加
        List<KpiWeightRank> kpiRank = kpiSupWeightRankVO.getKpiRank();// 获取供应商等级
        if (kpiRank != null && kpiRank.size() > 0) {
            for (KpiWeightRank rank : kpiRank) {
            	 // 采购方信息
                rank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                rank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                rank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                rank.setPurUserId(kpiSupWeightRankVO.user.getId());
                rank.setPurUserName(kpiSupWeightRankVO.user.getNickName());

                rank.setFunctionType("2");//类别，1:权重，2:等级
                rank.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
                rank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
                rank.setProjectCode(rank.getProjectCode());//评估类别编码
                rank.setProjectName(rank.getProjectName());//评估类别名称
                rank.setBeginNumber(rank.getBeginNumber());//等级开始值
                rank.setEndNumber(rank.getEndNumber());//等级结束值

                rank.setCreateTime(new Date());// 创建时间
                rank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());// 最后更新人
                rank.setLastUpdateTime(new Date());// 最后更新时间

                // 保存供应商权重
                this.kpiWeightRankService.addObj(rank);
            }

        }

	}
    
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
	@Override
	@Transactional
	public void deleteSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
		// TODO Auto-generated method stub

        // 保存评供应商权重等级关系信息
        this.kpiSupWeightRankMapper.deleteByPrimaryKey(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        
        KpiWeightRankExample kpiWeightExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiWeightCriteria = kpiWeightExample.createCriteria();
        kpiWeightCriteria.andFunctionTypeEqualTo("1");//类别，1:权重，2:等级
        kpiWeightCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
        kpiWeightCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
        
        KpiWeightRankExample kpiRankExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiRankCriteria = kpiRankExample.createCriteria();
        kpiRankCriteria.andFunctionTypeEqualTo("2");//类别，1:权重，2:等级
        kpiRankCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());//供应商权重等级关系表ID
        kpiRankCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());//大类
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
	}
}