package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiSupplierImproveMapper;
import com.els.base.performance.entity.KpiSupplierImprove;
import com.els.base.performance.entity.KpiSupplierImproveExample;
import com.els.base.performance.service.KpiSupplierImproveService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKpiSupplierImproveService")
public class KpiSupplierImproveServiceImpl implements KpiSupplierImproveService {
    @Resource
    protected KpiSupplierImproveMapper kpiSupplierImproveMapper;

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    @Override
    public void addObj(KpiSupplierImprove t) {
        this.kpiSupplierImproveMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    @Override
    public void addAll(List<KpiSupplierImprove> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiSupplierImproveMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiSupplierImproveMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    @Override
    public void deleteByExample(KpiSupplierImproveExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.kpiSupplierImproveMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    @Override
    public void modifyObj(KpiSupplierImprove t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiSupplierImproveMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiSupplierImprove", keyGenerator="redisKeyGenerator")
    @Override
    public KpiSupplierImprove queryObjById(String id) {
        return this.kpiSupplierImproveMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiSupplierImprove", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiSupplierImprove> queryAllObjByExample(KpiSupplierImproveExample example) {
        return this.kpiSupplierImproveMapper.selectByExample(example);
    }

    @Cacheable(value="kpiSupplierImprove", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiSupplierImprove> queryObjByPage(KpiSupplierImproveExample example) {
        PageView<KpiSupplierImprove> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupplierImproveMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int countByExample(KpiSupplierImproveExample example) {
        return kpiSupplierImproveMapper.countByExample(example);
    }
}