package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiTemplateItemMapper;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.service.KpiTemplateItemService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultKpiTemplateItemService")
public class KpiTemplateItemServiceImpl implements KpiTemplateItemService {
    @Resource
    protected KpiTemplateItemMapper kpiTemplateItemMapper;

    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    @Override
    public void addObj(KpiTemplateItem t) {
        this.kpiTemplateItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiTemplateItemMapper.deleteByPrimaryKey(id);
    }
    
    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    @Override
    public void deleteByExample(KpiTemplateItemExample exampl) {
        this.kpiTemplateItemMapper.deleteByExample(exampl);
    }
    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    @Override
    public void modifyObj(KpiTemplateItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.kpiTemplateItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiTemplateItem", keyGenerator="redisKeyGenerator")
    @Override
    public KpiTemplateItem queryObjById(String id) {
        return this.kpiTemplateItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiTemplateItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiTemplateItem> queryAllObjByExample(KpiTemplateItemExample example) {
        return this.kpiTemplateItemMapper.selectByExample(example);
    }

    @Cacheable(value="kpiTemplateItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiTemplateItem> queryObjByPage(KpiTemplateItemExample example) {
        PageView<KpiTemplateItem> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiTemplateItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}