package com.els.base.performance.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiTemplateMapper;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateVO;
import com.els.base.performance.entity.KpiTemplateWeight;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.performance.service.KpiTemplateService;
import com.els.base.performance.service.KpiTemplateWeightService;

@Service("defaultKpiTemplateService")
public class KpiTemplateServiceImpl implements KpiTemplateService {
    @Resource
    protected KpiTemplateMapper kpiTemplateMapper;

    /*
     * @Resource protected KpiTemplateItemMapper kpiTemplateItemMapper;
     * 
     * @Resource protected KpiTemplateWeightMapper kpiTemplateWeightMapper;
     */
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;

    @Resource
    protected KpiTemplateWeightService kpiTemplateWeightService;

    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    public void addObj(KpiTemplate t) {
        this.kpiTemplateMapper.insertSelective(t);
    }

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    public void modifyObj(KpiTemplate t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.kpiTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiTemplate", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiTemplate queryObjById(String id) {
        return this.kpiTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiTemplate", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiTemplate> queryAllObjByExample(KpiTemplateExample example) {
        return this.kpiTemplateMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiTemplate", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiTemplate> queryObjByPage(KpiTemplateExample example) {
        PageView<KpiTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    @Transactional
    public void addKpiTemplate(KpiTemplateVO kpiTemplateVO) {
        // TODO Auto-generated method stub
        if (StringUtils.isBlank(kpiTemplateVO.kpiTemplate.getTemplateName())) {
            throw new NullPointerException("模板名称为空不能保存");
        }
        // 获取生成的评估模板编码
        String templateCode = generateCodeService.getNextCode("KPI_TEMPLATE_CODE");

        // 采购方信息
        kpiTemplateVO.kpiTemplate.setPurCompanyId(kpiTemplateVO.company.getId());
        kpiTemplateVO.kpiTemplate.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
        kpiTemplateVO.kpiTemplate.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
        kpiTemplateVO.kpiTemplate.setPurUserId(kpiTemplateVO.user.getId());
        kpiTemplateVO.kpiTemplate.setPurUserName(kpiTemplateVO.user.getNickName());

        kpiTemplateVO.kpiTemplate.setTemplateCode(templateCode);
        kpiTemplateVO.kpiTemplate.setCreateTime(new Date());// 创建时间
        kpiTemplateVO.kpiTemplate.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
        kpiTemplateVO.kpiTemplate.setLastUpdateTime(new Date());// 最后更新时间

        // 保存评估模板
        this.kpiTemplateMapper.insertSelective(kpiTemplateVO.kpiTemplate);

        // 模板评估项类别权重
        List<KpiTemplateWeight> kpiTemplateWeights = kpiTemplateVO.getKpiTemplateWeightList();// 获取评估项类别权重
        if (kpiTemplateWeights != null && kpiTemplateWeights.size() > 0) {
            for (KpiTemplateWeight kpiTemplateWeight : kpiTemplateWeights) {
                // 采购方信息
                kpiTemplateWeight.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateWeight.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateWeight.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateWeight.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateWeight.setPurUserName(kpiTemplateVO.user.getNickName());

                kpiTemplateWeight.setKpiTemplateId(kpiTemplateVO.kpiTemplate.getId());
                kpiTemplateWeight.setTemplateCode(templateCode);

                kpiTemplateWeight.setCreateTime(new Date());// 创建时间
                kpiTemplateWeight.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
                kpiTemplateWeight.setLastUpdateTime(new Date());// 最后更新时间

                // 保存评估模板评估项类别权重
                this.kpiTemplateWeightService.addObj(kpiTemplateWeight);
            }
        }
        // 模板明细
        List<KpiTemplateItem> kpiTemplateItems = kpiTemplateVO.getKpiTemplateItemList();// 获取评估明细
        if (kpiTemplateItems != null && kpiTemplateItems.size() > 0) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItems) {
                // 采购方信息
                kpiTemplateItem.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateItem.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateItem.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateItem.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateItem.setPurUserName(kpiTemplateVO.user.getNickName());

                kpiTemplateItem.setKpiTemplateId(kpiTemplateVO.kpiTemplate.getId());
                kpiTemplateItem.setTemplateCode(templateCode);

                kpiTemplateItem.setCreateTime(new Date());// 创建时间
                kpiTemplateItem.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
                kpiTemplateItem.setLastUpdateTime(new Date());// 最后更新时间
                // 保存评估模板明细
                this.kpiTemplateItemService.addObj(kpiTemplateItem);
            }

        }

    }

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    @Transactional
    public void editKpiTemplate(KpiTemplateVO kpiTemplateVO,
            KpiTemplateWeightExample kpiTemplateWeightExample, KpiTemplateItemExample kpiTemplateItemExample) {
        // TODO Auto-generated method stub
        if (StringUtils.isBlank(kpiTemplateVO.kpiTemplate.getTemplateCode())) {
            throw new NullPointerException("模板编码为空不能保存");
        }
        // 获取生成的评估模板编码
        String templateCode = kpiTemplateVO.kpiTemplate.getTemplateCode();

        KpiTemplate kpiTemplate = new KpiTemplate();
        kpiTemplate.setId(kpiTemplateVO.getKpiTemplate().getId());// 界面传过来的主键id
        kpiTemplate.setTemplateName(kpiTemplateVO.getKpiTemplate().getTemplateName());// 界面传过来的评估模板名称
        kpiTemplate.setPurCompanyCategory(kpiTemplateVO.getKpiTemplate().getPurCompanyCategory());// 界面传过来的供应商分类
        kpiTemplate.setPurCompanyRank(kpiTemplateVO.getKpiTemplate().getPurCompanyRank());// 界面传过来的供应商等级

        // 采购方信息
        /*
         * kpiTemplate.setPurCompanyId(kpiTemplateVO.company.getId());
         * kpiTemplate.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
         * kpiTemplate.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
         * kpiTemplate.setPurUserId(kpiTemplateVO.user.getId());
         * kpiTemplate.setPurUserName(kpiTemplateVO.user.getNickName());
         */

        kpiTemplate.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
        kpiTemplate.setLastUpdateTime(new Date());// 最后更新时间

        // 更新评估模板
        this.kpiTemplateMapper.updateByPrimaryKeySelective(kpiTemplate);

        // 更新模板评估项类别权重
        // 先删除后重新添加
        // this.kpiTemplateWeightMapper.deleteByExample(kpiTemplateWeightExample);
        this.kpiTemplateWeightService.deleteByExample(kpiTemplateWeightExample);
        // 重新添加
        List<KpiTemplateWeight> kpiTemplateWeights = kpiTemplateVO.getKpiTemplateWeightList();// 获取评估项类别权重
        if (kpiTemplateWeights != null && kpiTemplateWeights.size() > 0) {
            for (KpiTemplateWeight kpiTemplateWeight : kpiTemplateWeights) {
                kpiTemplateWeight.setTemplateCode(templateCode);

                // 采购方信息
                kpiTemplateWeight.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateWeight.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateWeight.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateWeight.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateWeight.setPurUserName(kpiTemplateVO.user.getNickName());

                kpiTemplateWeight.setCreateTime(new Date());// 创建时间
                kpiTemplateWeight.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
                kpiTemplateWeight.setLastUpdateTime(new Date());// 最后更新时间

                // 保存评估模板评估项类别权重
                this.kpiTemplateWeightService.addObj(kpiTemplateWeight);
            }
        }
        // 更新模板明细
        // 先删除后重新添加
        this.kpiTemplateItemService.deleteByExample(kpiTemplateItemExample);
        // 重新添加
        List<KpiTemplateItem> kpiTemplateItems = kpiTemplateVO.getKpiTemplateItemList();// 获取评估明细
        if (kpiTemplateItems != null && kpiTemplateItems.size() > 0) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItems) {
                kpiTemplateItem.setTemplateCode(templateCode);

                // 采购方信息
                kpiTemplateItem.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateItem.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateItem.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateItem.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateItem.setPurUserName(kpiTemplateVO.user.getNickName());

                kpiTemplateItem.setCreateTime(new Date());// 创建时间
                kpiTemplateItem.setLastUpdateUser(kpiTemplateVO.user.getNickName());// 最后更新人
                kpiTemplateItem.setLastUpdateTime(new Date());// 最后更新时间

                // 保存评估模板明细
                this.kpiTemplateItemService.addObj(kpiTemplateItem);
            }

        }

    }

    @CacheEvict(value = { "kpiTemplate" }, allEntries = true)
    @Override
    @Transactional
    public void deleteKpiTemplate(KpiTemplateVO kpiTemplateVO,
            KpiTemplateWeightExample kpiTemplateWeightExample, KpiTemplateItemExample kpiTemplateItemExample) {
        // TODO Auto-generated method stub
        if (StringUtils.isBlank(kpiTemplateVO.kpiTemplate.getTemplateCode())) {
            throw new NullPointerException("模板编码为空不能删除");
        }
        if (StringUtils.isBlank(kpiTemplateVO.getKpiTemplate().getId())) {
            throw new NullPointerException("模板id为空不能删除");
        }
        // 删除评估模板
        this.kpiTemplateMapper.deleteByPrimaryKey(kpiTemplateVO.getKpiTemplate().getId());

        // 删除模板评估项类别权重
        this.kpiTemplateWeightService.deleteByExample(kpiTemplateWeightExample);

        // 删除模板明细
        this.kpiTemplateItemService.deleteByExample(kpiTemplateItemExample);

    }

}