package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiTemplateWeightMapper;
import com.els.base.performance.entity.KpiTemplateWeight;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.service.KpiTemplateWeightService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultKpiTemplateWeightService")
public class KpiTemplateWeightServiceImpl implements KpiTemplateWeightService {
    @Resource
    protected KpiTemplateWeightMapper kpiTemplateWeightMapper;

    @CacheEvict(value={"kpiTemplateWeight"}, allEntries=true)
    @Override
    public void addObj(KpiTemplateWeight t) {
        this.kpiTemplateWeightMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiTemplateWeight"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.kpiTemplateWeightMapper.deleteByPrimaryKey(id);
    }
    
    @CacheEvict(value={"kpiTemplateWeight"}, allEntries=true)
    @Override
    public void deleteByExample(KpiTemplateWeightExample exampl) {
        this.kpiTemplateWeightMapper.deleteByExample(exampl);
    }

    @CacheEvict(value={"kpiTemplateWeight"}, allEntries=true)
    @Override
    public void modifyObj(KpiTemplateWeight t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.kpiTemplateWeightMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="kpiTemplateWeight", keyGenerator="redisKeyGenerator")
    @Override
    public KpiTemplateWeight queryObjById(String id) {
        return this.kpiTemplateWeightMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="kpiTemplateWeight", keyGenerator="redisKeyGenerator")
    @Override
    public List<KpiTemplateWeight> queryAllObjByExample(KpiTemplateWeightExample example) {
        return this.kpiTemplateWeightMapper.selectByExample(example);
    }

    @Cacheable(value="kpiTemplateWeight", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<KpiTemplateWeight> queryObjByPage(KpiTemplateWeightExample example) {
        PageView<KpiTemplateWeight> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiTemplateWeightMapper.selectByExampleByPage(example));
        return pageView;
    }
}