package com.els.base.performance.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiWeightRankMapper;
import com.els.base.performance.entity.KpiWeightRank;
import com.els.base.performance.entity.KpiWeightRankExample;
import com.els.base.performance.service.KpiWeightRankService;

@Service("defaultKpiWeightRankService")
public class KpiWeightRankServiceImpl implements KpiWeightRankService {
    @Resource
    protected KpiWeightRankMapper kpiWeightRankMapper;

    @CacheEvict(value = { "kpiWeightRank" }, allEntries = true)
    @Override
    public void addObj(KpiWeightRank t) {
        this.kpiWeightRankMapper.insertSelective(t);
    }

    @CacheEvict(value = { "kpiWeightRank" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiWeightRankMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiWeightRank" }, allEntries = true)
    @Override
    public void modifyObj(KpiWeightRank t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.kpiWeightRankMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiWeightRank queryObjById(String id) {
        return this.kpiWeightRankMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiWeightRank> queryAllObjByExample(KpiWeightRankExample example) {
        return this.kpiWeightRankMapper.selectByExample(example);
    }

    @Cacheable(value = "kpiWeightRank", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiWeightRank> queryObjByPage(KpiWeightRankExample example) {
        PageView<KpiWeightRank> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiWeightRankMapper.selectByExampleByPage(example));
        return pageView;
    }

	@Override
	public void deleteByExample(KpiWeightRankExample example) {
		// TODO Auto-generated method stub
		this.kpiWeightRankMapper.deleteByExample(example);
	}
}