package com.els.base.performance.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.performance.entity.vo.EvaluateVO;
import com.els.base.performance.entity.vo.ExcelEvaluateVO;
import com.els.base.performance.entity.vo.ExcelVO;
import com.els.base.utils.json.JsonUtils;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 绩效Excel导入评分工具类
 * @author linyuqin
 */
public class ExcelEvaluateUtil {

    private static Logger logger = LoggerFactory.getLogger(ExcelEvaluateUtil.class);

    public static List<Map<String, Map<String, String>>> excel2List(MultipartFile file, ExcelVO excelVO) {
        validFile(file);
        try {
            // 评分项数量
            int evaluateCount = excelVO.getList().get(0).getProjectCodeList().size();
            Workbook workbook = Workbook.getWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheet(0);
            // 一共多少行
            int rows = sheet.getRows();
            List<Map<String, Map<String, String>>> result = new ArrayList<>();
            // i从1开始去掉第一行
            for (int i = 1; i < rows; i++) {
                Cell[] row = sheet.getRow(i);
                if (row.length != evaluateCount + 1) {
                    // 评分项的数量加一列供应商编码
                    throw new CommonException("请导入正确的Excel内容！");
                }
                // 第一列为供应商编码
                String companyCode = row[0].getContents();
                if (StringUtils.isEmpty(companyCode)) {
                    throw new CommonException("Excel供应商编码不能为空！");
                }
                Map<String, Map<String, String>> companyMap = new HashMap<>();
                for (EvaluateVO evaluateVO : excelVO.getList()) {
                    if (companyCode.equals(evaluateVO.getSupplierSrmCode())) {
                        Map<String, String> scoreMap = new HashMap<>();
                        // j从1开始跳过第一列供应商编码
                        for (int j = 1; j < row.length; j++) {
                            // 评分项，与Excel的顺序一样
                            List<String> projectCodeList = evaluateVO.getProjectCodeList();
                            scoreMap.put(projectCodeList.get(j - 1), row[j].getContents());
                        }
                        companyMap.put(companyCode, scoreMap);
                        break;
                    }
                }
                if (companyMap.size() > 0) {
                    result.add(companyMap);
                }
            }
            return result;
        } catch (IOException e) {
            logger.error("绩效模块-导入Excel评分异常-IOException，message：" + e.getMessage());
            throw new CommonException("导入评分异常");
        } catch (BiffException e) {
            logger.error("绩效模块-导入Excel评分异常-BiffException，message：" + e.getMessage());
            throw new CommonException("导入评分异常");
        }
    }

    /**
     * 校验文件
     * @param file 文件
     */
    private static void validFile(MultipartFile file) {
        if (file == null) {
            throw new CommonException("文件为空！");
        }
        String type = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        if (!".xls".equals(type)) {
            throw new CommonException("文件格式错误，请选择【.xls】文件");
        }
    }
}
