package com.els.base.performance.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.vo.EliminateVO;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiScoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

@Api(value = "绩效管理-评估表")
@Controller
@RequestMapping("eliminate")
public class EliminateController {
    private Logger logger = LoggerFactory.getLogger(EliminateController.class);
    @Resource
    protected KpiFormService kpiFormService;

    @Resource
    protected KpiScoreService kpiScoreService;

    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;

    @ApiOperation(httpMethod = "POST", value = "淘汰供应商")
    @RequestMapping("service/eliminateSapSupplier")
    @ResponseBody
    public ResponseResult<String> eliminateSapSupplier(@RequestBody EliminateVO eliminateVO) {
        logger.info("eliminateSapSupplier");
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanySapCodeEqualTo(eliminateVO.getSupCompanySapCode());
        logger.info("queryAllSupplerCompanies");
        List<Company> CompanyArray=this.companyService.queryAllSupplerCompanies(CompanyUtils.currentCompany().getId(), example);
        if (CollectionUtils.isNotEmpty(CompanyArray)) {

        }
        Company company = CompanyArray.get(0);
        company.setIsEnable(Constant.NO_INT);
        company.setRemark(company.getRemark() + " " + eliminateVO.getRemark());
        this.companyService.modifyObj(company);
        logger.info("queryUserListOfCompany");
        List<User> userList = companyUserRefService.queryUserListOfCompany(company.getId());
        if (CollectionUtils.isNotEmpty(userList)) {
            for (User user : userList) {
                user.setIsEnable(Constant.NO_INT);
                this.userService.modifyObj(user);
            }
        }
        return ResponseResult.success();
    }
}
