package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiAdverseEventService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;

@Api(value = "不良事件")
@Controller
@RequestMapping("kpiAdverseEvent")
public class KpiAdverseEventController {
    @Resource
    protected KpiAdverseEventService kpiAdverseEventService;

    @ApiOperation(httpMethod = "POST", value = "创建不良事件")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiAdverseEvent kpiAdverseEvent) {
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        kpiAdverseEvent.setCompany(company);
        kpiAdverseEvent.setUser(user);
        this.kpiAdverseEventService.addObj(kpiAdverseEvent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑不良事件")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiAdverseEvent kpiAdverseEvent) {
        Assert.isNotBlank(kpiAdverseEvent.getId(), "id 为空，保存失败");
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        kpiAdverseEvent.setCompany(company);
        kpiAdverseEvent.setUser(user);
        this.kpiAdverseEventService.modifyObj(kpiAdverseEvent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除不良事件")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.kpiAdverseEventService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购方查询不良事件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiAdverseEvent", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPageForPur")
    @ResponseBody
    public ResponseResult<PageView<KpiAdverseEvent>> findByPageForPur(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiAdverseEventExample example = new KpiAdverseEventExample();
        example.setPageView(new PageView<KpiAdverseEvent>(pageNo, pageSize));

        // KpiAdverseEventExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        // 获取当前登录人权限信息
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView<KpiAdverseEvent> pageData = this.kpiAdverseEventService.queryObjByPage(example);
        List<KpiAdverseEvent> queryResult = pageData.getQueryResult();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); i++) {
            // 不良事件单是否当前登录用户创建
            if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                    && !roleCodeList.contains("supplier")
                    && !queryResult.get(i).getPurUserId().equals(SpringSecurityUtils.getLoginUserId())) {
                queryResult.get(i).setCurrentUserCreate("0");
            } else {
                queryResult.get(i).setCurrentUserCreate("1");
            }
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商查询不良事件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiAdverseEvent", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPageForSup")
    @ResponseBody
    public ResponseResult<PageView<KpiAdverseEvent>> findByPageForSup(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiAdverseEventExample example = new KpiAdverseEventExample();
        example.setPageView(new PageView<KpiAdverseEvent>(pageNo, pageSize));

        Company company = CompanyUtils.currentCompany();
        KpiAdverseEventExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode()).andStatusNotEqualTo(
                KpiAdverseEventStatus.NO_SEND.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        example.setOrderByClause("CREATE_TIME DESC");
        PageView<KpiAdverseEvent> pageData = this.kpiAdverseEventService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "不良事件操作 0:采购方发送 1:供应商申诉 2:采购方拒绝申诉 3:作废")
    @RequestMapping("service/operation")
    @ResponseBody
    public ResponseResult<String> operation(@RequestBody List<KpiAdverseEvent> kpiAdverseEvents, String type) {
        for (int i = 0; CollectionUtils.isNotEmpty(kpiAdverseEvents) && i < kpiAdverseEvents.size(); i++) {
            KpiAdverseEvent kpiAdverseEvent = kpiAdverseEvents.get(i);
            kpiAdverseEvent.setCompany(CompanyUtils.currentCompany());
            kpiAdverseEvent.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiAdverseEventService.supSubmitAppeal(kpiAdverseEvent, type);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "不良事件导出excel")
    @RequestMapping("service/downloadExcel")
    @ResponseBody
    public ModelAndView downloadExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("不良事件" + ".xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    null, "不良事件", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value = "不良事件excel导入", httpMethod = "POST")
    @RequestMapping(value = "service/uploadExcel")
    @ResponseBody
    public ResponseResult<String> uploadExcel(MultipartHttpServletRequest request) {
        List<KpiAdverseEvent> importExcelDataToMap = new ArrayList<KpiAdverseEvent>();
        try {
            Map<String, MultipartFile> fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys();
            importExcelDataToMap = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0,
                    titleAndModelKeys, KpiAdverseEvent.class);
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }
        for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); i++) {
            KpiAdverseEvent kpiAdverseEvent = importExcelDataToMap.get(i);
            kpiAdverseEvent.setCompany(CompanyUtils.currentCompany());
            kpiAdverseEvent.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiAdverseEventService.addObject(kpiAdverseEvent);
        }

        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("事件发生日期", "startTime");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter(dateConverter2);
        titleAndModelKey2.setToStrConverter(dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SRM编码", "supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("事项简述", "briefResume"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("类别(影响/服务)", "type"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("事项", "matter"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("扣分", "points"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购备注", "remark"));
        return titleAndModelKeys;
    }
}