package com.els.base.performance.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiConfiguration;
import com.els.base.performance.entity.KpiConfigurationExample;
import com.els.base.performance.service.KpiConfigurationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "绩效评分等级调剂")
@Controller
@RequestMapping("kpiConfiguration")
public class KpiConfigurationController {
    @Resource
    protected KpiConfigurationService kpiConfigurationService;

    @ApiOperation(httpMethod = "POST", value = "创建绩效评分等级调剂")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiConfiguration kpiConfiguration) {
        if (StringUtils.isEmpty(kpiConfiguration.getLevel())) {
            throw new CommonException("等级内容不能为空");
        }
        if (kpiConfiguration.getStartScore() == null) {
            throw new CommonException("起始分数必须为0-100的内的数值");
        }
        if (kpiConfiguration.getStartScore() == null) {
            throw new CommonException("结束分数必须为0-100的内的数值");
        }
        if (kpiConfiguration.getStartScore() < 0 || kpiConfiguration.getStartScore() > 100) {
            throw new CommonException("开始分数必须为0-100的内的数值");
        }
        if (kpiConfiguration.getEndScore() < 0 || kpiConfiguration.getEndScore() > 100) {
            throw new CommonException("结束分数必须为0-100的内的数值");
        }
        this.kpiConfigurationService.addObj(kpiConfiguration);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑绩效评分等级调剂")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiConfiguration kpiConfiguration) {
        Assert.isNotBlank(kpiConfiguration.getId(), "id 为空，保存失败");
        if (StringUtils.isEmpty(kpiConfiguration.getLevel())) {
            throw new CommonException("等级内容不能为空");
        }
        if (kpiConfiguration.getStartScore() < 0 || kpiConfiguration.getStartScore() > 100) {
            throw new CommonException("开始分数必须为0-100的内的数值");
        }
        if (kpiConfiguration.getEndScore() < 0 || kpiConfiguration.getEndScore() > 100) {
            throw new CommonException("结束分数必须为0-100的内的数值");
        }
        this.kpiConfigurationService.modifyObj(kpiConfiguration);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除绩效评分等级调剂")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiConfigurationExample example = new KpiConfigurationExample();
        example.createCriteria().andIdIn(ids);
        this.kpiConfigurationService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询绩效评分等级调剂")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiConfiguration", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiConfiguration>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiConfigurationExample example = new KpiConfigurationExample();
        example.setPageView(new PageView<KpiConfiguration>(pageNo, pageSize));

        KpiConfigurationExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiConfiguration> pageData = this.kpiConfigurationService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}