package com.els.base.performance.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.automatic.DeliveryRate;
import com.els.base.performance.entity.*;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.vo.TemplateExcelVo;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "供应商交付率 原始数据")
@Controller
@RequestMapping("kpiDeliveryRate")
public class KpiDeliveryRateController {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @ApiOperation(httpMethod = "POST", value = "创建供应商交付率 原始数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiDeliveryRate kpiDeliveryRate) {
        this.kpiDeliveryRateService.addObj(kpiDeliveryRate);
        return ResponseResult.success(kpiDeliveryRate.getId());
    }

    @ApiOperation(httpMethod = "POST", value = "编辑供应商交付率 原始数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiDeliveryRate kpiDeliveryRate) {
        Assert.isNotBlank(kpiDeliveryRate.getId(), "id 为空，保存失败");
        this.kpiDeliveryRateService.modifyObj(kpiDeliveryRate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商交付率 原始数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.createCriteria().andIdIn(ids);
        this.kpiDeliveryRateService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询供应商交付率 原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiDeliveryRate", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiDeliveryRate>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.setPageView(new PageView<KpiDeliveryRate>(pageNo, pageSize));

        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (CompanyUtils.isSupCompany()) {
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiDeliveryRate> pageData = this.kpiDeliveryRateService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "查询供应商交付率(供应商) 原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiDeliveryRate", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiDeliveryRate>> supplierFindByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.setPageView(new PageView<KpiDeliveryRate>(pageNo, pageSize));

        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiDeliveryRate> pageData = this.kpiDeliveryRateService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "导入交货率原始数据模板下载", httpMethod = "GET")
    @RequestMapping(value = "service/dowloadTemplateExcel")
    @ResponseBody
    public ModelAndView dowloadTemplateExcel(HttpServletResponse response) {
        try {

            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "交付率导入模板" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            List<KpiDeliveryRate> kpiDeliveryRates = new ArrayList<>();
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = createTitleAndModelKeyArray(true);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    kpiDeliveryRates, "交付率模板", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray(boolean template) {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("分类", "category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("业务员", "salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开发经理", "developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("准时交付", "onTimeDelivery"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("超期JIT", "beyondJit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("未交付JIT", "noDeliveryJit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商原因", "supplierReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("康尼原因", "kangniReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("总计", "total"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("第1版(系统数据)", "firstEdition"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("第2版(生产签字版)", "secondEdition"));
        if (template) {
            return titleAndModelKeys;
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("年份", "year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("月份", "month"));
        return titleAndModelKeys;
    }


    @ApiOperation(value = "导入交货率原始数据", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importFromExcel"})
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request,
                                                              @RequestParam( required = true) int Year,
                                                              @RequestParam( required = true) int Month) {

        Map<String, MultipartFile> fileMap = request.getFileMap();

        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }

        if (fileMap.size() > 1) {
            throw new CommonException("无法同时处理多个上传文件");
        }

        String key = fileMap.keySet().iterator().next();
        MultipartFile uploadFile = fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
        List<KpiDeliveryRate> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(uploadFile.getInputStream(), 0, 1, 0, titleAndModelKeys, KpiDeliveryRate.class);
        } catch (Exception e) {
            throw new CommonException("导入异常：" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (KpiDeliveryRate kpiDeliveryRate : list) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanySapCodeEqualTo(kpiDeliveryRate.getSupCompanySapCode());
                List<Company> companies = this.companyService.queryAllObjByExample(example);
                if (CollectionUtils.isNotEmpty(companies)) {
                    kpiDeliveryRate.setSupCompanySrmCode(companies.get(0).getCompanyCode());
                    kpiDeliveryRate.setCriticality(companies.get(0).getCriticalityName());
                    kpiDeliveryRate.setSymbiosis(companies.get(0).getSymbiosis());
                    kpiDeliveryRate.setProductImportance(companies.get(0).getProductImportanceName());
                }
                kpiDeliveryRate.setUpdateTime(new Date());
                kpiDeliveryRate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiDeliveryRate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                kpiDeliveryRate.setYear(String.valueOf(Year));
                kpiDeliveryRate.setMonth(String.valueOf(Month));
            }
            this.kpiDeliveryRateService.ImportFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "导出交货及时率原始数据")
    @RequestMapping("service/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("交货及时率" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiDeliveryRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    @ApiOperation(httpMethod = "POST", value = "导出交货及时率原始数据(供应商)")
    @RequestMapping("service/sup/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("交货及时率" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiDeliveryRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }



    @ApiOperation(httpMethod = "POST", value = "查询供应商交付率 原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiOriginalExport", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findReportByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiOriginalExport>> findReportByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        example.setPageView(new PageView<KpiOriginalExport>(pageNo, pageSize));
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiOriginalExport> pageData = this.kpiDeliveryRateService.queryReportObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "导出交货及时率原始数据")
    @RequestMapping("service/dowloadReportExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadReportExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiOriginalExportExample example = new KpiOriginalExportExample();
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiOriginalExport> kpiOriginalExports = this.kpiDeliveryRateService.queryReportAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("交货及时率年度报表" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createReportTitleAndModelKeyArray();

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiOriginalExports, "交货及时率年度报表", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }

    private List<TitleAndModelKey> createReportTitleAndModelKeyArray() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("分类", "category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("业务员", "salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开发经理", "developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("年份", "year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("一月(系统数据)", "January1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("一月(实际数据)", "January2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("二月(系统数据)", "February1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("二月(实际数据)", "February2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("三月(系统数据)", "March1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("三月(实际数据)", "March2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("四月(系统数据)", "April1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("四月(实际数据)", "April2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("五月(系统数据)", "May1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("五月(实际数据)", "May2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("六月(系统数据)", "June1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("六月(实际数据)", "June2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("七月(系统数据)", "July1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("七月(实际数据)", "July2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("八月(系统数据)", "August1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("八月(实际数据)", "August2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("九月(系统数据)", "September1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("九月(实际数据)", "September2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十月(系统数据)", "October1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十月(实际数据)", "October2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十一月(系统数据)", "November1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十一月(实际数据)", "November2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十二月(系统数据)", "December1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十二月(实际数据)", "December2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("平均(系统数据)", "AvgValue1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("平均(实际数据)", "AvgValue2"));

        return titleAndModelKeys;
    }
}