package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.service.KpiEvaluateSectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="评估区间")
@Controller
@RequestMapping("kpiEvaluateSection")
public class KpiEvaluateSectionController {
    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;

    @ApiOperation(httpMethod="POST", value="创建评估区间")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiEvaluateSection kpiEvaluateSection) {
        if (kpiEvaluateSection.getStartSection() == null || kpiEvaluateSection.getEndSection() == null
                || kpiEvaluateSection.getScore() == null) {
            throw new CommonException("请输入分数！！");
        }
        // 做交集的判断
        checkSection(kpiEvaluateSection);
        kpiEvaluateSection.setCreateTime(new Date());
        kpiEvaluateSection.setCreateUser(SpringSecurityUtils.getLoginUserName());
        kpiEvaluateSection.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
        this.kpiEvaluateSectionService.addObj(kpiEvaluateSection);
        return ResponseResult.success(kpiEvaluateSection.getId());
    }

    @ApiOperation(httpMethod="POST", value="编辑评估区间")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiEvaluateSection kpiEvaluateSection) {
        Assert.isNotBlank(kpiEvaluateSection.getId(), "id 为空，保存失败");
        checkSection(kpiEvaluateSection);
        this.kpiEvaluateSectionService.modifyObj(kpiEvaluateSection);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除评估区间")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.createCriteria().andIdIn(ids);
        this.kpiEvaluateSectionService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询评估区间")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 KpiEvaluateSection", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiEvaluateSection>> findByPage(
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.setPageView(new PageView<KpiEvaluateSection>(pageNo, pageSize));
        
        KpiEvaluateSectionExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<KpiEvaluateSection> pageData = this.kpiEvaluateSectionService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    /**
     * 新增是判断区间是否有交集
     * @param section 新增的对象
     */
    private void checkSection(KpiEvaluateSection section) {
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        KpiEvaluateSectionExample.Criteria criteria = example.createCriteria();
        criteria.andStartSectionLessThanOrEqualTo(section.getStartSection())
                .andEndSectionGreaterThanOrEqualTo(section.getStartSection())
                .andProjectTypeEqualTo(section.getProjectType());
        if (StringUtils.isNotEmpty(section.getId())) {
            criteria.andIdNotEqualTo(section.getId());
        }
        if (CollectionUtils.isNotEmpty(kpiEvaluateSectionService.queryAllObjByExample(example))) {
            throw new CommonException("保存失败，开始值【" + section.getStartSection() + "】已经存在交集");
        }
        example.clear();
        KpiEvaluateSectionExample.Criteria criteria1 = example.createCriteria();
        criteria1.andStartSectionLessThanOrEqualTo(section.getEndSection())
                .andEndSectionGreaterThanOrEqualTo(section.getEndSection())
                .andProjectTypeEqualTo(section.getProjectType());
        if (StringUtils.isNotEmpty(section.getId())) {
            criteria1.andIdNotEqualTo(section.getId());
        }
        if (CollectionUtils.isNotEmpty(kpiEvaluateSectionService.queryAllObjByExample(example))) {
            throw new CommonException("保存失败，结束值【" + section.getEndSection() + "】已经存在交集");
        }
    }
}