package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiFormAndPerson;
import com.els.base.performance.entity.KpiFormAndPersonExample;
import com.els.base.performance.service.KpiFormAndPersonService;

@Api(value = "绩效管理-评估表与评估人关系表")
@Controller
@RequestMapping("kpiFormAndPerson")
public class KpiFormAndPersonController {
    @Resource
    protected KpiFormAndPersonService kpiFormAndPersonService;

    @ApiOperation(httpMethod = "POST", value = "创建评估表与评估人关系表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiFormAndPerson kpiFormAndPerson) {
        this.kpiFormAndPersonService.addObj(kpiFormAndPerson);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑评估表与评估人关系表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiFormAndPerson kpiFormAndPerson) {
        if (StringUtils.isBlank(kpiFormAndPerson.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.kpiFormAndPersonService.modifyObj(kpiFormAndPerson);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除评估表与评估人关系表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.kpiFormAndPersonService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询评估表与评估人关系表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiFormAndPerson", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiFormAndPerson>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiFormAndPersonExample example = new KpiFormAndPersonExample();
        example.setPageView(new PageView<KpiFormAndPerson>(pageNo, pageSize));

        KpiFormAndPersonExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<KpiFormAndPerson> pageData = this.kpiFormAndPersonService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}