package com.els.base.performance.web.controller;

import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.*;
import com.els.base.performance.entity.vo.EvaluateVO;
import com.els.base.performance.entity.vo.ExcelEvaluateVO;
import com.els.base.performance.entity.vo.ExcelVO;
import com.els.base.performance.service.*;
import com.els.base.performance.utils.ExcelEvaluateUtil;
import com.els.base.performance.vo.TemplateExcelVo;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.*;

import javax.annotation.Resource;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.vo.KpiFormVo;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value = "绩效管理-评估表")
@Controller
@RequestMapping("kpiForm")
public class KpiFormController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected KpiFormService kpiFormService;

    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;

    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;

    @Resource
    protected KpiOriginalScoreService kpiOriginalScoreService;

    @ApiOperation(httpMethod = "POST", value = "创建评估表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiForm kpiForm) {
        if (CollectionUtils.isEmpty(kpiForm.getKpiFormAndCompanyList())) {
            throw new CommonException("供应商信息不能为空", "base_canot_be_null", "供应商信息");
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("输入的参数长度超标", "database_length_error");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.addObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑评估表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiForm kpiForm) {
        if (StringUtils.isBlank(kpiForm.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("输入的参数长度超标", "database_length_error");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.modifyObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除评估表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.kpiFormService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购方查询评估表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiForm", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiForm>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
                                                        @RequestParam(defaultValue = "10") int pageSize,
                                                        @RequestBody(required = false) QueryParamWapper wapper) {
        KpiFormExample example = new KpiFormExample();
        KpiFormExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setOrderByClause(" CREATE_TIME DESC ");
        example.setPageView(new PageView<KpiForm>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        // 获取当前登录人权限信息
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }

        // 查询当前采购员下管理的所有的供应商的id
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        List<String> srmCompanyIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company c : companyList) {
                srmCompanyIdList.add(c.getId());
            }
        }

        List<KpiForm> finalKpiForms = this.kpiFormService.queryfinalKpiForms(srmCompanyIdList, roleCodeList,
                SpringSecurityUtils.getLoginUser(), this.kpiFormService.queryAllObjByExampleCoustom(example));

        PageView<KpiForm> pageData = new PageView<KpiForm>(pageNo, pageSize);

        pageData.setRowCount(CollectionUtils.isEmpty(finalKpiForms) ? 0 : finalKpiForms.size());
        pageData.setQueryResult(finalKpiForms.subList(pageData.getStartRowNo(), pageData.getEndRowNo()));
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查看评分詳情")
    @RequestMapping("service/lookKpiFormDetails")
    @ResponseBody
    public ResponseResult<KpiForm> lookKpiFormDetails(@RequestParam String kpiFormId) {
        if (StringUtils.isBlank(kpiFormId)) {
            throw new CommonException("查看失败,id不能为空");
        }
        KpiForm kpiForm = this.kpiFormService.lookKpiFormDetails(kpiFormId);
        return ResponseResult.success(kpiForm);
    }

    @ApiOperation(httpMethod = "POST", value = "发布")
    @RequestMapping("service/releaseKpiFrom")
    @ResponseBody
    public ResponseResult<String> releaseKpiFrom(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("发布失败,data不能为空");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.releaseKpiFrom(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "结案评估表")
    @RequestMapping("service/finishForm")
    @ResponseBody
    public ResponseResult<String> finishForm(@RequestBody KpiForm kpiForm) {

        if (StringUtils.isBlank(kpiForm.getId())) {
            // throw new CommonException("模板编码为空，保存失败");
            throw new CommonException("评估表主键id为空不能进行结案", "base_canot_be_null", "评估表主键id");
        }

        if (StringUtils.isBlank(kpiForm.getFormCode())) {
            // throw new CommonException("模板编码为空，保存失败");
            throw new CommonException("评估表编码为空不能进行结案", "base_canot_be_null", "评估表编码");
        }

        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());// 评估项表编码
        criteria.andScoreStateEqualTo("0");// 状态

        List<KpiScore> kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);

        if (kpiScoreList.size() > 0) {
            throw new CommonException("该评估表还有未评分的数据不能进行结案操作", "finish_status", "操作失败！该评估表【评估表编码:"
                    + kpiForm.getFormCode() + "】还有未提交评分的数据，不能进行结案！");
        }

        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        kpiForm.setCompany(company);
        kpiForm.setUser(user);

        this.kpiFormService.finishForm(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购方查看评分")
    @RequestMapping("service/lookAtTheScore")
    @ResponseBody
    public ResponseResult<KpiFormVo> lookAtTheScore(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("查看评分失败,data不能为空");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        return ResponseResult.success(kpiFormVo);
    }

    @ApiOperation(httpMethod = "POST", value = "采购方查看评分")
    @RequestMapping("service/lookAtTheScoreAll")
    @ResponseBody
    public ResponseResult<KpiFormVo> lookAtTheScoreAll(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("查看评分失败,data不能为空");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        return ResponseResult.success(kpiFormVo);
    }

    @ApiOperation(httpMethod = "POST", value = "保存评分")
    @RequestMapping("service/saveAtTheScore")
    @ResponseBody
    public ResponseResult<String> saveAtTheScore(@RequestBody KpiFormVo kpiFormVo,
                                                 @RequestParam String saveOrSubmit) {
        if (kpiFormVo == null) {
            throw new CommonException("保存评分失败,data不能为空");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        kpiFormVo.setCompany(company);
        kpiFormVo.setUser(user);
        this.kpiFormService.saveAtTheScore(kpiFormVo, saveOrSubmit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "作废")
    @RequestMapping("service/toVoidDocument")
    @ResponseBody
    public ResponseResult<String> toVoidDocument(String id) {
        this.kpiFormService.toVoidDocument(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "等级调整")
    @RequestMapping("service/rankAdjustMent")
    @ResponseBody
    public ResponseResult<String> rankAdjustMent(@RequestParam String supplierSrmCode,
                                                 @RequestParam String classLevel) {
        if (StringUtils.isBlank(supplierSrmCode) || StringUtils.isBlank(classLevel)) {
            throw new CommonException("等级调整失败,supplierSrmCode,classLevel不能为空");
        }
        this.kpiFormService.rankAdjustMent(supplierSrmCode, classLevel);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询月度报表")
    @RequestMapping("service/queryMonthlyReport")
    @ResponseBody
    public ResponseResult<ReportShow> queryMonthlyReport(@RequestBody ReportQueryParams reportQueryParams) {
        ReportShow monthlyReport = this.kpiFormService.queryMonthlyReport(reportQueryParams);
        return ResponseResult.success(monthlyReport);
    }

    @ApiOperation(httpMethod = "POST", value = "查询季度或年度报表")
    @RequestMapping("service/queryQuarterOrYearReport")
    @ResponseBody
    public ResponseResult<ReportShow> queryQuarterOrYearReport(
            @RequestBody ReportQueryParams reportQueryParams) {
        ReportShow quarterReportShow = this.kpiFormService.queryQuarterOrYearReport(reportQueryParams);
        return ResponseResult.success(quarterReportShow);
    }


    @ApiOperation(httpMethod = "POST", value = "送签绩效结果")
    @RequestMapping("service/sendToSing")
    @ResponseBody
    public ResponseResult<String> sendToSing(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("送签失败,所选单据不能为空");
        }
        if (StringUtils.isBlank(kpiForm.getId())) {
            throw new CommonException("送签失败,id不能为空");
        }
        this.kpiFormService.sendToSing(kpiForm.getId());
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "下载绩效打分模板")
    @RequestMapping("service/dowloadTemplateExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadTemplateExcel(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("查看评分失败,data不能为空");
        }
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("绩效导入模板" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TemplateExcelVo> voList = new ArrayList<>();
            KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
            example.createCriteria().andKpiFormIdEqualTo(kpiForm.getId())
                    .andFormCodeEqualTo(kpiForm.getFormCode());
            List<KpiFormAndCompany> kpiFormAndCompanies = this.kpiFormAndCompanyService.queryAllObjByExample(example);
            if (CollectionUtils.isNotEmpty(kpiFormAndCompanies)) {
                for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanies) {
                    TemplateExcelVo templateExcelVo = new TemplateExcelVo();
                    templateExcelVo.setSupCompanyCode(kpiFormAndCompany.getSupCompanySapCode());
                    templateExcelVo.setSupCompanyName(kpiFormAndCompany.getSupCompanyName());
                    templateExcelVo.setCategoryName(kpiFormAndCompany.getCategoryName());
                    templateExcelVo.setSupCompanySrmCode(kpiFormAndCompany.getSupCompanySrmCode());
                    voList.add(templateExcelVo);
                }
            }

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SRM编码", "supCompanySrmCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商分类", "categoryName"));
            List<Map<String, String>> mapList = kpiFormVo.getTitles();
            if (mapList.size() > 0) {
                for (int i = 1; i <= mapList.size(); i++) {
                    String nameFied = mapList.get(i - 1).get("projectName");
                    String valueFied = "kpiScore" + i;
                    titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(nameFied, valueFied));
                }
            }
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, voList, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    @ApiOperation(httpMethod = "POST", value = "导入评分")
    @RequestMapping("service/importToEvaluate")
    @ResponseBody
    public ResponseResult<List<Map<String, Object>>> importToEvaluate(MultipartFile file, String dataJson) throws IOException {
        if (StringUtils.isEmpty(dataJson)) {
            throw new CommonException("数据不能为空");
        }
        logger.info("dataJson" + dataJson);
        ExcelVO excelVO = JsonUtils.convertValue(dataJson, ExcelVO.class);
        String formId = excelVO.getList().get(0).getKpiFormId();
        String templateCode = excelVO.getList().get(0).getTemplateCode();
        // Excel导入的评分
        List<Map<String, Map<String, String>>> maps = ExcelEvaluateUtil.excel2List(file, excelVO);
        if (CollectionUtils.isEmpty(maps)) {
            throw new CommonException("没有匹配的供应商！");
        }
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (Map<String, Map<String, String>> map : maps) {
            Map<String, Object> companyMap = new HashMap<>();
            map.forEach((companyCode, scoreMap) -> {
                companyMap.put("supplierSrmCode", companyCode);
                KpiOriginalScore score = new KpiOriginalScore();
                scoreMap.forEach((projectCode, originalScore) -> {
                    // 获取评分项对应的projectType
                    KpiTemplateItemExample example = new KpiTemplateItemExample();
                    example.createCriteria().andTemplateCodeEqualTo(templateCode)
                            .andProjectCodeEqualTo(projectCode);
                    List<KpiTemplateItem> kpiTemplateItems = kpiTemplateItemService.queryAllObjByExample(example);
                    if (CollectionUtils.isNotEmpty(kpiTemplateItems)) {
                        String type = kpiTemplateItems.get(0).getProjectType();
                        companyMap.put(projectCode, switchScore(originalScore, type, score));
                    }
                });
                // 保存原始值
                saveOriginalScore(formId, companyCode, score);
            });
            resultList.add(companyMap);
        }
        return ResponseResult.success(resultList);
    }

    private void saveOriginalScore(String formId, String srmCode, KpiOriginalScore score) {
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(formId)
                .andCompanySrmCodeEqualTo(srmCode);
        List<KpiOriginalScore> scoreList = kpiOriginalScoreService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(scoreList)) {
            kpiOriginalScoreService.updateByExampleSelective(example, score);
        } else {
            score.setKpiFormId(formId);
            score.setCompanySrmCode(srmCode);
            kpiOriginalScoreService.addObj(score);
        }
    }

    /**
     * 根据评分项和导入的评分获取分数
     *
     * @param originalScoreStr 导入的评分
     * @param type             评分类型
     * @param score            原始值对象
     * @return 分数
     */
    private Map<String, String> switchScore(String originalScoreStr, String type, KpiOriginalScore score) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isEmpty(originalScoreStr)) {
            map.put("score", null);
            map.put("originalScore", null);
            return map;
        }
        Double originalScore = 0D;
        String originalScorePer = "";
        if (originalScoreStr.length() - 1 == originalScoreStr.lastIndexOf("%")) {
            // 百分数
            originalScorePer = originalScoreStr.substring(0, originalScoreStr.length() - 1);
        } else {
            // 分数
            originalScorePer = originalScoreStr;
        }
        try {
            originalScore = Double.parseDouble(originalScorePer);
        } catch (Exception e) {
            throw new CommonException("请导入正确分数！");
        }
        switch (type) {
            case "deliver":
                score.setOriginalDeliver(originalScoreStr);
                break;
            case "service":
                score.setOriginalService(originalScoreStr);
                break;
            case "price":
                score.setOriginalPrice(originalScoreStr);
                break;
            case "quality":
                score.setOriginalQuality(originalScoreStr);
                break;
            case "qualityCount":
                score.setOriginalQualityCount(originalScoreStr);
                break;
        }
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.createCriteria().andStartSectionLessThanOrEqualTo(originalScore).andProjectTypeEqualTo(type)
                .andEndSectionGreaterThanOrEqualTo(originalScore);
        List<KpiEvaluateSection> kpiEvaluateSections = kpiEvaluateSectionService.queryAllObjByExample(example);
        map.put("originalScore", originalScoreStr);
        if (CollectionUtils.isEmpty(kpiEvaluateSections)) {
            map.put("score", originalScoreStr);
            return map;
        }
        map.put("score", kpiEvaluateSections.get(0).getScore().toString());
        return map;
    }


    @ApiOperation(httpMethod = "POST", value = "查询供应商")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Company", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findSupplerByPage")
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplerByPage(@RequestParam(defaultValue = "0") int pageNo,
                                                               @RequestParam(defaultValue = "10") int pageSize,
                                                               @RequestParam(required = true) int Year,
                                                               @RequestParam(required = true) int Month,
                                                               @RequestBody(required = false) QueryParamWapper wapper) {
        List<String> CompanySapCodes = this.kpiFormService.queryCompanySapCode(String.valueOf(Year), String.valueOf(Month));

        CompanyExample example = new CompanyExample();

        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(CompanySapCodes)) {
            criteria.andCompanySapCodeIn(CompanySapCodes);
        } else {
            criteria.andCompanySapCodeIsNotNull()
                    .andCompanyCodeNotEqualTo("50000000");
        }
        example.setPageView(new PageView<Company>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<Company> pageData = this.companyService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

}
