package com.els.base.performance.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiOriginalScore;
import com.els.base.performance.entity.KpiOriginalScoreExample;
import com.els.base.performance.service.KpiOriginalScoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="Excel导入原始分数")
@Controller
@RequestMapping("kpiOriginalScore")
public class KpiOriginalScoreController {
    @Resource
    protected KpiOriginalScoreService kpiOriginalScoreService;

    @ApiOperation(httpMethod="POST", value="创建Excel导入原始分数")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiOriginalScore kpiOriginalScore) {
        this.kpiOriginalScoreService.addObj(kpiOriginalScore);
        return ResponseResult.success(kpiOriginalScore.getId());
    }

    @ApiOperation(httpMethod="POST", value="编辑Excel导入原始分数")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiOriginalScore kpiOriginalScore) {
        Assert.isNotBlank(kpiOriginalScore.getId(), "id 为空，保存失败");
        this.kpiOriginalScoreService.modifyObj(kpiOriginalScore);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除Excel导入原始分数")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andIdIn(ids);
        this.kpiOriginalScoreService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询Excel导入原始分数")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 KpiOriginalScore", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiOriginalScore>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.setPageView(new PageView<KpiOriginalScore>(pageNo, pageSize));
        
        KpiOriginalScoreExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<KpiOriginalScore> pageData = this.kpiOriginalScoreService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}