package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiQualifiedBatch;
import com.els.base.performance.entity.KpiQualifiedBatchExample;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiQualifiedBatchService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "过程质量批次原始数据")
@Controller
@RequestMapping("kpiQualifiedBatch")
public class KpiQualifiedBatchController {
    @Resource
    protected KpiQualifiedBatchService kpiQualifiedBatchService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;
    @ApiOperation(httpMethod = "POST", value = "创建过程质量批次原始数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiQualifiedBatch kpiQualifiedBatch) {
        this.kpiQualifiedBatchService.addObj(kpiQualifiedBatch);
        return ResponseResult.success(kpiQualifiedBatch.getId());
    }

    @ApiOperation(httpMethod = "POST", value = "编辑过程质量批次原始数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiQualifiedBatch kpiQualifiedBatch) {
        Assert.isNotBlank(kpiQualifiedBatch.getId(), "id 为空，保存失败");
        this.kpiQualifiedBatchService.modifyObj(kpiQualifiedBatch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除过程质量批次原始数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.createCriteria().andIdIn(ids);
        this.kpiQualifiedBatchService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询过程质量批次原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiQualifiedBatch", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiQualifiedBatch>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.setPageView(new PageView<KpiQualifiedBatch>(pageNo, pageSize));

        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (CompanyUtils.isSupCompany()) {
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiQualifiedBatch> pageData = this.kpiQualifiedBatchService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查询过程质量批次原始数据(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiQualifiedBatch", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiQualifiedBatch>> supplierFindByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.setPageView(new PageView<KpiQualifiedBatch>(pageNo, pageSize));

        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiQualifiedBatch> pageData = this.kpiQualifiedBatchService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(value = "导入过程质量批次原始数据模板下载", httpMethod = "GET")
    @RequestMapping(value = "service/dowloadTemplateExcel")
    @ResponseBody
    public ModelAndView dowloadTemplateExcel(HttpServletResponse response) {
        try {

            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "质量批次导入模板" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            List<KpiQualifiedBatch> kpiQualifiedBatches = new ArrayList<>();
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = createTitleAndModelKeyArray(true);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    kpiQualifiedBatches, "质量批次模板", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray(boolean template) {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("序号", "serialNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("编号", "billNo"));
        if (!template) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanySapCode"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开具原因", "openReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("接收日期", "receieDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("年度", "year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("月份", "month"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发生地点", "takePlace"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目", "project"));
        if (template) {
            return titleAndModelKeys;
        }

        return titleAndModelKeys;
    }


    @ApiOperation(value = "导入质量批次原始数据", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importFromExcel"})
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) {

        Map<String, MultipartFile> fileMap = request.getFileMap();

        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }

        if (fileMap.size() > 1) {
            throw new CommonException("无法同时处理多个上传文件");
        }

        String key = fileMap.keySet().iterator().next();
        MultipartFile uploadFile = fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
        List<KpiQualifiedBatch> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(uploadFile.getInputStream(), 0, 1, 0, titleAndModelKeys, KpiQualifiedBatch.class);
        } catch (Exception e) {
            throw new CommonException("导入异常：" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (KpiQualifiedBatch kpiQualifiedBatch : list) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanyNameEqualTo(kpiQualifiedBatch.getSupCompanyName());
                List<Company> companies = this.companyService.queryAllObjByExample(example);
                if (CollectionUtils.isNotEmpty(companies)) {
                    kpiQualifiedBatch.setSupCompanySapCode(companies.get(0).getCompanySapCode());
                    kpiQualifiedBatch.setSupCompanySrmCode(companies.get(0).getCompanyCode());
                    kpiQualifiedBatch.setCriticality(companies.get(0).getCriticalityName());
                    kpiQualifiedBatch.setSymbiosis(companies.get(0).getSymbiosis());
                    kpiQualifiedBatch.setProductImportance(companies.get(0).getProductImportanceName());
                } else {
                    KpiDeliveryRateExample example1=new KpiDeliveryRateExample();
                    example1.createCriteria().andSupCompanyNameEqualTo(kpiQualifiedBatch.getSupCompanyName())
                            .andYearEqualTo(kpiQualifiedBatch.getYear())
                            .andMonthEqualTo(kpiQualifiedBatch.getMonth());
                    List<KpiDeliveryRate> kpiDeliveryRates=this.kpiDeliveryRateService.queryAllObjByExample(example1);
                    if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                        kpiQualifiedBatch.setSupCompanySapCode(kpiDeliveryRates.get(0).getSupCompanySapCode());
                        kpiQualifiedBatch.setSupCompanySrmCode(kpiDeliveryRates.get(0).getSupCompanySrmCode());
                        kpiQualifiedBatch.setCriticality(kpiDeliveryRates.get(0).getCriticality());
                        kpiQualifiedBatch.setSymbiosis(kpiDeliveryRates.get(0).getSymbiosis());
                        kpiQualifiedBatch.setProductImportance(kpiDeliveryRates.get(0).getProductImportance());
                    }
                }
                kpiQualifiedBatch.setUpdateTime(new Date());
                kpiQualifiedBatch.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiQualifiedBatch.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            }
            this.kpiQualifiedBatchService.ImportFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "导出质量批次原始数据")
    @RequestMapping("service/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiQualifiedBatch> kpiQualifiedRates = this.kpiQualifiedBatchService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("质量批次" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiQualifiedRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }

    @ApiOperation(httpMethod = "POST", value = "导出质量批次原始数据(供应商)")
    @RequestMapping("service/sup/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiQualifiedBatch> kpiQualifiedRates = this.kpiQualifiedBatchService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("质量批次" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiQualifiedRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }
}