package com.els.base.performance.web.controller;

import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.vo.KpiRankingExcelVo;
import com.els.base.performance.vo.KpiRankingScoreVo;
import com.els.base.utils.excel.BigDecimalConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.*;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.entity.vo.KpiRankingVo;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "绩效管理-排名表")
@Controller
@RequestMapping("kpiRanking")
public class KpiRankingController {
    @Resource
    protected KpiRankingService kpiRankingService;

    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod = "POST", value = "创建排名表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiRanking kpiRanking) {
        this.kpiRankingService.addObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑排名表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiRanking kpiRanking) {
        if (StringUtils.isBlank(kpiRanking.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.kpiRankingService.modifyObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除排名表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.kpiRankingService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购方查询排名表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiRanking", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
                                                           @RequestParam(defaultValue = "10") int pageSize,
                                                           @RequestBody(required = false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setPageView(new PageView<KpiRanking>(pageNo, pageSize));

        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView<KpiRanking> pageData = this.kpiRankingService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("评估表编码", "formCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("评估表名称", "formName"));

        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("开始时间", "formPublishTime");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter(dateConverter);
        titleAndModelKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey);

        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("实际完成时间", "formFactTime");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter(dateConverter2);
        titleAndModelKey2.setToStrConverter(dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);


        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商分类", "purCompanyRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核等级", "purCompanyRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("分数", "rankingScore"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("排名升降", "ranking"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("名次", "rankingCount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("参评家数", "companyNumber"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod = "POST", value = "绩效结果导出Excel")
    @RequestMapping("service/downloadExcel")
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        List<KpiRanking> KpiRankingList = this.kpiRankingService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        List<KpiRankingExcelVo> kpiRankingVos = new ArrayList<>();
        try {
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
            if (CollectionUtils.isNotEmpty(KpiRankingList)) {

                int index = 0;
                for (KpiRanking kpiRanking : KpiRankingList) {
                    if ("1".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("升");
                    } else if ("2".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("降");
                    } else if ("3".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("平");
                    }

                    KpiRankingExcelVo kpiRankingExcelVo = new KpiRankingExcelVo();
                    BeanUtils.copyProperties(kpiRanking ,kpiRankingExcelVo );
                    //

                    String kpiScoreDesc = kpiRanking.getProjectTypeScore();
                    if(StringUtils.isNotEmpty(kpiScoreDesc)) {
                        kpiScoreDesc = kpiScoreDesc.replace("|", ",");
                        kpiScoreDesc = "[" + kpiScoreDesc + "]";
                        List<KpiRankingScoreVo> kpiRankingScoreVos = new ArrayList<>();
                        ObjectMapper objectMapper = new ObjectMapper();
                        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, KpiRankingScoreVo.class);
                        kpiRankingScoreVos = objectMapper.readValue(kpiScoreDesc, javaType);
                        for (int i = 0; i < kpiRankingScoreVos.size(); i++) {
                            KpiRankingScoreVo kpiRankingScoreVo = kpiRankingScoreVos.get(i);
                            if (i == 0) {
                                kpiRankingExcelVo.setOriginalScore1(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue1(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore1(kpiRankingScoreVo.getScore());
                            }
                            if (i == 1) {
                                kpiRankingExcelVo.setOriginalScore2(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue2(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore2(kpiRankingScoreVo.getScore());
                            }
                            if (i == 2) {
                                kpiRankingExcelVo.setOriginalScore3(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue3(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore3(kpiRankingScoreVo.getScore());
                            }
                            if (i == 3) {
                                kpiRankingExcelVo.setOriginalScore4(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue4(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore4(kpiRankingScoreVo.getScore());
                            }
                            if (i == 4) {
                                kpiRankingExcelVo.setOriginalScore5(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue5(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore5(kpiRankingScoreVo.getScore());
                            }
                            if (i == 5) {
                                kpiRankingExcelVo.setOriginalScore6(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue6(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore6(kpiRankingScoreVo.getScore());
                            }
                            if (i == 6) {
                                kpiRankingExcelVo.setOriginalScore7(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue7(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore7(kpiRankingScoreVo.getScore());
                            }
                            if (i == 7) {
                                kpiRankingExcelVo.setOriginalScore8(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue8(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore8(kpiRankingScoreVo.getScore());
                            }
                            if (index == 0) {
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "原始值", "originalScore" + (i+1)));
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "修正值", "correctionValue" + (i+1)));
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "分数", "score" +(i+1)));
                            }
                        }
                        index++;
                    }
                    kpiRankingVos.add(kpiRankingExcelVo);
                }
            }
            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format(KpiRankingList.get(0).getFormName() + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());



            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiRankingVos, "绩效结果", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    @ApiOperation(httpMethod = "POST", value = "供应商查询排名表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiRanking", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/supFindByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> supFindByPage(@RequestParam(defaultValue = "0") int pageNo,
                                                              @RequestParam(defaultValue = "10") int pageSize,
                                                              @RequestBody(required = false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setPageView(new PageView<KpiRanking>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        KpiRankingExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());// 固定为当前登录的供应商方
        criteria.andSupCompanySrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());// 固定为当前登录的供应商方

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView<KpiRanking> pageData = this.kpiRankingService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商方查询排名表明细")
    @ApiImplicitParams({@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiRanking", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/purFindByRanking")
    @ResponseBody
    public ResponseResult<Map<String, Object>> purFindByRanking(
            @RequestBody(required = false) QueryParamWapper wapper) throws JsonParseException,
            JsonMappingException, IOException {
        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        // criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());//固定为当前登录的供应商方
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        List<KpiRanking> kpiRanking = this.kpiRankingService.queryAllObjByExample(example);
        Map<String, Object> map = new HashMap<String, Object>();
        List<Object> list = new ArrayList<>();
        Map<String, Object> mapRanking = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(kpiRanking)) {
            for (KpiRanking r : kpiRanking) {
                map.put("formCode", r.getFormCode());
                map.put("formName", r.getFormName());
                map.put("formPublishTime", r.getFormPublishTime());
                map.put("formFactTime", r.getFormFactTime());
                map.put("supCompanySrmCode", r.getSupCompanySrmCode());
                map.put("supCompanyName", r.getSupCompanyName());
                map.put("purCompanyCategory", r.getPurCompanyCategory());
                map.put("purCompanyRank", r.getPurCompanyRank());// 供应商等级
                map.put("rankingCount", r.getRankingCount());
                map.put("companyNumber", r.getCompanyNumber());
                // 分割{"code":"deliver","name":"交付","score":"25"}|{"code":"price","name":"价格","score":"25"}
                String[] sourceStrArray = r.getProjectTypeScore().split("\\|");
                for (int j = 0; j < sourceStrArray.length; j++) {
                    String jsonMessage = sourceStrArray[j];// {"code":"deliver","name":"交付","score":"25"}
                    //KpiRankingVo kpi = JsonUtils.convertValue(jsonMessage, KpiRankingVo.class);
                    KpiRankingScoreVo kpi = JsonUtils.convertValue(jsonMessage, KpiRankingScoreVo.class);
                    map.put(kpi.getCode(), kpi.getScore());
                    map.put(kpi.getCode()+"originalScore", kpi.getOriginalScore());
                    map.put(kpi.getCode()+"correctionValue", kpi.getCorrectionValue());
                    // 添加标题
                    Map<String, Object> mapTitle = new HashMap<String, Object>();
                    mapTitle.put("projectCode", kpi.getCode()+"originalScore");
                    mapTitle.put("projectName", kpi.getName()+"原始值");
                    list.add(mapTitle);
                    mapTitle = new HashMap<String, Object>();
                    mapTitle.put("projectCode", kpi.getCode()+"correctionValue");
                    mapTitle.put("projectName", kpi.getName()+"修正值");
                    list.add(mapTitle);
                    mapTitle = new HashMap<String, Object>();
                    mapTitle.put("projectCode", kpi.getCode());
                    mapTitle.put("projectName", kpi.getName()+"分数");
                    list.add(mapTitle);
                }
                map.put("rankingScore", r.getRankingScore());
                map.put("ranking", r.getRanking());

                Company company = this.companyService.queryObjById(r.getSupCompanyId());// 供应商ID
                map.put("classificationThree", company.getClassificationThree());// 导入分类

                // 分类格式：2,3,4,5,6
                String secondCompanyType = company.getSecondCompanyType();
                if (StringUtils.isNotBlank(secondCompanyType)) {
                    String[] classType = secondCompanyType.split(",");
                    map.put("secondCompanyType", classType[0]);// 分类
                }
            }
        }

        mapRanking.put("kpiRankingList", map);
        mapRanking.put("titles", list);

        return ResponseResult.success(mapRanking);
    }



    @ApiOperation(httpMethod = "POST", value = "绩效结果导出Excel")
    @RequestMapping("service/sup/downloadExcel")
    @ResponseBody
    public ResponseResult<FileData> supplerDownloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        List<KpiRanking> KpiRankingList = this.kpiRankingService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        List<KpiRankingExcelVo> kpiRankingVos = new ArrayList<>();
        try {
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
            if (CollectionUtils.isNotEmpty(KpiRankingList)) {

                int index = 0;
                for (KpiRanking kpiRanking : KpiRankingList) {
                    if ("1".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("升");
                    } else if ("2".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("降");
                    } else if ("3".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("平");
                    }

                    KpiRankingExcelVo kpiRankingExcelVo = new KpiRankingExcelVo();
                    BeanUtils.copyProperties(kpiRanking ,kpiRankingExcelVo );
                    //

                    String kpiScoreDesc = kpiRanking.getProjectTypeScore();
                    if(StringUtils.isNotEmpty(kpiScoreDesc)) {
                        kpiScoreDesc = kpiScoreDesc.replace("|", ",");
                        kpiScoreDesc = "[" + kpiScoreDesc + "]";
                        List<KpiRankingScoreVo> kpiRankingScoreVos = new ArrayList<>();
                        ObjectMapper objectMapper = new ObjectMapper();
                        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, KpiRankingScoreVo.class);
                        kpiRankingScoreVos = objectMapper.readValue(kpiScoreDesc, javaType);
                        for (int i = 0; i < kpiRankingScoreVos.size(); i++) {
                            KpiRankingScoreVo kpiRankingScoreVo = kpiRankingScoreVos.get(i);
                            if (i == 0) {
                                kpiRankingExcelVo.setOriginalScore1(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue1(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore1(kpiRankingScoreVo.getScore());
                            }
                            if (i == 1) {
                                kpiRankingExcelVo.setOriginalScore2(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue2(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore2(kpiRankingScoreVo.getScore());
                            }
                            if (i == 2) {
                                kpiRankingExcelVo.setOriginalScore3(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue3(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore3(kpiRankingScoreVo.getScore());
                            }
                            if (i == 3) {
                                kpiRankingExcelVo.setOriginalScore4(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue4(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore4(kpiRankingScoreVo.getScore());
                            }
                            if (i == 4) {
                                kpiRankingExcelVo.setOriginalScore5(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue5(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore5(kpiRankingScoreVo.getScore());
                            }
                            if (i == 5) {
                                kpiRankingExcelVo.setOriginalScore6(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue6(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore6(kpiRankingScoreVo.getScore());
                            }
                            if (i == 6) {
                                kpiRankingExcelVo.setOriginalScore7(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue7(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore7(kpiRankingScoreVo.getScore());
                            }
                            if (i == 7) {
                                kpiRankingExcelVo.setOriginalScore8(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue8(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore8(kpiRankingScoreVo.getScore());
                            }
                            if (index == 0) {
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "原始值", "originalScore" + i));
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "修正值", "correctionValue" + i));
                                titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey(kpiRankingScoreVo.getName() + "分数", "score" + i));
                            }
                        }
                        index++;
                    }
                    kpiRankingVos.add(kpiRankingExcelVo);
                }
            }
            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format(KpiRankingList.get(0).getFormName() + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());



            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiRankingVos, "绩效结果", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    /**
     * 设置分数到kpiRanking对象中
     *
     * @param list 对象集合
     */
    private void addScore2KpiRanking(List<KpiRanking> list) {
        try {
            for (KpiRanking kpiRanking : list) {
                for (String json : kpiRanking.getProjectTypeScore().split("\\|")) {
                    KpiRankingVo vo = JsonUtils.convertValue(json, KpiRankingVo.class);
                    switchScore(kpiRanking, vo);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void switchScore(KpiRanking kpiRanking, KpiRankingVo vo) {
        switch (vo.getCode()) {
            case "delivery":
                //kpiRanking.setDeliverScore(vo.getScore());
                break;
            case "price":
                //kpiRanking.setPriceScore(vo.getScore());
                break;
            case "service":
                //kpiRanking.setServiceScore(vo.getScore());
                break;
            case "quality":
                // kpiRanking.setQualityScore(vo.getScore());
                break;
            case "qualityCount":
                //kpiRanking.setQualityCountScore(vo.getScore());
                break;
        }
    }
}