package com.els.base.performance.web.controller;

import com.els.base.performance.utils.CalculateItem;
import com.els.base.performance.utils.DataGather;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.service.KpiScoreService;

import java.util.ArrayList;
import java.util.List;

@Api(value = "绩效管理-评分表")
@Controller
@RequestMapping("kpiScore")
public class KpiScoreController {
    @Resource
    protected KpiScoreService kpiScoreService;

    @ApiOperation(httpMethod = "POST", value = "创建评分表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiScore kpiScore) {
        this.kpiScoreService.addObj(kpiScore);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑评分表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiScore kpiScore) {
        if (StringUtils.isBlank(kpiScore.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.kpiScoreService.modifyObj(kpiScore);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除评分表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.kpiScoreService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询评分表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiScore", paramType = "body", dataType = "QueryParamWapper")})
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiScore>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
                                                         @RequestParam(defaultValue = "10") int pageSize,
                                                         @RequestBody(required = false) QueryParamWapper wapper) {
        KpiScoreExample example = new KpiScoreExample();
        example.setPageView(new PageView<KpiScore>(pageNo, pageSize));

        KpiScoreExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<KpiScore> pageData = this.kpiScoreService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "测试系统自动计算")
    @RequestMapping("service/testSystemAuto")
    @ResponseBody
    public ResponseResult<List<CalculateItem>> testSystemAuto(@RequestParam(required = true) String id) {

        List<CalculateItem> list = new ArrayList<>();
        //Class<?> userClass = Class.forName("com.els.base.performance.automatic.DeliveryRate");
        //DataGather entity = (DataGather) userClass.newInstance();
        //List<CalculateItem> list=entity.GatherFactor();
        try {
            Class<?> clazz = Class.forName("com.els.base.performance.automatic.DeliveryRate");
            DataGather obj = (DataGather) clazz.newInstance();
            list = obj.GatherFactor();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ResponseResult.success(list);
    }


}