package com.els.base.performance.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.*;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "供应商服务原始数据")
@Controller
@RequestMapping("kpiService")
public class KpiServiceController {
    @Resource
    protected KpiServiceService kpiServiceService;

    @ApiOperation(httpMethod = "POST", value = "创建供应商服务原始数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiService kpiService) {
        this.kpiServiceService.addObj(kpiService);
        return ResponseResult.success(kpiService.getId());
    }

    @ApiOperation(httpMethod = "POST", value = "编辑供应商服务原始数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiService kpiService) {
        Assert.isNotBlank(kpiService.getId(), "id 为空，保存失败");
        this.kpiServiceService.modifyObj(kpiService);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商服务原始数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andIdIn(ids);
        this.kpiServiceService.deleteByExample(example);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "增加供应商")
    @RequestMapping("service/addSuuplerByIds")
    @ResponseBody
    public ResponseResult<String> addSuuplerByIds(@RequestBody(required = true) List<String> ids,
                                                  @RequestParam(required = true) String FormId) {
        Assert.isNotEmpty(ids, "新增失败,id不能为空");
        //KpiServiceExample example = new KpiServiceExample();
        //example.createCriteria().andIdIn(ids);
        //this.kpiServiceService.deleteByExample(example);
        this.kpiServiceService.AddSupplerByIds(ids,FormId);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "保存分数")
    @RequestMapping("service/saveScore")
    @ResponseBody
    public ResponseResult<String> saveScore(@RequestBody(required = true) KpiServiceForm kpiServiceForm) {
        List<KpiService>kpiServiceList=kpiServiceForm.getKpiServiceList();
        Assert.isNotEmpty(kpiServiceList, "保存失败,参数为空");
        this.kpiServiceService.saveScore(kpiServiceList);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "增加供应商")
    @RequestMapping("service/submitScore")
    @ResponseBody
    public ResponseResult<String> submitScore(@RequestBody(required = true)KpiServiceForm kpiServiceForm) {
        List<KpiService>kpiServiceList=kpiServiceForm.getKpiServiceList();
        Assert.isNotEmpty(kpiServiceList, "提交失败,参数为空");
        this.kpiServiceService.submitScore(kpiServiceList);
        return ResponseResult.success();
    }



    @ApiOperation(httpMethod = "POST", value = "查询供应商服务原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiService", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiService>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        example.setPageView(new PageView<KpiService>(pageNo, pageSize));

        KpiServiceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiService> pageData = this.kpiServiceService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "导出服务原始数据")
    @RequestMapping("service/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiServiceExample example = new KpiServiceExample();
        KpiServiceExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiService> kpiQualifiedRates = this.kpiServiceService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("服务" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiQualifiedRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    private List<TitleAndModelKey> createTitleAndModelKeyArray() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("分类", "category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("业务员", "salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开发经理", "developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不及时次数", "laterCount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("服务分数", "score"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("年度", "year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("月份", "month"));

        return titleAndModelKeys;
    }


    @ApiOperation(httpMethod = "POST", value = "查询供应商服务原始数据(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiService", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiService>> supplerFindByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        example.setPageView(new PageView<KpiService>(pageNo, pageSize));

        KpiServiceExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiService> pageData = this.kpiServiceService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "导出服务原始数据(供应商)")
    @RequestMapping("service/sup/dowloadExcel")
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiServiceExample example = new KpiServiceExample();
        KpiServiceExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiService> kpiQualifiedRates = this.kpiServiceService.queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("服务" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiQualifiedRates, "绩效导入模板", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }


    @ApiOperation(httpMethod = "POST", value = "服务打分原始数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiOriginalExport", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findReportByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiOriginalExport>> findReportByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        example.setPageView(new PageView<KpiOriginalExport>(pageNo, pageSize));
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiOriginalExport> pageData = this.kpiServiceService.queryReportObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "导出服务打分原始数据")
    @RequestMapping("service/dowloadReportExcel")
    @ResponseBody
    public ResponseResult<FileData> dowloadReportExcel(@RequestBody(required = false) QueryParamWapper wapper) {

        KpiOriginalExportExample example = new KpiOriginalExportExample();
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KpiOriginalExport> kpiOriginalExports = this.kpiServiceService.queryReportAllObjByExample(example);
        FileData fileData = new FileData();
        try {

            String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("绩效服务年度报表" + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
            fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());

            List<TitleAndModelKey> titleAndModelKeys = this.createReportTitleAndModelKeyArray();

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(fos, titleAndModelKeys, kpiOriginalExports, "绩效服务年度报表", null, 0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();

        } catch (IOException exx) {
            exx.printStackTrace();
        } catch (Exception ee) {
            ee.printStackTrace();
        }


        return ResponseResult.success(fileData);
    }

    private List<TitleAndModelKey> createReportTitleAndModelKeyArray() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("分类", "category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("业务员", "salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开发经理", "developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("年份", "year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("一月", "January1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("二月", "February1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("三月", "March1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("四月", "April1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("五月", "May1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("六月", "June1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("七月", "July1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("八月", "August1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("九月", "September1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十月", "October1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十一月", "November1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("十二月", "December1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("平均", "AvgValue1"));
        return titleAndModelKeys;
    }
}