package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.entity.KpiServiceFormExample;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiServiceFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商服务月度表单")
@Controller
@RequestMapping("kpiServiceForm")
public class KpiServiceFormController {
    @Resource
    protected KpiServiceFormService kpiServiceFormService;

    @ApiOperation(httpMethod="POST", value="创建供应商服务月度表单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiServiceForm kpiServiceForm) {
        kpiServiceForm.setCreateTime(new Date());
        kpiServiceForm.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        kpiServiceForm.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        kpiServiceForm.setUpdateTime(new Date());
        kpiServiceForm.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        kpiServiceForm.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.kpiServiceFormService.addObj(kpiServiceForm);
        return ResponseResult.success(kpiServiceForm.getId());
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商服务月度表单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiServiceForm kpiServiceForm) {
        Assert.isNotBlank(kpiServiceForm.getId(), "id 为空，保存失败");
        //this.kpiServiceFormService.modifyObj(kpiServiceForm);
        this.kpiServiceFormService.saveKpiServiceForm(kpiServiceForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查看供应商服务月度表单")
    @RequestMapping("service/view")
    @ResponseBody
    public ResponseResult<KpiServiceForm> view(@RequestParam(required=true)String  id) {
        Assert.isNotBlank(id, "查看失败,id不能为空");
        return ResponseResult.success(this.kpiServiceFormService.viewById(id));
    }

    @ApiOperation(httpMethod="POST", value="删除供应商服务月度表单")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        //KpiServiceFormExample example = new KpiServiceFormExample();
        //example.createCriteria().andIdIn(ids);
        //this.kpiServiceFormService.deleteByExample(example);
        this.kpiServiceFormService.deleteByIdArray(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="发布供应商服务月度表单")
    @RequestMapping("service/publishByIds")
    @ResponseBody
    public ResponseResult<String> publishByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        //KpiServiceFormExample example = new KpiServiceFormExample();
        //example.createCriteria().andIdIn(ids);
        //this.kpiServiceFormService.deleteByExample(example);
        this.kpiServiceFormService.publishByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="作废供应商服务月度表单")
    @RequestMapping("service/invalidByIds")
    @ResponseBody
    public ResponseResult<String> invalidByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        //KpiServiceFormExample example = new KpiServiceFormExample();
        //example.createCriteria().andIdIn(ids);
        //this.kpiServiceFormService.deleteByExample(example);
        this.kpiServiceFormService.invalidByIds(ids);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="查询供应商服务月度表单")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 KpiServiceForm", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiServiceForm>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceFormExample example = new KpiServiceFormExample();
        example.setPageView(new PageView<KpiServiceForm>(pageNo, pageSize));
        
        KpiServiceFormExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<KpiServiceForm> pageData = this.kpiServiceFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="查询供应商服务月度表单")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 KpiServiceForm", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findPublishByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiServiceForm>> findPublishByPage(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceFormExample example = new KpiServiceFormExample();
        example.setPageView(new PageView<KpiServiceForm>(pageNo, pageSize));

        KpiServiceFormExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        criteria.andFormStatusNotEqualTo(KpiServiceFormStatus.NEW.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiServiceForm> pageData = this.kpiServiceFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="供应商服务月度表单")
    @RequestMapping("service/viewScore")
    @ResponseBody
    public ResponseResult<KpiServiceForm> viewScore(@RequestParam(required=true)String  id) {
        Assert.isNotBlank(id, "查看失败,id不能为空");
        return ResponseResult.success(this.kpiServiceFormService.viewById(id));
    }




}