package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiSupAudit;
import com.els.base.performance.entity.KpiSupAuditExample;
import com.els.base.performance.service.KpiSupAuditService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;

@Api(value = "供应商过程年度审核管理表")
@Controller
@RequestMapping("kpiSupAudit")
public class KpiSupAuditController {
    @Resource
    protected KpiSupAuditService kpiSupAuditService;

    @ApiOperation(httpMethod = "POST", value = "创建供应商过程年度审核管理表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupAudit kpiSupAudit) {
        kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
        kpiSupAudit.setCompany(CompanyUtils.currentCompany());
        this.kpiSupAuditService.addObj(kpiSupAudit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑供应商过程年度审核管理表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupAudit kpiSupAudit) {
        Assert.isNotBlank(kpiSupAudit.getId(), "id 为空，保存失败");
        kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
        this.kpiSupAuditService.modifyObj(kpiSupAudit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商过程年度审核管理表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.kpiSupAuditService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询供应商过程年度审核管理表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiSupAudit", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiSupAudit>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiSupAuditExample example = new KpiSupAuditExample();
        example.setPageView(new PageView<KpiSupAudit>(pageNo, pageSize));

        // KpiSupAuditExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiSupAudit> pageData = this.kpiSupAuditService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "提交过程年度审核管理表")
    @RequestMapping("service/submit")
    @ResponseBody
    public ResponseResult<String> submit(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "提交失败,id不能为空");
        this.kpiSupAuditService.submit(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询供应商过程年度审核管理表(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiSupAudit", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPageForSup")
    @ResponseBody
    public ResponseResult<PageView<KpiSupAudit>> findByPageForSup(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiSupAuditExample example = new KpiSupAuditExample();
        example.setPageView(new PageView<KpiSupAudit>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andStatusEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiSupAudit> pageData = this.kpiSupAuditService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商过程年度审核管理表导出excel")
    @RequestMapping("service/downloadExcel")
    @ResponseBody
    public ModelAndView downloadExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("供应商过程年度审核管理表" + ".xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    null, "供应商过程年度审核管理表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value = "供应商过程年度审核管理表excel导入", httpMethod = "POST")
    @RequestMapping(value = "service/uploadExcel")
    @ResponseBody
    public ResponseResult<String> uploadExcel(MultipartHttpServletRequest request) {
        List<KpiSupAudit> importExcelDataToMap = new ArrayList<KpiSupAudit>();
        try {
            Map<String, MultipartFile> fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys();
            importExcelDataToMap = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0,
                    titleAndModelKeys, KpiSupAudit.class);
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }
        for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); i++) {
            KpiSupAudit kpiSupAudit = importExcelDataToMap.get(i);
            kpiSupAudit.setCompany(CompanyUtils.currentCompany());
            kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiSupAuditService.addObject(kpiSupAudit);
        }

        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("审核类型", "auditType"));

        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("实际审核日期", "auditDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter(dateConverter);
        titleAndModelKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SRM编码", "supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质量保证协议", "qsv"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质量目标协议", "qtp"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("SQE责任人", "seqPerson"));

        TitleAndModelKey titleAndModelKey1 = ExcelUtils.createTitleAndModelKey("计划审核时间", "planReviewTime");
        titleAndModelKey1.setToObjConverter(dateConverter);
        titleAndModelKey1.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey1);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("审核人员", "auditor"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("符合程度", "degreeOfFit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("审核等级", "auditGrade"));

        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("应提交改善措施时间", "shouldSubTime");
        titleAndModelKey2.setToObjConverter(dateConverter);
        titleAndModelKey2.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey2);

        TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("提交改善措施时间", "subTime");
        titleAndModelKey3.setToObjConverter(dateConverter);
        titleAndModelKey3.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey3);

        TitleAndModelKey titleAndModelKey4 = ExcelUtils
                .createTitleAndModelKey("问题关闭效果确认", "problemCloseTime");
        titleAndModelKey4.setToObjConverter(dateConverter);
        titleAndModelKey4.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey4);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
        return titleAndModelKeys;
    }
}