package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.UnsupportedEncodingException;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiSupWeightRank;
import com.els.base.performance.entity.KpiSupWeightRankExample;
import com.els.base.performance.entity.vo.KpiSupWeightRankVO;
import com.els.base.performance.service.KpiSupWeightRankService;

@Api(value = "供应商权重等级关系表")
@Controller
@RequestMapping("kpiSupWeightRank")
public class KpiSupWeightRankController {
    @Resource
    protected KpiSupWeightRankService kpiSupWeightRankService;

    @ApiOperation(httpMethod = "POST", value = "创建供应商权重等级关系表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupWeightRank kpiSupWeightRank) {
        this.kpiSupWeightRankService.addObj(kpiSupWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="创建供应商权重等级关系表及权重多等级信息保存")
    @RequestMapping("service/createKpiSupWeightRank")
    @ResponseBody
    public ResponseResult<String> createKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
             throw new CommonException("产品大类称为空，保存失败", "base_canot_be_null", "产品大类");
         }

         if (kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass() != null
                 && getWordCountCode(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass(), "UTF-8") > 100) {
             throw new CommonException("输入的参数长度超标", "database_length_error");
         }
         
         // 获取当前登录人公司信息
         Company company = CompanyUtils.currentCompany();
         // 获取当前登录人用户信息
         User user = SpringSecurityUtils.getLoginUser();

         kpiSupWeightRankVO.setCompany(company);
         kpiSupWeightRankVO.setUser(user);
         
        this.kpiSupWeightRankService.addSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }
    
    
    @ApiOperation(httpMethod="POST", value="编辑供应商权重等级关系表及权重多等级信息保存")
    @RequestMapping("service/editKpiSupWeightRank")
    @ResponseBody
    public ResponseResult<String> editKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
    	
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getId())) {
             throw new CommonException("ID为空，保存失败", "base_canot_be_null", "主键ID");
         }
    	 
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
             throw new CommonException("产品大类称为空，保存失败", "base_canot_be_null", "产品大类");
         }

         if (kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass() != null
                 && getWordCountCode(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass(), "UTF-8") > 100) {
             throw new CommonException("输入的参数长度超标", "database_length_error");
         }
         
         // 获取当前登录人公司信息
         Company company = CompanyUtils.currentCompany();
         // 获取当前登录人用户信息
         User user = SpringSecurityUtils.getLoginUser();

         kpiSupWeightRankVO.setCompany(company);
         kpiSupWeightRankVO.setUser(user);
         
        this.kpiSupWeightRankService.editSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="删除供应商权重等级关系表及权重多等级信息保存")
    @RequestMapping("service/deleteKpiSupWeightRank")
    @ResponseBody
    public ResponseResult<String> deleteKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
    	
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getId())) {
             throw new CommonException("ID为空，保存失败", "base_canot_be_null", "主键ID");
         }
    	 
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
             throw new CommonException("产品大类称为空，保存失败", "base_canot_be_null", "产品大类");
         }
         
        this.kpiSupWeightRankService.deleteSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="判断供应商权重等级关系的产品大类是否存在")
    @RequestMapping("service/selectByIdExistsProductClass")
    @ResponseBody
    public ResponseResult<String> selectByIdExistsProductClass(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
    	
    	 if (StringUtils.isBlank(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
             throw new CommonException("产品大类称为空，保存失败", "base_canot_be_null", "产品大类");
         }
    	 KpiSupWeightRankExample example = new KpiSupWeightRankExample();
    	 KpiSupWeightRankExample.Criteria criteria = example.createCriteria();
         criteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());

         List<KpiSupWeightRank> kpiSupWeightRankList = this.kpiSupWeightRankService.queryAllObjByExample(example);

         if (kpiSupWeightRankList.size() > 0) {
        	 //base_is_exists   {0}已存在，不可重复
             throw new CommonException("产品大类已存在，不可重复", "base_is_exists", "操作失败！产品大类【" + kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass()+ "】");
         }
        
        return ResponseResult.success();
    }
    
    /* 按特定的编码格式获取长度 */
    public static int getWordCountCode(String str, String code) throws UnsupportedEncodingException {
        return str.getBytes(code).length;
    }
    
    @ApiOperation(httpMethod = "POST", value = "编辑供应商权重等级关系表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupWeightRank kpiSupWeightRank) {
        Assert.isNotBlank(kpiSupWeightRank.getId(), "id 为空，保存失败");
        this.kpiSupWeightRankService.modifyObj(kpiSupWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商权重等级关系表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.kpiSupWeightRankService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询供应商权重等级关系表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiSupWeightRank", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiSupWeightRank>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiSupWeightRankExample example = new KpiSupWeightRankExample();
        example.setPageView(new PageView<KpiSupWeightRank>(pageNo, pageSize));

        // KpiSupWeightRankExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiSupWeightRank> pageData = this.kpiSupWeightRankService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}