package com.els.base.performance.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.performance.entity.KpiSupplierImprove;
import com.els.base.performance.entity.KpiSupplierImproveExample;
import com.els.base.performance.enums.ImproveStatusEnum;
import com.els.base.performance.service.KpiSupplierImproveService;
import com.els.base.performance.utils.KpiSupplerImprovePdfPrintUntil;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "供应商待改善")
@Controller
@RequestMapping("kpiSupplierImprove")
public class KpiSupplierImproveController {
    @Resource
    protected KpiSupplierImproveService kpiSupplierImproveService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;


    @ApiOperation(httpMethod = "POST", value = "创建供应商待改善")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        if (StringUtils.isEmpty(kpiSupplierImprove.getImproveContent())) {
            throw new CommonException("待改善内容不能为空!");
        }
        if (StringUtils.isEmpty(kpiSupplierImprove.getImproveType())) {
            throw new CommonException("待改善类型不能为空!");
        }
        if (StringUtils.isEmpty(kpiSupplierImprove.getSupCompanySapCode())) {
            throw new CommonException("供应商编码不能为空!");
        }
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("IMPROVE_NO");
        kpiSupplierImprove.setImproveNo(billNo);
        User user = SpringSecurityUtils.getLoginUser();
        kpiSupplierImprove.setCreateUserId(user.getId());
        kpiSupplierImprove.setCreateUserName(user.getNickName());
        kpiSupplierImprove.setCreateTime(new Date());
        kpiSupplierImprove.setUpdateUserId(user.getId());
        kpiSupplierImprove.setUpdateUserName(user.getNickName());
        kpiSupplierImprove.setUpdateTime(new Date());
        kpiSupplierImprove.setStatus(ImproveStatusEnum.NEW.getValue());
        kpiSupplierImprove.setSendStatus(Constant.NO_INT);


        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司

        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        kpiSupplierImprove.setProjectId(projectId);
        kpiSupplierImprove.setCompanyId(companyId);
        kpiSupplierImprove.setSummaryUserid(SpringSecurityUtils.getLoginUserId());
        kpiSupplierImprove.setSupCompanyName(SpringSecurityUtils.getLoginUserName());
        kpiSupplierImprove.setSummaryDate(new Date());
        //供应商代码处理
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(kpiSupplierImprove.getSupCompanySapCode());
        List<Company> supCompanyList = companyService.queryAllObjByExample(supompanyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            if (companyList.size() <= 0) {
                throw new CommonException("供应商代码为" + kpiSupplierImprove.getSupCompanySapCode() + "供应商不存在!");
            }
            supCompany = supCompanyList.get(0);
        }
        kpiSupplierImprove.setSupCompanyCode(supCompany.getCompanyCode());
        kpiSupplierImprove.setSupCompanyName(supCompany.getCompanyName());
        kpiSupplierImprove.setSupCompanySapCode(supCompany.getCompanySapCode());
        //
        this.kpiSupplierImproveService.addObj(kpiSupplierImprove);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑供应商待改善")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        Assert.isNotBlank(kpiSupplierImprove.getId(), "id 为空，保存失败");
        this.kpiSupplierImproveService.modifyObj(kpiSupplierImprove);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商待改善")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        KpiSupplierImprove entity = kpiSupplierImproveService.queryObjById(id);
        if (entity != null) {
            if (!ImproveStatusEnum.NEW.getValue().equals(entity.getStatus())) {
                throw new CommonException("只有新增单据才可以删除!");
            }
        }
        this.kpiSupplierImproveService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量删除供应商待改善")
    @RequestMapping("service/deleteByIdArray")
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要删除的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            KpiSupplierImprove entity = kpiSupplierImproveService.queryObjById(id);
            if (entity != null) {
                if (!ImproveStatusEnum.NEW.getValue().equals(entity.getStatus())) {
                    throw new CommonException("只有新增单据才可以删除!");
                }
            }
            this.kpiSupplierImproveService.deleteObjById(id);
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询供应商待改善")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiSupplierImprove", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiSupplierImprove>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiSupplierImproveExample example = new KpiSupplierImproveExample();
        example.setPageView(new PageView<>(pageNo, pageSize));

        KpiSupplierImproveExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        List<Company> companies = companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        List<String> companyCodeList = new ArrayList<String>(){{
            companies.forEach(company -> add(company.getCompanyCode()));
        }};
        if (CollectionUtils.isNotEmpty(companyCodeList)) {
            criteria.andSupCompanyCodeIn(companyCodeList);
        }
        example.setOrderByClause("CREATE_TIME DESC,UPDATE_TIME DESC");
        PageView<KpiSupplierImprove> pageData = this.kpiSupplierImproveService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "发送待改善信息到供应商")
    @RequestMapping("service/send")
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要作废的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(id);
            if (Constant.YES_INT.equals(entity.getSendStatus())) {
                throw new CommonException("单据号" + entity.getImproveNo() + ",已经发送给供应商，无需重新新发布!");
            }
            entity.setSendStatus(Constant.YES_INT);
            entity.setStatus(ImproveStatusEnum.PUBLIC.getValue());
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.kpiSupplierImproveService.modifyObj(entity);
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "确认回复")
    @RequestMapping("service/acceptSupplierReply")
    @ResponseBody
    public ResponseResult<String> acceptSupplierReply(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        if (kpiSupplierImprove == null) {
            throw new CommonException("请选择要确认回复的数据!");
        }
        if (StringUtils.isEmpty(kpiSupplierImprove.getConfirmationOpinions())) {
            throw new CommonException("确认验证内容不能为空!");
        }
        User user = SpringSecurityUtils.getLoginUser();

        //

        KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(kpiSupplierImprove.getId());
        if (!ImproveStatusEnum.REPLY.getValue().equals(entity.getStatus())) {
            throw new CommonException("单据号" + entity.getImproveNo() + ",只能确认供方回复的单据!");
        }
        entity.setConfirmationOpinions(kpiSupplierImprove.getConfirmationOpinions());
        entity.setStatus(ImproveStatusEnum.CONFIRM.getValue());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(new Date());
        this.kpiSupplierImproveService.modifyObj(entity);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "驳回回复")
    @RequestMapping("service/refusedSupplierReply")
    @ResponseBody
    public ResponseResult<String> refusedSupplierReply(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要驳回的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            //
            KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(id);
            if (!ImproveStatusEnum.REPLY.getValue().equals(entity.getStatus())) {
                throw new CommonException("单据号" + entity.getImproveNo() + ",只能驳回供方回复的单据!");
            }
            entity.setStatus(ImproveStatusEnum.REFUSED.getValue());
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.kpiSupplierImproveService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "上传附件")
    @RequestMapping("service/attachment")
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody KpiSupplierImprove improve) {
        User user = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isBlank(improve.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(improve.getId());
        entity.setAttachment(improve.getAttachment());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(new Date());
        this.kpiSupplierImproveService.modifyObj(entity);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询供应商待改善(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiSupplierImprove", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/supplerFindByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiSupplierImprove>> supplerFindByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiSupplierImproveExample example = new KpiSupplierImproveExample();
        example.setPageView(new PageView<KpiSupplierImprove>(pageNo, pageSize));

        KpiSupplierImproveExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,UPDATE_TIME DESC");
        PageView<KpiSupplierImprove> pageData = this.kpiSupplierImproveService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "回复")
    @RequestMapping("service/supplierReply")
    @ResponseBody
    public ResponseResult<String> supplierReply(@RequestBody List<KpiSupplierImprove> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要回复的数据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (KpiSupplierImprove item : list) {
            //
            //

            if (!ImproveStatusEnum.PUBLIC.getValue().equals(item.getStatus()) && !ImproveStatusEnum.REFUSED.getValue().equals(item.getStatus())) {
                throw new CommonException("单据号" + item.getImproveNo() + ",只有发布、驳回状态的才可以回复!");
            }
            KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(item.getId());

            entity.setSupplierReply(item.getSupplierReply());
            entity.setCauseAnalysis(item.getCauseAnalysis());
            entity.setCorrectiveAction(item.getCorrectiveAction());
            entity.setPrevent(item.getPrevent());
            entity.setMeasuresFixedLine(item.getMeasuresFixedLine());
            entity.setPreventOutflow(item.getPreventOutflow());
            entity.setProductionReason(item.getProductionReason());
            entity.setOutOfReason(item.getOutOfReason());
            entity.setProcessFlow(item.getProcessFlow());
            entity.setMeasuresFixedLine(item.getMeasuresFixedLine());
            entity.setImplementationPlan(item.getInspectionOfImplementation());
            entity.setStatus(ImproveStatusEnum.REPLY.getValue());
            entity.setInspectionOfImplementation(item.getInspectionOfImplementation());
//            if(StringUtils.isNotEmpty(item.getAttachment()))
//            {
//                entity.setAttachment(item.getAttachment());
//            }
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.kpiSupplierImproveService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    /**
     * 待改善PDF导出
     */
    @ApiOperation(httpMethod = "POST", value = "待改善PDF导出")
    @RequestMapping("service/exportPDF")
    @ResponseBody
    public ResponseResult<FileData> exportPDF(@ApiParam("待改善id") @RequestBody List<String> IdArray) {
        // 检验参数
        if (IdArray.isEmpty()) {
            throw new CommonException("导出失败，未选择导出数据！");
        }
        KpiSupplierImprove entity = this.kpiSupplierImproveService.queryObjById(IdArray.get(0));
        if (entity == null) {
            throw new CommonException("未查询到数据！");
        }
        FileData fileData = KpiSupplerImprovePdfPrintUntil.getPdfFile(entity);
        // 判断是否查询出文件信息集合
        return ResponseResult.success(fileData);
    }

}