package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.service.KpiTemplateItemService;

@Api(value = "绩效管理-评估模板明细")
@Controller
@RequestMapping("kpiTemplateItem")
public class KpiTemplateItemController {
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;

    @ApiOperation(httpMethod = "POST", value = "创建评估模板明细")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiTemplateItem kpiTemplateItem) {
        this.kpiTemplateItemService.addObj(kpiTemplateItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑评估模板明细")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiTemplateItem kpiTemplateItem) {
        if (StringUtils.isBlank(kpiTemplateItem.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.kpiTemplateItemService.modifyObj(kpiTemplateItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除评估模板明细")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.kpiTemplateItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询评估模板明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiTemplateItem", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiTemplateItem>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiTemplateItemExample example = new KpiTemplateItemExample();
        example.setPageView(new PageView<KpiTemplateItem>(pageNo, pageSize));

        KpiTemplateItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<KpiTemplateItem> pageData = this.kpiTemplateItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}