package com.els.base.performance.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiWeightRank;
import com.els.base.performance.entity.KpiWeightRankExample;
import com.els.base.performance.service.KpiWeightRankService;

@Api(value = "权重等级信息表")
@Controller
@RequestMapping("kpiWeightRank")
public class KpiWeightRankController {
    @Resource
    protected KpiWeightRankService kpiWeightRankService;

    @ApiOperation(httpMethod = "POST", value = "创建权重等级信息表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiWeightRank kpiWeightRank) {
        this.kpiWeightRankService.addObj(kpiWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑权重等级信息表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiWeightRank kpiWeightRank) {
        Assert.isNotBlank(kpiWeightRank.getId(), "id 为空，保存失败");
        this.kpiWeightRankService.modifyObj(kpiWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除权重等级信息表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.kpiWeightRankService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询权重等级信息表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KpiWeightRank", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KpiWeightRank>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KpiWeightRankExample example = new KpiWeightRankExample();
        example.setPageView(new PageView<KpiWeightRank>(pageNo, pageSize));

        // KpiWeightRankExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KpiWeightRank> pageData = this.kpiWeightRankService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}