CREATE TABLE "T_BASE_KPI_ADVERSE_EVENT" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"ADVERSE_EVENT_NO" NVARCHAR2(255) NULL ,
"START_TIME" DATE NULL ,
"END_TIME" DATE NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(255) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(255) NULL ,
"SUPPLIER_SAP_NAME" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_NAME" NVARCHAR2(255) NULL ,
"BRIEF_RESUME" NVARCHAR2(255) NULL ,
"SUPPLIER_NICK_NAME" NVARCHAR2(255) NULL ,
"MATTER" NVARCHAR2(255) NULL ,
"TYPE" NVARCHAR2(255) NULL ,
"POINTS" NVARCHAR2(255) NULL ,
PRIMARY KEY ("ID")
)
NOCOMPRESS
;

COMMENT ON TABLE "T_BASE_KPI_ADVERSE_EVENT" IS '不良事件';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."ID" IS 'id';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PROJECT_ID" IS '项目id';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_COMPANY_ID" IS '企业id';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_COMPANY_NAME" IS '企业名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_USER_ID" IS '采购员id';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."PUR_USER_NAME" IS '采购员名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_COMPANY_ID" IS '供应商companyid';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_COMPANY_NAME" IS '供应商公司名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_USER_ID" IS '供应商用户id';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUP_USER_NAME" IS '供应商用户名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."LAST_UPDATE_TIME" IS '最后更新时间';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."LAST_UPDATE_USER" IS '最后修改人';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."REMARK" IS '备注';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."ADVERSE_EVENT_NO" IS '单号';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."START_TIME" IS '开始时间';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."END_TIME" IS '结束时间';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUPPLIER_SRM_CODE" IS '供应商srm代码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUPPLIER_SAP_NAME" IS '供应商sap名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUPPLIER_SRM_NAME" IS '供应商srm名称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."BRIEF_RESUME" IS '事项简述';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."SUPPLIER_NICK_NAME" IS '供应商简称';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."MATTER" IS '事项';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."TYPE" IS '类别(影响/服务)';

COMMENT ON COLUMN "T_BASE_KPI_ADVERSE_EVENT"."POINTS" IS '扣分';

