/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.performance.dao.KpiAdverseEventMapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiAdverseEventService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiAdverseEventService")
public class KpiAdverseEventServiceImpl
implements KpiAdverseEventService {
    @Resource
    protected KpiAdverseEventMapper kpiAdverseEventMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected DicGroupItemService dicGroupItemService;

    @CacheEvict(value={"kpiAdverseEvent"}, allEntries=true)
    public void addObj(KpiAdverseEvent t) {
        String code = this.generateCodeService.getNextCode("KPI_ADVERSE_EVENT_CODE");
        t.setAdverseEventNo(code);
        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        User user = this.companyUserRefService.queryMainUserOfCompany(t.getSupCompanyId());
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        this.kpiAdverseEventMapper.insertSelective(t);
    }

    @Override
    public void addObject(KpiAdverseEvent t) {
        if (StringUtils.isNotBlank((String)t.getPoints())) {
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            boolean matches = pattern.matcher(t.getPoints()).matches();
            if (matches) {
                t.setPoints(Double.valueOf(t.getPoints()) < 0.0 ? null : t.getPoints());
            } else {
                t.setPoints(null);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        try {
            t.setStartTime(sdf.parse(sdf.format(t.getStartTime())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (!this.isExistDicGroupItem("20180124102514-4669af894eb8445a9", t.getMatter())) {
            t.setMatter(null);
        } else {
            t.setMatter(this.getDicGroupItemCode("20180124102514-4669af894eb8445a9", t.getMatter()));
        }
        if (!this.isExistDicGroupItem("20180124102855-af11e44985874913a", t.getType())) {
            t.setType(null);
        } else {
            t.setType(this.getDicGroupItemCode("20180124102855-af11e44985874913a", t.getType()));
        }
        String code = this.generateCodeService.getNextCode("KPI_ADVERSE_EVENT_CODE");
        t.setAdverseEventNo(code);
        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(t.getSupCompanySrmCode());
        List companies = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isEmpty((Collection)companies)) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801:" + t.getSupCompanySrmCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4fee\u6539", "do_not_exists", new Object[]{"\u4f9b\u5e94\u5546SRM\u7f16\u7801:" + t.getSupCompanySrmCode()});
        }
        User user = this.companyUserRefService.queryMainUserOfCompany(((Company)companies.get(0)).getId());
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        t.setSupCompanyId(((Company)companies.get(0)).getId());
        t.setSupCompanySapCode(((Company)companies.get(0)).getCompanySapCode());
        t.setSupCompanyName(((Company)companies.get(0)).getCompanyFullName());
        t.setSupplierSrmName(((Company)companies.get(0)).getCompanyFullName());
        t.setSupplierNickName(((Company)companies.get(0)).getCompanyName());
        t.setSupRemark(((Company)companies.get(0)).getRemark());
        this.kpiAdverseEventMapper.insertSelective(t);
    }

    private String getDicGroupItemCode(String groupItemId, String matter) {
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(groupItemId).andNameEqualTo(matter);
        List dicGroupItemMatterList = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
        String code = null;
        if (CollectionUtils.isNotEmpty((Collection)dicGroupItemMatterList)) {
            code = ((DicGroupItem)dicGroupItemMatterList.get(0)).getCode();
        }
        return code;
    }

    private boolean isExistDicGroupItem(String groupItemId, String string) {
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(groupItemId);
        List dicGroupItemMatterList = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
        ArrayList<String> dicGroupItemMatters = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)dicGroupItemMatterList) && i < dicGroupItemMatterList.size(); ++i) {
            dicGroupItemMatters.add(((DicGroupItem)dicGroupItemMatterList.get(i)).getName());
        }
        return dicGroupItemMatters.contains(string);
    }

    @CacheEvict(value={"kpiAdverseEvent"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiAdverseEventMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiAdverseEvent"}, allEntries=true)
    public void modifyObj(KpiAdverseEvent t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(t.getUser().getUsername());
        this.kpiAdverseEventMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiAdverseEvent"}, keyGenerator="redisKeyGenerator")
    public KpiAdverseEvent queryObjById(String id) {
        return this.kpiAdverseEventMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiAdverseEvent"}, keyGenerator="redisKeyGenerator")
    public List<KpiAdverseEvent> queryAllObjByExample(KpiAdverseEventExample example) {
        return this.kpiAdverseEventMapper.selectByExample(example);
    }

    public PageView<KpiAdverseEvent> queryObjByPage(KpiAdverseEventExample example) {
        PageView<KpiAdverseEvent> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiAdverseEventMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void supSubmitAppeal(KpiAdverseEvent kpiAdverseEvent, String type) {
        KpiAdverseEvent adverseEvent = new KpiAdverseEvent();
        adverseEvent.setId(kpiAdverseEvent.getId());
        String code = null;
        String receiverId = null;
        switch (type) {
            case "0": {
                adverseEvent.setStatus(KpiAdverseEventStatus.IS_SEND.getValue());
                code = "ADVERSE_EVENT_SEND";
                receiverId = kpiAdverseEvent.getSupUserId();
                break;
            }
            case "1": {
                adverseEvent.setStatus(KpiAdverseEventStatus.APPEALING.getValue());
                code = "ADVERSE_EVENT_SUP_SUBMIT";
                receiverId = kpiAdverseEvent.getPurUserId();
                break;
            }
            case "2": {
                adverseEvent.setStatus(KpiAdverseEventStatus.REFUSE_APPEAL.getValue());
                code = "ADVERSE_EVENT_REFUSE";
                receiverId = kpiAdverseEvent.getSupUserId();
                break;
            }
            case "3": {
                adverseEvent.setStatus(KpiAdverseEventStatus.TO_VOID.getValue());
            }
        }
        this.kpiAdverseEventMapper.updateByPrimaryKeySelective(adverseEvent);
        if (StringUtils.isNotBlank((String)code)) {
            Message message = Message.init((Object)kpiAdverseEvent).setBusinessTypeCode(code).setCompanyCode(kpiAdverseEvent.getCompany().getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(kpiAdverseEvent.getUser().getId()).addReceiverId(receiverId);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Transactional
    @CacheEvict(value={"kpiAdverseEvent"}, allEntries=true)
    public void addAll(List<KpiAdverseEvent> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiAdverseEventMapper.insertSelective((KpiAdverseEvent)item);
        });
    }

    @CacheEvict(value={"kpiAdverseEvent"}, allEntries=true)
    public void deleteByExample(KpiAdverseEventExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiAdverseEventMapper.deleteByExample(arg0);
    }
}

