/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiConfigurationMapper;
import com.els.base.performance.entity.KpiConfiguration;
import com.els.base.performance.entity.KpiConfigurationExample;
import com.els.base.performance.service.KpiConfigurationService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiConfigurationService")
public class KpiConfigurationServiceImpl
implements KpiConfigurationService {
    @Resource
    protected KpiConfigurationMapper kpiConfigurationMapper;

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    public void addObj(KpiConfiguration t) {
        this.kpiConfigurationMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    public void addAll(List<KpiConfiguration> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiConfigurationMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiConfigurationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    public void deleteByExample(KpiConfigurationExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiConfigurationMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiConfiguration"}, allEntries=true)
    public void modifyObj(KpiConfiguration t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiConfigurationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiConfiguration"}, keyGenerator="redisKeyGenerator")
    public KpiConfiguration queryObjById(String id) {
        return this.kpiConfigurationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiConfiguration"}, keyGenerator="redisKeyGenerator")
    public List<KpiConfiguration> queryAllObjByExample(KpiConfigurationExample example) {
        return this.kpiConfigurationMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiConfiguration"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiConfiguration> queryObjByPage(KpiConfigurationExample example) {
        PageView<KpiConfiguration> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiConfigurationMapper.selectByExampleByPage(example));
        return pageView;
    }
}

