/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiDeliveryRateMapper;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiDeliveryRateService")
public class KpiDeliveryRateServiceImpl
implements KpiDeliveryRateService {
    @Resource
    protected KpiDeliveryRateMapper kpiDeliveryRateMapper;

    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void addObj(KpiDeliveryRate t) {
        this.kpiDeliveryRateMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void addAll(List<KpiDeliveryRate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiDeliveryRateMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiDeliveryRateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void deleteByExample(KpiDeliveryRateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiDeliveryRateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void modifyObj(KpiDeliveryRate t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiDeliveryRateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiDeliveryRate"}, keyGenerator="redisKeyGenerator")
    public KpiDeliveryRate queryObjById(String id) {
        return this.kpiDeliveryRateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiDeliveryRate"}, keyGenerator="redisKeyGenerator")
    public List<KpiDeliveryRate> queryAllObjByExample(KpiDeliveryRateExample example) {
        return this.kpiDeliveryRateMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiDeliveryRate"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiDeliveryRate> queryObjByPage(KpiDeliveryRateExample example) {
        PageView<KpiDeliveryRate> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiDeliveryRateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiDeliveryRate"}, allEntries=true)
    public void ImportFromExcel(List<KpiDeliveryRate> list) {
        ArrayList<KpiDeliveryRate> kpiDeliveryRatesAdd = new ArrayList<KpiDeliveryRate>();
        for (KpiDeliveryRate kpiDeliveryRate : list) {
            KpiDeliveryRateExample example = new KpiDeliveryRateExample();
            example.createCriteria().andSupCompanySapCodeEqualTo(kpiDeliveryRate.getSupCompanySapCode()).andYearEqualTo(kpiDeliveryRate.getYear()).andMonthEqualTo(kpiDeliveryRate.getMonth());
            List<KpiDeliveryRate> kpiDeliveryRates = this.kpiDeliveryRateMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(kpiDeliveryRates)) {
                kpiDeliveryRate.setId(kpiDeliveryRates.get(0).getId());
                this.modifyObj(kpiDeliveryRate);
                continue;
            }
            kpiDeliveryRate.setId(UUIDGenerator.generateUUID());
            kpiDeliveryRate.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiDeliveryRate.setCreateTime(new Date());
            kpiDeliveryRate.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiDeliveryRatesAdd.add(kpiDeliveryRate);
        }
        if (kpiDeliveryRatesAdd.size() > 0) {
            this.kpiDeliveryRateMapper.insertBatch(kpiDeliveryRatesAdd);
        }
    }

    @Override
    public PageView<KpiOriginalExport> queryReportObjByPage(KpiOriginalExportExample example) {
        PageView<KpiOriginalExport> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiDeliveryRateMapper.selectReportByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<KpiOriginalExport> queryReportAllObjByExample(KpiOriginalExportExample example) {
        return this.kpiDeliveryRateMapper.selectReportByExample(example);
    }
}

