/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiEvaluateSectionMapper;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.service.KpiEvaluateSectionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiEvaluateSectionService")
public class KpiEvaluateSectionServiceImpl
implements KpiEvaluateSectionService {
    @Resource
    protected KpiEvaluateSectionMapper kpiEvaluateSectionMapper;

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    public void addObj(KpiEvaluateSection t) {
        this.kpiEvaluateSectionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    public void addAll(List<KpiEvaluateSection> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiEvaluateSectionMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiEvaluateSectionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    public void deleteByExample(KpiEvaluateSectionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiEvaluateSectionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiEvaluateSection"}, allEntries=true)
    public void modifyObj(KpiEvaluateSection t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiEvaluateSectionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiEvaluateSection"}, keyGenerator="redisKeyGenerator")
    public KpiEvaluateSection queryObjById(String id) {
        return this.kpiEvaluateSectionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiEvaluateSection"}, keyGenerator="redisKeyGenerator")
    public List<KpiEvaluateSection> queryAllObjByExample(KpiEvaluateSectionExample example) {
        return this.kpiEvaluateSectionMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiEvaluateSection"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiEvaluateSection> queryObjByPage(KpiEvaluateSectionExample example) {
        PageView<KpiEvaluateSection> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiEvaluateSectionMapper.selectByExampleByPage(example));
        return pageView;
    }
}

