/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiFormAndCompanyMapper;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.service.KpiFormAndCompanyService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiFormAndCompanyService")
public class KpiFormAndCompanyServiceImpl
implements KpiFormAndCompanyService {
    @Resource
    protected KpiFormAndCompanyMapper kpiFormAndCompanyMapper;

    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void addObj(KpiFormAndCompany t) {
        this.kpiFormAndCompanyMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiFormAndCompanyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void modifyObj(KpiFormAndCompany t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiFormAndCompanyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public KpiFormAndCompany queryObjById(String id) {
        return this.kpiFormAndCompanyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public List<KpiFormAndCompany> queryAllObjByExample(KpiFormAndCompanyExample example) {
        return this.kpiFormAndCompanyMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiFormAndCompany> queryObjByPage(KpiFormAndCompanyExample example) {
        PageView<KpiFormAndCompany> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiFormAndCompanyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<String> queryCompanyIdsByFormCode(String formCode) {
        KpiFormAndCompanyExample companyExample = new KpiFormAndCompanyExample();
        companyExample.createCriteria().andFormCodeEqualTo(formCode);
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.kpiFormAndCompanyMapper.selectByExample(companyExample);
        ArrayList<String> supCompanyIdList = new ArrayList<String>();
        for (int j = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && j < kpiFormAndCompanyList.size(); ++j) {
            supCompanyIdList.add(kpiFormAndCompanyList.get(j).getSupCompanyId());
        }
        return supCompanyIdList;
    }

    @Transactional
    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void addAll(List<KpiFormAndCompany> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiFormAndCompanyMapper.insertSelective((KpiFormAndCompany)item);
        });
    }

    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void deleteByExample(KpiFormAndCompanyExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiFormAndCompanyMapper.deleteByExample(arg0);
    }
}

