/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiFormAndPersonMapper;
import com.els.base.performance.entity.KpiFormAndPerson;
import com.els.base.performance.entity.KpiFormAndPersonExample;
import com.els.base.performance.service.KpiFormAndPersonService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiFormAndPersonService")
public class KpiFormAndPersonServiceImpl
implements KpiFormAndPersonService {
    @Resource
    protected KpiFormAndPersonMapper kpiFormAndPersonMapper;

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    public void addObj(KpiFormAndPerson t) {
        this.kpiFormAndPersonMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiFormAndPersonMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    public void modifyObj(KpiFormAndPerson t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiFormAndPersonMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiFormAndPerson"}, keyGenerator="redisKeyGenerator")
    public KpiFormAndPerson queryObjById(String id) {
        return this.kpiFormAndPersonMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiFormAndPerson"}, keyGenerator="redisKeyGenerator")
    public List<KpiFormAndPerson> queryAllObjByExample(KpiFormAndPersonExample example) {
        return this.kpiFormAndPersonMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiFormAndPerson"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiFormAndPerson> queryObjByPage(KpiFormAndPersonExample example) {
        PageView<KpiFormAndPerson> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiFormAndPersonMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    public void addAll(List<KpiFormAndPerson> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiFormAndPersonMapper.insertSelective((KpiFormAndPerson)item);
        });
    }

    @CacheEvict(value={"kpiFormAndPerson"}, allEntries=true)
    public void deleteByExample(KpiFormAndPersonExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiFormAndPersonMapper.deleteByExample(arg0);
    }
}

