/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.performance.dao.KpiFormMapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.entity.KpiConfiguration;
import com.els.base.performance.entity.KpiConfigurationExample;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.entity.KpiFormAndPerson;
import com.els.base.performance.entity.KpiFormAndPersonExample;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiOriginalScore;
import com.els.base.performance.entity.KpiOriginalScoreExample;
import com.els.base.performance.entity.KpiProject;
import com.els.base.performance.entity.KpiProjectExample;
import com.els.base.performance.entity.KpiQualifiedBatch;
import com.els.base.performance.entity.KpiQualifiedBatchExample;
import com.els.base.performance.entity.KpiQualifiedRate;
import com.els.base.performance.entity.KpiQualifiedRateExample;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceExample;
import com.els.base.performance.entity.KpiSupplierImprove;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateWeight;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.entity.ReportQueryParams;
import com.els.base.performance.entity.ReportShow;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.entity.vo.KpiReport;
import com.els.base.performance.enums.ImproveStatusEnum;
import com.els.base.performance.enums.KpiFormStatus;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiAdverseEventService;
import com.els.base.performance.service.KpiConfigurationService;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiEvaluateSectionService;
import com.els.base.performance.service.KpiFormAndCompanyService;
import com.els.base.performance.service.KpiFormAndPersonService;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiOriginalScoreService;
import com.els.base.performance.service.KpiProjectService;
import com.els.base.performance.service.KpiQualifiedBatchService;
import com.els.base.performance.service.KpiQualifiedRateService;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.performance.service.KpiSupplierImproveService;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.performance.service.KpiTemplateService;
import com.els.base.performance.service.KpiTemplateWeightService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiFormService")
public class KpiFormServiceImpl
implements KpiFormService,
ITaskListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected KpiFormMapper kpiFormMapper;
    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;
    @Resource
    protected KpiFormAndPersonService kpiFormAndPersonService;
    @Resource
    protected KpiRankingService kpiRankingService;
    @Resource
    protected KpiTemplateService kpiTemplateService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected KpiProjectService kpiProjectService;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;
    @Resource
    protected KpiTemplateWeightService kpiTemplateWeightService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiAdverseEventService kpiAdverseEventService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected KpiConfigurationService kpiConfigurationService;
    @Resource
    protected KpiOriginalScoreService kpiOriginalScoreService;
    @Resource
    protected KpiQualifiedRateService kpiQualifiedRateService;
    @Resource
    protected KpiQualifiedBatchService kpiQualifiedBatchService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;
    @Resource
    protected KpiServiceFormService kpiServiceFormService;
    @Resource
    protected KpiServiceService kpiServiceService;
    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private KpiSupplierImproveService kpiSupplierImproveService;
    static ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void addObj(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        t.setFormCode(formCode);
        this.kpiFormMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void modifyObj(KpiForm t) {
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void addObject(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        t.setCreateTime(new Date());
        t.setFormState(KpiFormStatus.NEW.getValue());
        t.setFormCalculation(Constant.NO_INT.toString());
        t.setFormCode(formCode);
        t.setPurCompanyId(currentCompany.getId());
        t.setPurCompanyCode(currentCompany.getCompanyCode());
        t.setPurCompanyName(currentCompany.getCompanyName());
        t.setPurUserId(user.getId());
        t.setPurUserName(user.getNickName());
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(t.getKpiTemplateId());
        t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
        t.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        this.kpiFormMapper.insertSelective(t);
        this.addCompanyAndPersonInfo(t);
    }

    private void addCompanyAndPersonInfo(KpiForm t) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = t.getKpiFormAndCompanyList();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            this.addKpiCompany(t, kpiFormAndCompany);
        }
        for (KpiFormAndPerson kpiFormAndPerson : t.getKpiFormAndPersonList()) {
            this.addKpiPerson(t, kpiFormAndPerson);
        }
    }

    private void addKpiCompany(KpiForm t, KpiFormAndCompany kpiFormAndCompany) {
        Company supCompany = this.companyService.queryCompanyByCode(kpiFormAndCompany.getSupCompanySrmCode());
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        kpiFormAndCompany.setKpiFormId(t.getId());
        kpiFormAndCompany.setFormCode(t.getFormCode());
        kpiFormAndCompany.setPurCompanyId(currentCompany.getId());
        kpiFormAndCompany.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndCompany.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndCompany.setPurUserId(user.getId());
        kpiFormAndCompany.setPurUserName(user.getNickName());
        kpiFormAndCompany.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndCompany.setLastUpdateUser(t.getLastUpdateUser());
        kpiFormAndCompany.setCategoryName(supCompany.getCategoryName());
        kpiFormAndCompany.setCriticality(supCompany.getCapitalType());
        kpiFormAndCompany.setSymbiosis(supCompany.getSymbiosis());
        kpiFormAndCompany.setProductImportance(supCompany.getProductImportanceName());
        kpiFormAndCompany.setOnlineSrmFlag(supCompany.getIsOnline());
        this.kpiFormAndCompanyService.addObj(kpiFormAndCompany);
    }

    private void addKpiPerson(KpiForm t, KpiFormAndPerson kpiFormAndPerson) {
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        kpiFormAndPerson.setKpiFormId(t.getId());
        kpiFormAndPerson.setFormCode(t.getFormCode());
        kpiFormAndPerson.setPurCompanyId(currentCompany.getId());
        kpiFormAndPerson.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndPerson.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndPerson.setPurUserId(user.getId());
        kpiFormAndPerson.setPurUserName(user.getNickName());
        kpiFormAndPerson.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndPerson.setLastUpdateUser(t.getLastUpdateUser());
        this.kpiFormAndPersonService.addObj(kpiFormAndPerson);
    }

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deleteKpiCompanyAndPerson(id);
        this.kpiFormMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void modifyObject(KpiForm t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        User user = t.getUser();
        KpiForm kpiForm = this.kpiFormMapper.selectByPrimaryKey(t.getId());
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(user.getNickName());
        t.setFormCode(kpiForm.getFormCode());
        this.deleteKpiCompanyAndPerson(t.getId());
        this.addCompanyAndPersonInfo(t);
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    private void deleteKpiCompanyAndPerson(String kpiId) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiId);
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            this.kpiFormAndCompanyService.deleteObjById(kpiFormAndCompany.getId());
        }
        List<KpiFormAndPerson> kpiFormAndPersonList = this.queryPersonInfoByKpiId(kpiId);
        for (KpiFormAndPerson kpiFormAndPerson : kpiFormAndPersonList) {
            this.kpiFormAndPersonService.deleteObjById(kpiFormAndPerson.getId());
        }
    }

    @Cacheable(value={"kpiForm"}, keyGenerator="redisKeyGenerator")
    public KpiForm queryObjById(String id) {
        return this.kpiFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiForm"}, keyGenerator="redisKeyGenerator")
    public List<KpiForm> queryAllObjByExample(KpiFormExample example) {
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormList) && i < kpiFormList.size(); ++i) {
            KpiForm kpiForm = kpiFormList.get(i);
            kpiForm.setKpiFormAndCompanyList(this.queryCompanyInfoByKpiId(kpiForm.getId()));
            kpiForm.setKpiFormAndPersonList(this.queryPersonInfoByKpiId(kpiForm.getId()));
        }
        return kpiFormList;
    }

    @Override
    public List<KpiForm> queryAllObjByExampleCoustom(KpiFormExample example) {
        return this.kpiFormMapper.selectByExample(example);
    }

    public PageView<KpiForm> queryObjByPage(KpiFormExample example) {
        PageView<KpiForm> pageView = example.getPageView();
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExampleByPage(example);
        pageView.setQueryResult(kpiFormList);
        return pageView;
    }

    private List<KpiFormAndPerson> queryPersonInfoByKpiId(String kpiFormId) {
        KpiFormAndPersonExample example = new KpiFormAndPersonExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample((IExample)example);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
            com.els.base.core.entity.user.User user = (com.els.base.core.entity.user.User)this.userService.queryObjById((Object)((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getPersonUserId());
            ((KpiFormAndPerson)kpiFormAndPersonList.get(i)).setLoginName(user.getLoginName());
        }
        return kpiFormAndPersonList;
    }

    @Override
    public List<KpiFormAndCompany> queryCompanyInfoByKpiId(String kpiFormId) {
        KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List kpiFormAndCompanyList = this.kpiFormAndCompanyService.queryAllObjByExample((IExample)example);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); ++i) {
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeEqualTo(((KpiFormAndCompany)kpiFormAndCompanyList.get(i)).getSupCompanySrmCode());
            List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
            ((KpiFormAndCompany)kpiFormAndCompanyList.get(i)).setPurCompanyCategory(((Company)companyList.get(0)).getFirstCompanyType());
            ((KpiFormAndCompany)kpiFormAndCompanyList.get(i)).setPurCompanyRank(((Company)companyList.get(0)).getGrade());
        }
        return kpiFormAndCompanyList;
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    @Transactional
    public void finishForm(KpiForm kpiForm) {
        KpiForm form = this.queryObjById(kpiForm.getId());
        if (form == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u8bc4\u4f30\u8868\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", new Object[]{"\u8bc4\u4f30\u8868\u6570\u636e"});
        }
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(form.getKpiTemplateId());
        if (kpiTemplate == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", new Object[]{"\u8bc4\u4f30\u6a21\u677f\u6570\u636e"});
        }
        Date date = new Date();
        KpiForm kpiFormVO = new KpiForm();
        kpiFormVO.setId(kpiForm.getId());
        kpiFormVO.setFormCode(kpiForm.getFormCode());
        kpiFormVO.setFormState("2");
        kpiFormVO.setFormFactTime(date);
        kpiFormVO.setLastUpdateUser(kpiForm.getUser().getNickName());
        kpiFormVO.setLastUpdateTime(date);
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVO);
        KpiRankingExample kpiRankingExample = new KpiRankingExample();
        KpiRankingExample.Criteria rankingCriteria = kpiRankingExample.createCriteria();
        rankingCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        rankingCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        this.kpiRankingService.deleteByExample(kpiRankingExample);
        KpiFormAndCompanyExample kpiFormAndCompanyExample = new KpiFormAndCompanyExample();
        KpiFormAndCompanyExample.Criteria formAndCompanyCriteria = kpiFormAndCompanyExample.createCriteria();
        formAndCompanyCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        formAndCompanyCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        List kpiFormAndCompany = this.kpiFormAndCompanyService.queryAllObjByExample((IExample)kpiFormAndCompanyExample);
        for (KpiFormAndCompany formAndCompany : kpiFormAndCompany) {
            KpiRanking t = new KpiRanking();
            t.setSupCompanyId(formAndCompany.getSupCompanyId());
            t.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            KpiRanking lastKpiRanking = this.kpiRankingService.selectByCustom(t);
            KpiRanking currKpiRanking = new KpiRanking();
            currKpiRanking.setPurCompanyId(kpiForm.getCompany().getId());
            currKpiRanking.setPurCompanyCode(kpiForm.getCompany().getCompanyCode());
            currKpiRanking.setPurCompanyName(kpiForm.getCompany().getCompanyName());
            currKpiRanking.setPurUserId(kpiForm.getUser().getId());
            currKpiRanking.setPurUserName(kpiForm.getUser().getNickName());
            currKpiRanking.setKpiFormId(form.getId());
            currKpiRanking.setFormName(form.getFormName());
            currKpiRanking.setFormPublishTime(form.getFormStartTime());
            currKpiRanking.setFormFactTime(date);
            currKpiRanking.setSupCompanyId(formAndCompany.getSupCompanyId());
            currKpiRanking.setSupCompanySapCode(formAndCompany.getSupCompanySapCode());
            currKpiRanking.setSupCompanyName(formAndCompany.getSupCompanyName());
            currKpiRanking.setSupUserName(formAndCompany.getSupUserName());
            currKpiRanking.setSupUserId(formAndCompany.getSupUserId());
            currKpiRanking.setImportantFlag(formAndCompany.getImportantFlag());
            currKpiRanking.setCategory(formAndCompany.getCategory());
            currKpiRanking.setSalesMan(formAndCompany.getSalesMan());
            currKpiRanking.setDevelopmentManager(formAndCompany.getDevelopmentManager());
            currKpiRanking.setOnlineSrmFlag(formAndCompany.getOnlineSrmFlag());
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setCreateTime(new Date());
            currKpiRanking.setLastUpdateTime(new Date());
            currKpiRanking.setLastUpdateUser(kpiForm.getUser().getNickName());
            currKpiRanking.setFormCode(kpiForm.getFormCode());
            currKpiRanking.setTemplateCode(kpiTemplate.getTemplateCode());
            currKpiRanking.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            currKpiRanking.setRankingScore(lastKpiRanking == null ? null : lastKpiRanking.getRankingScore());
            this.kpiRankingService.insertCustom(currKpiRanking);
        }
    }

    private void updateOriginalScore(KpiRanking currKpiRanking) {
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(currKpiRanking.getKpiFormId()).andCompanySrmCodeEqualTo(currKpiRanking.getSupCompanySrmCode());
        List kpiOriginalScores = this.kpiOriginalScoreService.queryAllObjByExample((IExample)example);
        this.logger.info("kpiOriginalScores.size:" + kpiOriginalScores.size());
        if (CollectionUtils.isNotEmpty((Collection)kpiOriginalScores)) {
            KpiOriginalScore score = (KpiOriginalScore)kpiOriginalScores.get(0);
            this.logger.info("score:" + score);
            KpiRanking ranking = new KpiRanking();
            KpiRankingExample example1 = new KpiRankingExample();
            example.createCriteria().andKpiFormIdEqualTo(currKpiRanking.getKpiFormId()).andCompanySrmCodeEqualTo(currKpiRanking.getSupCompanySrmCode());
            this.kpiRankingService.updateByExampleSelective(ranking, example1);
        }
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void releaseKpiFrom(KpiForm kpiForm) {
        if (kpiForm.getFormState() != null && !kpiForm.getFormState().equals(KpiFormStatus.NEW.getValue())) {
            throw new CommonException("\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c", "repeat_release");
        }
        Company currentCompany = kpiForm.getCompany();
        User user = kpiForm.getUser();
        KpiForm form = new KpiForm();
        form.setId(kpiForm.getId());
        form.setFormPlanTime(kpiForm.getFormPlanTime());
        form.setFormState(KpiFormStatus.ONGOING.getValue());
        form.setFormPublishTime(new Date());
        this.kpiFormMapper.updateByPrimaryKeySelective(form);
        List<KpiTemplateItem> kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiForm.getId());
        Date time = kpiForm.getFormStartTime();
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        int month = ca.get(2) + 1;
        int year = ca.get(1);
        KpiServiceExample serviceExample = new KpiServiceExample();
        serviceExample.createCriteria().andYearEqualTo(String.valueOf(year)).andMonthEqualTo(String.valueOf(month)).andStatusEqualTo(KpiServiceFormStatus.CONFIRM.getValue());
        List kpiServices = this.kpiServiceService.queryAllObjByExample((IExample)serviceExample);
        KpiQualifiedRateExample qualifiedRateExample = new KpiQualifiedRateExample();
        qualifiedRateExample.createCriteria().andYearEqualTo(String.valueOf(year)).andMonthEqualTo(String.valueOf(month));
        List kpiQualifiedRates = this.kpiQualifiedRateService.queryAllObjByExample((IExample)qualifiedRateExample);
        KpiDeliveryRateExample deliveryRateExample = new KpiDeliveryRateExample();
        deliveryRateExample.createCriteria().andYearEqualTo(String.valueOf(year)).andMonthEqualTo(String.valueOf(month));
        List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)deliveryRateExample);
        KpiQualifiedBatchExample qualifiedBatchExample = new KpiQualifiedBatchExample();
        qualifiedBatchExample.createCriteria().andYearEqualTo(String.valueOf(year)).andMonthEqualTo(String.valueOf(month));
        List kpiQualifiedBatchs = this.kpiQualifiedBatchService.queryAllObjByExample((IExample)qualifiedBatchExample);
        KpiEvaluateSectionExample kpiEvaluateSectionExample = new KpiEvaluateSectionExample();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("deliver");
        List kpiEvaluateSectionsDeliver = this.kpiEvaluateSectionService.queryAllObjByExample((IExample)kpiEvaluateSectionExample);
        kpiEvaluateSectionExample.clear();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("quality");
        List kpiEvaluateSectionsQuality = this.kpiEvaluateSectionService.queryAllObjByExample((IExample)kpiEvaluateSectionExample);
        kpiEvaluateSectionExample.clear();
        kpiEvaluateSectionExample.createCriteria().andProjectTypeEqualTo("qualityCount");
        List kpiEvaluateSectionsQualityCount = this.kpiEvaluateSectionService.queryAllObjByExample((IExample)kpiEvaluateSectionExample);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); ++i) {
            KpiFormAndCompany kpiFormAndCompany = kpiFormAndCompanyList.get(i);
            KpiScore kpiScore = new KpiScore();
            kpiScore.setPurCompanyId(currentCompany.getId());
            kpiScore.setPurCompanyCode(currentCompany.getCompanyCode());
            kpiScore.setPurCompanyName(currentCompany.getCompanyName());
            kpiScore.setPurUserId(user.getId());
            kpiScore.setPurUserName(user.getUsername());
            kpiScore.setKpiFormId(kpiForm.getId());
            kpiScore.setFormCode(kpiForm.getFormCode());
            kpiScore.setFormName(kpiForm.getFormName());
            kpiScore.setSupCompanyId(kpiFormAndCompanyList.get(i).getSupCompanyId());
            kpiScore.setSupCompanySrmCode(kpiFormAndCompanyList.get(i).getSupCompanySrmCode());
            kpiScore.setSupCompanySapCode(kpiFormAndCompanyList.get(i).getSupCompanySapCode());
            kpiScore.setSupCompanyName(kpiFormAndCompanyList.get(i).getSupCompanyName());
            kpiScore.setSupUserId(kpiFormAndCompanyList.get(i).getSupUserId());
            kpiScore.setSupUserName(kpiFormAndCompanyList.get(i).getSupUserName());
            for (int j = 0; CollectionUtils.isNotEmpty(kpiTemplateItemList) && j < kpiTemplateItemList.size(); ++j) {
                kpiScore.setKpiTemplateId(kpiTemplateItemList.get(j).getKpiTemplateId());
                kpiScore.setTemplateCode(kpiTemplateItemList.get(j).getTemplateCode());
                KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(kpiTemplateItemList.get(j).getKpiTemplateId());
                kpiScore.setTemplateName(kpiTemplate.getTemplateName());
                KpiFormAndPersonExample personExample = new KpiFormAndPersonExample();
                personExample.createCriteria().andFormCodeEqualTo(kpiForm.getFormCode()).andProjectTypeEqualTo(kpiTemplateItemList.get(j).getProjectType());
                List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample((IExample)personExample);
                if (CollectionUtils.isNotEmpty((Collection)kpiFormAndPersonList)) {
                    kpiScore.setPersonUserId(((KpiFormAndPerson)kpiFormAndPersonList.get(0)).getPersonUserId());
                    kpiScore.setPersonUserName(((KpiFormAndPerson)kpiFormAndPersonList.get(0)).getPersonUserName());
                }
                kpiScore.setKpiProjectId(kpiTemplateItemList.get(j).getKpiProjectId());
                kpiScore.setProjectCode(kpiTemplateItemList.get(j).getProjectCode());
                kpiScore.setProjectName(kpiTemplateItemList.get(j).getProjectName());
                kpiScore.setProjectType(kpiTemplateItemList.get(j).getProjectType());
                kpiScore.setProjectHandlType(kpiTemplateItemList.get(j).getProjectHandlType());
                kpiScore.setProjectMethodType(kpiTemplateItemList.get(j).getProjectMethodType());
                kpiScore.setProjectMethodParameter(kpiTemplateItemList.get(j).getProjectMethodParameter());
                kpiScore.setProjectTypeName(kpiTemplateItemList.get(j).getProjectTypeName());
                kpiScore.setProjectWeight(kpiTemplateItemList.get(j).getProjectWeight());
                kpiScore.setScoreState(Constant.NO_INT.toString());
                kpiScore.setCreateTime(new Date());
                kpiScore.setId(null);
                kpiScore.setScoreScore("");
                kpiScore.setOriginalValue("");
                kpiScore.setCorrectionValue("");
                block6 : switch (kpiScore.getProjectType()) {
                    case "service": {
                        for (KpiService kpiService : kpiServices) {
                            if (!kpiService.getSupCompanySapCode().equals(kpiScore.getSupCompanySapCode())) continue;
                            kpiScore.setScoreScore(String.valueOf(kpiService.getScore()));
                            kpiScore.setOriginalValue(String.valueOf(kpiService.getScore()));
                            kpiScore.setCorrectionValue(String.valueOf(kpiService.getScore()));
                            break block6;
                        }
                        break;
                    }
                    case "quality": {
                        Object kpiQualifiedRate2;
                        boolean qualityCorrectionValue = false;
                        for (Object kpiQualifiedRate2 : kpiQualifiedRates) {
                            if (StringUtils.isNotEmpty((String)((KpiQualifiedRate)kpiQualifiedRate2).getSupCompanySapCode())) {
                                if (!kpiScore.getSupCompanySapCode().equals(((KpiQualifiedRate)kpiQualifiedRate2).getSupCompanySapCode())) continue;
                                kpiScore.setOriginalValue(((KpiQualifiedRate)kpiQualifiedRate2).getQualifieDrate());
                                kpiScore.setCorrectionValue(((KpiQualifiedRate)kpiQualifiedRate2).getQualifieDrate());
                                kpiScore.setImportantFlag(((KpiQualifiedRate)kpiQualifiedRate2).getImportantFlag());
                                kpiScore.setCategory(((KpiQualifiedRate)kpiQualifiedRate2).getCategory());
                                kpiScore.setSalesMan(((KpiQualifiedRate)kpiQualifiedRate2).getSalesMan());
                                kpiScore.setDevelopmentManager(((KpiQualifiedRate)kpiQualifiedRate2).getDevelopmentManager());
                                kpiFormAndCompany.setImportantFlag(((KpiQualifiedRate)kpiQualifiedRate2).getImportantFlag());
                                kpiFormAndCompany.setCategory(((KpiQualifiedRate)kpiQualifiedRate2).getCategory());
                                kpiFormAndCompany.setSalesMan(((KpiQualifiedRate)kpiQualifiedRate2).getSalesMan());
                                kpiFormAndCompany.setDevelopmentManager(((KpiQualifiedRate)kpiQualifiedRate2).getDevelopmentManager());
                                this.kpiFormAndCompanyService.modifyObj(kpiFormAndCompany);
                                qualityCorrectionValue = true;
                                break;
                            }
                            if (!kpiScore.getSupCompanyName().equals(((KpiQualifiedRate)kpiQualifiedRate2).getSupCompanyName())) continue;
                            kpiScore.setOriginalValue(((KpiQualifiedRate)kpiQualifiedRate2).getQualifieDrate());
                            kpiScore.setCorrectionValue(((KpiQualifiedRate)kpiQualifiedRate2).getQualifieDrate());
                            kpiScore.setImportantFlag(((KpiQualifiedRate)kpiQualifiedRate2).getImportantFlag());
                            kpiScore.setCategory(((KpiQualifiedRate)kpiQualifiedRate2).getCategory());
                            kpiScore.setSalesMan(((KpiQualifiedRate)kpiQualifiedRate2).getSalesMan());
                            kpiScore.setDevelopmentManager(((KpiQualifiedRate)kpiQualifiedRate2).getDevelopmentManager());
                            kpiFormAndCompany.setImportantFlag(((KpiQualifiedRate)kpiQualifiedRate2).getImportantFlag());
                            kpiFormAndCompany.setCategory(((KpiQualifiedRate)kpiQualifiedRate2).getCategory());
                            kpiFormAndCompany.setSalesMan(((KpiQualifiedRate)kpiQualifiedRate2).getSalesMan());
                            kpiFormAndCompany.setDevelopmentManager(((KpiQualifiedRate)kpiQualifiedRate2).getDevelopmentManager());
                            this.kpiFormAndCompanyService.modifyObj(kpiFormAndCompany);
                            qualityCorrectionValue = true;
                            break;
                        }
                        if (!qualityCorrectionValue) break;
                        String originalValue = kpiScore.getCorrectionValue();
                        kpiQualifiedRate2 = kpiEvaluateSectionsQuality.iterator();
                        while (kpiQualifiedRate2.hasNext()) {
                            KpiEvaluateSection kpiEvaluateSectionQR = (KpiEvaluateSection)kpiQualifiedRate2.next();
                            double qualityOriginalValue = Double.valueOf(originalValue = originalValue.replace(kpiEvaluateSectionQR.getSectionType(), ""));
                            if (!(qualityOriginalValue >= kpiEvaluateSectionQR.getStartSection()) || !(qualityOriginalValue <= kpiEvaluateSectionQR.getEndSection())) continue;
                            if (StringUtils.isEmpty((String)kpiEvaluateSectionQR.getCoefficient()) && !"0".equals(kpiEvaluateSectionQR.getCoefficient())) {
                                kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionQR.getScore()));
                                continue;
                            }
                            double coefficient = Double.valueOf(kpiEvaluateSectionQR.getCoefficient());
                            double scorequality = qualityOriginalValue * coefficient;
                            DecimalFormat df = new DecimalFormat("#.00");
                            String str = df.format(scorequality);
                            kpiScore.setScoreScore(str);
                        }
                        break;
                    }
                    case "deliver": {
                        boolean diverCorrectionValue = false;
                        for (KpiDeliveryRate kpiDeliveryRate : kpiDeliveryRates) {
                            if (!kpiScore.getSupCompanySapCode().equals(kpiDeliveryRate.getSupCompanySapCode())) continue;
                            kpiScore.setOriginalValue(kpiDeliveryRate.getFirstEdition());
                            kpiScore.setCorrectionValue(kpiDeliveryRate.getSecondEdition());
                            diverCorrectionValue = true;
                            break;
                        }
                        if (!diverCorrectionValue) break;
                        String originalValue = kpiScore.getCorrectionValue();
                        for (KpiEvaluateSection kpiEvaluateSectionD : kpiEvaluateSectionsDeliver) {
                            double deliverOriginalValue = Double.valueOf(originalValue = originalValue.replace(kpiEvaluateSectionD.getSectionType(), ""));
                            if (!(deliverOriginalValue >= kpiEvaluateSectionD.getStartSection()) || !(deliverOriginalValue <= kpiEvaluateSectionD.getEndSection())) continue;
                            if (StringUtils.isEmpty((String)kpiEvaluateSectionD.getCoefficient()) && !"0".equals(kpiEvaluateSectionD.getCoefficient())) {
                                kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionD.getScore()));
                                continue;
                            }
                            double coefficient = Double.valueOf(kpiEvaluateSectionD.getCoefficient());
                            double scorequality = deliverOriginalValue * coefficient;
                            DecimalFormat df = new DecimalFormat("#.00");
                            String str = df.format(scorequality);
                            kpiScore.setScoreScore(str);
                        }
                        break;
                    }
                    case "qualityCount": {
                        int qualitycount = 0;
                        for (KpiQualifiedBatch kpiQualifiedBatch : kpiQualifiedBatchs) {
                            if (!kpiScore.getSupCompanySapCode().equals(kpiQualifiedBatch.getSupCompanySapCode())) continue;
                            ++qualitycount;
                        }
                        for (KpiEvaluateSection kpiEvaluateSectionQC : kpiEvaluateSectionsQualityCount) {
                            if (!((double)qualitycount >= kpiEvaluateSectionQC.getStartSection()) || !((double)qualitycount <= kpiEvaluateSectionQC.getEndSection())) continue;
                            kpiScore.setScoreScore(String.valueOf(kpiEvaluateSectionQC.getScore()));
                            break;
                        }
                        kpiScore.setOriginalValue(String.valueOf(qualitycount));
                        kpiScore.setCorrectionValue(String.valueOf(qualitycount));
                    }
                }
                this.kpiScoreService.addObj(kpiScore);
            }
        }
    }

    @Override
    public KpiFormVo lookAtTheScore(KpiForm kpiForm) {
        KpiFormVo kpiFormVo = new KpiFormVo();
        kpiFormVo.setKpiFormId(kpiForm.getId());
        kpiFormVo.setFormCode(kpiForm.getFormCode());
        kpiFormVo.setFormName(kpiForm.getFormName());
        kpiFormVo.setKpiTemplateId(kpiForm.getKpiTemplateId());
        kpiFormVo.setTemplateCode(kpiForm.getTemplateCode());
        kpiFormVo.setFormStartTime(kpiForm.getFormStartTime());
        kpiFormVo.setFormEndTime(kpiForm.getFormEndTime());
        KpiFormVo stateAndPersonAndWeight = this.queryStateAndPersonAndWeight(kpiForm);
        kpiFormVo.setScoreState(stateAndPersonAndWeight.getScoreState());
        kpiFormVo.setScorePerson(stateAndPersonAndWeight.getScorePerson());
        kpiFormVo.setClassWeight(stateAndPersonAndWeight.getClassWeight());
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(kpiForm.getKpiTemplateId());
        if (kpiTemplate != null) {
            kpiFormVo.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            kpiFormVo.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        }
        KpiFormVo kFormVo = this.assembleKpiFormData(kpiForm, kpiFormVo);
        return kFormVo;
    }

    private KpiFormVo queryStateAndPersonAndWeight(KpiForm kpiForm) {
        StringBuffer weightBuffer;
        KpiFormVo kpiFormVo = new KpiFormVo();
        ArrayList<String> scoreStateList = new ArrayList<String>();
        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || roleCodeList.contains("supperfomconfirm"))) {
            criteria.andPersonUserIdEqualTo(kpiForm.getUser().getId());
        }
        List kpiScoreList = this.kpiScoreService.queryAllObjByExample((IExample)kpiScoreExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiScoreList) && i < kpiScoreList.size(); ++i) {
            scoreStateList.add(((KpiScore)kpiScoreList.get(i)).getScoreState());
        }
        if (CollectionUtils.isNotEmpty(scoreStateList)) {
            if (Collections.frequency(scoreStateList, "1") == scoreStateList.size()) {
                kpiFormVo.setScoreState(Constant.YES_INT.toString());
            } else {
                kpiFormVo.setScoreState(Constant.NO_INT.toString());
            }
        }
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || roleCodeList.contains("supperfomconfirm"))) {
            kpiFormVo.setScorePerson(kpiForm.getUser().getNickName() == null ? "\u3010" + kpiForm.getUser().getLoginName() + "\u3011" : kpiForm.getUser().getNickName() + "\u3010" + kpiForm.getUser().getLoginName() + "\u3011");
        } else {
            List<KpiFormAndPerson> infoByKpiId = this.queryPersonInfoByKpiId(kpiForm.getId());
            ArrayList<String> stringList = new ArrayList<String>();
            for (KpiFormAndPerson kpiFormAndPerson : infoByKpiId) {
                com.els.base.core.entity.user.User user = (com.els.base.core.entity.user.User)this.userService.queryObjById((Object)kpiFormAndPerson.getPersonUserId());
                stringList.add(kpiFormAndPerson.getPersonUserName() == null ? "\u3010" + user.getLoginName() + "\u3011" : kpiFormAndPerson.getPersonUserName() + "\u3010" + user.getLoginName() + "\u3011");
            }
            kpiFormVo.setScorePerson(((Object)stringList).toString().replaceAll("[\\[\\]]", ""));
        }
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || roleCodeList.contains("supperfomconfirm"))) {
            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId()).andKpiFormIdEqualTo(kpiForm.getId());
            List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample((IExample)example);
            weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
                KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
                weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId()).andProjectTypeEqualTo(((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getProjectType());
                List kpiTemplateWeightList = this.kpiTemplateWeightService.queryAllObjByExample((IExample)weightExample);
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)kpiTemplateWeightList) && j < kpiTemplateWeightList.size(); ++j) {
                    weightBuffer.append("\u3010").append(((KpiTemplateWeight)kpiTemplateWeightList.get(j)).getProjectTypeName()).append("\u3011").append(":").append(((KpiTemplateWeight)kpiTemplateWeightList.get(j)).getProjectTypeWeight()).append(",");
                }
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        } else {
            KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
            weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId());
            List kpiTemplateWeightList = this.kpiTemplateWeightService.queryAllObjByExample((IExample)weightExample);
            weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiTemplateWeightList) && i < kpiTemplateWeightList.size(); ++i) {
                weightBuffer.append("\u3010").append(((KpiTemplateWeight)kpiTemplateWeightList.get(i)).getProjectTypeName()).append("\u3011").append(":").append(((KpiTemplateWeight)kpiTemplateWeightList.get(i)).getProjectTypeWeight()).append(",");
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        }
        return kpiFormVo;
    }

    private KpiFormVo assembleKpiFormData(KpiForm kpiForm, KpiFormVo kpiFormVo) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        List<Object> kpiTemplateItemList = new ArrayList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || roleCodeList.contains("supperfomconfirm"))) {
            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId()).andKpiFormIdEqualTo(kpiForm.getId());
            List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample((IExample)example);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
                KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
                templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId()).andProjectTypeEqualTo(((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getProjectType());
                kpiTemplateItemList.addAll(this.kpiTemplateItemService.queryAllObjByExample((IExample)templateItemExample));
            }
        } else if (CollectionUtils.isEmpty(kpiTemplateItemList)) {
            kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        }
        ArrayList<String> ProjectCodeArray = new ArrayList<String>();
        ArrayList<Map<String, String>> titles = new ArrayList<Map<String, String>>();
        StringBuffer titleBuffer = new StringBuffer();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
            HashMap<String, String> titleMap = new HashMap<String, String>();
            titleBuffer.setLength(0);
            titleBuffer.append("\u3010").append(kpiTemplateItem.getProjectTypeName()).append("\u3011").append(kpiTemplateItem.getProjectName());
            titleMap.put("projectCode", kpiTemplateItem.getProjectCode());
            titleMap.put("projectName", titleBuffer.toString());
            titleMap.put("projectStandard", kpiTemplateItem.getProjectStandard());
            titleMap.put("projectInstruction", kpiTemplateItem.getProjectInstruction());
            KpiProjectExample kpiProjectExample = new KpiProjectExample();
            kpiProjectExample.createCriteria().andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
            List KpiProjectList = this.kpiProjectService.queryAllObjByExample((IExample)kpiProjectExample);
            if (CollectionUtils.isNotEmpty((Collection)KpiProjectList) && ((KpiProject)KpiProjectList.get(0)).getProjectHandlType() != null && ((KpiProject)KpiProjectList.get(0)).getProjectHandlType().equals("2")) {
                titleMap.put("getOfApi", "Y");
            }
            titleMap.put("latitude", ((KpiProject)KpiProjectList.get(0)).getProjectDimension());
            if (SpringSecurityUtils.getLoginUserId().equals("1") || roleCodeList.contains("supperfomconfirm")) {
                titles.add(titleMap);
                continue;
            }
            KpiFormAndPersonExample kpiFormAndPersonExample = new KpiFormAndPersonExample();
            kpiFormAndPersonExample.createCriteria().andKpiFormIdEqualTo(kpiForm.getId()).andPersonUserIdEqualTo(SpringSecurityUtils.getLoginUserId()).andFormCodeEqualTo(kpiForm.getFormCode()).andProjectTypeEqualTo(kpiTemplateItem.getProjectType());
            List KpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample((IExample)kpiFormAndPersonExample);
            if (!CollectionUtils.isNotEmpty((Collection)KpiFormAndPersonList)) continue;
            titles.add(titleMap);
            ProjectCodeArray.add(kpiTemplateItem.getProjectCode());
        }
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiForm.getId());
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            HashMap<String, Object> kpiFormVoItem = new HashMap<String, Object>();
            kpiFormVoItem.put("supplierSapCode", kpiFormAndCompany.getSupCompanySapCode());
            kpiFormVoItem.put("supplierSrmCode", kpiFormAndCompany.getSupCompanySrmCode());
            kpiFormVoItem.put("supplierSrmName", kpiFormAndCompany.getSupCompanyName());
            kpiFormVoItem.put("categoryName", kpiFormAndCompany.getCategory());
            KpiRankingExample kpiRankingExample = new KpiRankingExample();
            KpiRankingExample.Criteria criteria = kpiRankingExample.createCriteria();
            criteria.andFormCodeEqualTo(kpiFormAndCompany.getFormCode()).andSupCompanySrmCodeEqualTo(kpiFormAndCompany.getSupCompanySrmCode());
            List kpiRankings = this.kpiRankingService.queryAllObjByExample((IExample)kpiRankingExample);
            if (kpiRankings.size() != 0) {
                kpiFormVoItem.put("rankingScore", ((KpiRanking)kpiRankings.get(0)).getRankingScore());
                kpiFormVoItem.put("purCheckRank", ((KpiRanking)kpiRankings.get(0)).getPurCheckRank());
                kpiFormVoItem.put("ranking", ((KpiRanking)kpiRankings.get(0)).getRanking());
                kpiFormVoItem.put("importantflag", ((KpiRanking)kpiRankings.get(0)).getImportantFlag());
            } else {
                kpiFormVoItem.put("rankingScore", null);
                kpiFormVoItem.put("purCheckRank", null);
                kpiFormVoItem.put("ranking", null);
                kpiFormVoItem.put("importantflag", null);
            }
            List<KpiScore> scoreList = this.getScore(kpiFormAndCompany, kpiTemplateItemList);
            for (final KpiScore score : scoreList) {
                if (StringUtils.isNotEmpty((String)score.getImportantFlag())) {
                    kpiFormVoItem.put("importantflag", score.getImportantFlag());
                }
                if (StringUtils.isNotEmpty((String)score.getScoreScore())) {
                    kpiFormVoItem.put(score.getProjectCode(), new HashMap<String, String>(){
                        {
                            this.put("originalScore", score.getOriginalValue());
                            this.put("correctionValue", score.getCorrectionValue());
                            this.put("score", score.getScoreScore());
                        }
                    });
                    continue;
                }
                kpiFormVoItem.put(score.getProjectCode(), new HashMap<String, Integer>(){
                    {
                        this.put("originalScore", null);
                        this.put("correctionValue", null);
                        this.put("score", null);
                    }
                });
            }
            arrayList.add(kpiFormVoItem);
        }
        kpiFormVo.setTitles(titles);
        kpiFormVo.setKpiFormVoItemList(arrayList);
        return kpiFormVo;
    }

    private Map<String, String> getScoreMap(KpiScore score) {
        HashMap<String, String> map = new HashMap<String, String>();
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(score.getKpiFormId()).andCompanySrmCodeEqualTo(score.getSupCompanySrmCode());
        List originalScores = this.kpiOriginalScoreService.queryAllObjByExample((IExample)example);
        map.put("score", score.getScoreScore());
        if (CollectionUtils.isEmpty((Collection)originalScores)) {
            map.put("originalScore", null);
            return map;
        }
        KpiOriginalScore originalScore = (KpiOriginalScore)originalScores.get(0);
        switch (score.getProjectType()) {
            case "deliver": {
                map.put("originalScore", originalScore.getOriginalDeliver());
                break;
            }
            case "service": {
                map.put("originalScore", originalScore.getOriginalService());
                break;
            }
            case "price": {
                map.put("originalScore", originalScore.getOriginalPrice());
                break;
            }
            case "quality": {
                map.put("originalScore", originalScore.getOriginalQuality());
                break;
            }
            case "qualityCount": {
                map.put("originalScore", originalScore.getOriginalQualityCount());
            }
        }
        return map;
    }

    private List<KpiScore> getScore(KpiFormAndCompany kpiFormAndCompany, List<KpiTemplateItem> kpiTemplateItemList) {
        ArrayList<KpiScore> scoreList = new ArrayList<KpiScore>();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andSupCompanySrmCodeEqualTo(kpiFormAndCompany.getSupCompanySrmCode()).andProjectCodeEqualTo(kpiTemplateItem.getProjectCode()).andKpiTemplateIdEqualTo(kpiTemplateItem.getKpiTemplateId()).andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId());
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample((IExample)kpiScoreExample);
            scoreList.addAll(kpiScoreList);
        }
        return scoreList;
    }

    @Override
    public List<KpiTemplateItem> queryKpiTemplateItem(String kpiTemplateId) {
        KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
        templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiTemplateId);
        List kpiTemplateItemList = this.kpiTemplateItemService.queryAllObjByExample((IExample)templateItemExample);
        return kpiTemplateItemList;
    }

    @Override
    public KpiForm lookKpiFormDetails(String kpiFormId) {
        KpiForm form = this.kpiFormMapper.selectByPrimaryKey(kpiFormId);
        form.setKpiFormAndCompanyList(this.queryCompanyInfoByKpiId(kpiFormId));
        form.setKpiFormAndPersonList(this.queryPersonInfoByKpiId(kpiFormId));
        return form;
    }

    @Override
    @CacheEvict(value={"kpiForm", "kpiScore"}, allEntries=true)
    @Transactional
    public void saveAtTheScore(KpiFormVo kpiFormVo, String saveOrSubmit) {
        List<Map<String, Object>> kpiFormVoItemList = kpiFormVo.getKpiFormVoItemList();
        ArrayList<KpiScore> kpiScores = new ArrayList<KpiScore>();
        for (Map<String, Object> map : kpiFormVoItemList) {
            String supplierSrmCode = (String)map.get("supplierSrmCode");
            String supplierSapCode = (String)map.get("supplierSapCode");
            String supplierSrmName = (String)map.get("supplierSrmName");
            map.remove("supplierSapCode");
            map.remove("supplierSrmCode");
            map.remove("supplierSrmName");
            map.remove("categoryName");
            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                KpiScore kpiScore = new KpiScore();
                kpiScore.setSupCompanySrmCode(supplierSrmCode);
                kpiScore.setSupCompanySapCode(supplierSapCode);
                kpiScore.setSupCompanyName(supplierSrmName);
                kpiScore.setFormCode(kpiFormVo.getFormCode());
                String key = iter.next();
                kpiScore.setProjectCode(key);
                Map map1 = (Map)map.get(key);
                String originalScore = (String)map1.get("originalScore");
                String score = String.valueOf(map1.get("score"));
                String correctionValue = (String)map1.get("correctionValue");
                kpiScore.setCorrectionValue(correctionValue);
                kpiScore.setScoreScore(score);
                kpiScore.setOriginalValue(originalScore);
                kpiScore.setLastUpdateUser(kpiFormVo.getUser().getNickName());
                kpiScores.add(kpiScore);
            }
        }
        this.updateKpiScoreData(kpiScores, saveOrSubmit);
        if (saveOrSubmit.equals("submit")) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andFormCodeEqualTo(kpiFormVo.getFormCode());
            criteria.andScoreStateEqualTo("0");
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample((IExample)kpiScoreExample);
            if (kpiScoreList == null || kpiScoreList.size() <= 0) {
                Date date = new Date();
                KpiFormExample fromExample = new KpiFormExample();
                fromExample.createCriteria().andFormCodeEqualTo(kpiFormVo.getFormCode());
                KpiForm existKpiForm = this.kpiFormMapper.selectByExample(fromExample).get(0);
                KpiForm kpiFormVOUpdate = new KpiForm();
                kpiFormVOUpdate.setId(existKpiForm.getId());
                kpiFormVOUpdate.setFormCode(existKpiForm.getFormCode());
                kpiFormVOUpdate.setFormState("2");
                kpiFormVOUpdate.setFormFactTime(date);
                kpiFormVOUpdate.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
                kpiFormVOUpdate.setLastUpdateTime(date);
                this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVOUpdate);
            }
        }
    }

    private void updateKpiScoreData(List<KpiScore> kpiScores, String saveOrSubmit) {
        for (int i = 0; CollectionUtils.isNotEmpty(kpiScores) && i < kpiScores.size(); ++i) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            kpiScoreExample.createCriteria().andSupCompanySrmCodeEqualTo(kpiScores.get(i).getSupCompanySrmCode()).andFormCodeEqualTo(kpiScores.get(i).getFormCode()).andProjectCodeEqualTo(kpiScores.get(i).getProjectCode());
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample((IExample)kpiScoreExample);
            for (int j = 0; CollectionUtils.isNotEmpty((Collection)kpiScoreList) && j < kpiScoreList.size(); ++j) {
                KpiScore kpiScore = new KpiScore();
                kpiScore.setId(((KpiScore)kpiScoreList.get(j)).getId());
                kpiScore.setScoreScore(kpiScores.get(i).getScoreScore());
                kpiScore.setCorrectionValue(kpiScores.get(i).getCorrectionValue());
                kpiScore.setLastUpdateTime(new Date());
                kpiScore.setLastUpdateUser(kpiScores.get(i).getLastUpdateUser());
                if (saveOrSubmit.equals("submit")) {
                    kpiScore.setScoreState(Constant.YES_INT.toString());
                }
                this.kpiScoreService.modifyObj(kpiScore);
            }
        }
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void rankAdjustMent(String supplierSrmCode, String classLevel) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(supplierSrmCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)companyList) && i < companyList.size(); ++i) {
            Company company = new Company();
            company.setId(((Company)companyList.get(i)).getId());
            company.setGrade(classLevel);
            this.companyService.modifyObj((Serializable)company);
        }
    }

    @Override
    public String getSRMKpiScore(String sapCompanyCode, Date startTime, Date endTime, String projectDimension) {
        KpiAdverseEventExample eventExample = new KpiAdverseEventExample();
        eventExample.createCriteria().andSupplierSapCodeEqualTo(sapCompanyCode).andStartTimeEqualTo(startTime).andEndTimeEqualTo(endTime).andMatterEqualTo(projectDimension);
        List kpiAdverseEventList = this.kpiAdverseEventService.queryAllObjByExample((IExample)eventExample);
        int points = 0;
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)kpiAdverseEventList) && i < kpiAdverseEventList.size(); ++i) {
            String point = ((KpiAdverseEvent)kpiAdverseEventList.get(i)).getPoints() == null ? "0" : ((KpiAdverseEvent)kpiAdverseEventList.get(i)).getPoints();
            points = Integer.parseInt(point) + points;
        }
        return String.valueOf(points);
    }

    @Override
    public List<KpiForm> queryfinalKpiForms(List<String> srmCompanyIdList, List<String> roleCodeList, User loginUser, List<KpiForm> queryAllObjByExample) {
        ArrayList<KpiForm> finalKpiForms = new ArrayList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || roleCodeList.contains("supperfomconfirm"))) {
            for (int i = 0; CollectionUtils.isNotEmpty(queryAllObjByExample) && i < queryAllObjByExample.size(); ++i) {
                KpiForm kpiForm = queryAllObjByExample.get(i);
                List<String> stringIds = this.kpiFormAndCompanyService.queryCompanyIdsByFormCode(kpiForm.getFormCode());
                boolean anyMatch = stringIds.stream().anyMatch(id -> srmCompanyIdList.stream().anyMatch(id2 -> id2.equals(id)));
                if (StringUtils.isNotBlank((String)kpiForm.getIsScoreBySupPower()) && kpiForm.getIsScoreBySupPower().equals("1") && !anyMatch) continue;
                finalKpiForms.add(kpiForm);
            }
        } else {
            finalKpiForms = queryAllObjByExample;
        }
        return finalKpiForms;
    }

    @Override
    public ReportShow queryMonthlyReport(ReportQueryParams reportQueryParams) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String monthStart = reportQueryParams.getMonthStart() + "-10";
            reportQueryParams.setMonthStart(sdf.format(sdf.parse(monthStart)));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank((String)reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");
        List kpiTemplates = this.kpiTemplateService.queryAllObjByExample((IExample)templateExample);
        if (CollectionUtils.isEmpty((Collection)kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(((KpiTemplate)kpiTemplates.get(0)).getTemplateCode());
        List<KpiReport> reportList = this.kpiFormMapper.queryMonthlyReport(reportQueryParams);
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> dataToTypeMapList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            titleMapFristList.put("projectType", reportList.get(i).getProjectType());
            titleMapFristList.put("projectTypeName", reportList.get(i).getProjectTypeName());
            fristTitleList.add(titleMapFristList);
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            titleMapSecondList.put("projectType", reportList.get(i).getProjectType());
            titleMapSecondList.put("projectCode", reportList.get(i).getProjectCode());
            titleMapSecondList.put("projectName", reportList.get(i).getProjectName());
            secondTitleList.add(titleMapSecondList);
            HashMap<String, String> mapFinalData = new HashMap<String, String>();
            mapFinalData.put("projectCode", reportList.get(i).getProjectCode());
            mapFinalData.put("matter", reportList.get(i).getMatter());
            mapFinalData.put("points", reportList.get(i).getPoints());
            mapFinalData.put("supCompanyId", reportList.get(i).getSupCompanyId());
            dataToTypeMapList.add(mapFinalData);
        }
        monthlyReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        monthlyReportShow.setSecondTitleList(this.removalOfRepetitionList(secondTitleList, "projectCode"));
        TreeSet<KpiReport> personSet = new TreeSet<KpiReport>((o1, o2) -> o1.getSupCompanyId().compareTo(o2.getSupCompanyId()));
        personSet.addAll(reportList);
        ArrayList<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String supCompanyId = ((KpiReport)finalDataList.get(i)).getSupCompanyId();
            KpiReport kpiMonthReport = (KpiReport)finalDataList.get(i);
            kpiMonthReport.setDataToTypeMapList(this.selectPointsOfSupCompanyId(supCompanyId, dataToTypeMapList));
        }
        monthlyReportShow.setFinalDataList(finalDataList);
        return monthlyReportShow;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyId(String supCompanyId, List<Map<String, String>> dataToTypeMapList) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); ++j) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank((String)map.get("supCompanyId")) || !map.get("supCompanyId").equals(supCompanyId)) continue;
            maps.add(map);
        }
        return maps;
    }

    private List<Map<String, String>> removalOfRepetitionList(List<Map<String, String>> titleList, String string) {
        ArrayList<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(titleList) && i < titleList.size(); ++i) {
            Map<String, String> oldMap = titleList.get(i);
            if (StringUtils.isBlank((String)oldMap.get(string))) continue;
            if (newList.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < newList.size(); ++j) {
                    Map newMap = (Map)newList.get(j);
                    if (!((String)newMap.get(string)).equals(oldMap.get(string))) continue;
                    for (String key : oldMap.keySet()) {
                        newMap.put(key, oldMap.get(key));
                    }
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                newList.add(oldMap);
                continue;
            }
            newList.add(oldMap);
        }
        return newList;
    }

    @Override
    public void toVoidDocument(String id) {
        KpiForm kpiForm = new KpiForm();
        kpiForm.setId(id);
        kpiForm.setFormState("3");
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiForm);
    }

    @Override
    public ReportShow queryQuarterOrYearReport(ReportQueryParams reportQueryParams) {
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank((String)reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");
        List kpiTemplates = this.kpiTemplateService.queryAllObjByExample((IExample)templateExample);
        if (CollectionUtils.isEmpty((Collection)kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(((KpiTemplate)kpiTemplates.get(0)).getTemplateCode());
        ReportShow quarterReportShow = new ReportShow();
        List<Object> reportList = new ArrayList();
        if (StringUtils.isNotBlank((String)reportQueryParams.getYear())) {
            reportList = this.kpiFormMapper.queryYearReport(reportQueryParams);
        } else {
            String quarter = reportQueryParams.getQuarter();
            String monthSrart = null;
            Calendar date = Calendar.getInstance();
            String year = String.valueOf(date.get(1));
            switch (quarter) {
                case "1": {
                    monthSrart = "-04-01";
                    break;
                }
                case "2": {
                    monthSrart = "-07-01";
                    break;
                }
                case "3": {
                    monthSrart = "-10-01";
                    break;
                }
                case "4": {
                    monthSrart = "-01-01";
                }
            }
            reportQueryParams.setQuarterAnyDay(year + monthSrart);
            reportList = this.kpiFormMapper.queryQuarterReport(reportQueryParams);
        }
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> supStatusList = new ArrayList<Map<String, String>>();
        ArrayList supStatusDevelList = new ArrayList();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            KpiReport kpiquarterReport = (KpiReport)reportList.get(i);
            String projectType = kpiquarterReport.getProjectType();
            String projectCode = kpiquarterReport.getProjectCode();
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)projectType)) {
                titleMapFristList.put("projectType", projectType);
                titleMapFristList.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                fristTitleList.add(titleMapFristList);
            }
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)projectCode)) {
                titleMapSecondList.put("projectType", projectType);
                titleMapSecondList.put("projectCode", projectCode);
                titleMapSecondList.put("projectName", kpiquarterReport.getProjectName());
                titleMapSecondList.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                titleMapSecondList.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                secondTitleList.add(titleMapSecondList);
            }
            HashMap<String, String> supStatusType = new HashMap<String, String>();
            if (StringUtils.isBlank((String)projectCode) && StringUtils.isNotBlank((String)projectType)) {
                supStatusType.put("projectType", projectType);
                supStatusType.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                supStatusType.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                supStatusType.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                supStatusList.add(supStatusType);
            }
            HashMap<String, String> supStatusDevel = new HashMap<String, String>();
            if (!StringUtils.isBlank((String)projectCode) || !StringUtils.isBlank((String)projectType)) continue;
            supStatusDevel.put("devel", kpiquarterReport.getProjectCodeScore());
            supStatusDevel.put("supCompanyId", kpiquarterReport.getSupCompanyId());
            supStatusDevelList.add(supStatusDevel);
        }
        quarterReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        TreeSet<Object> personSet = new TreeSet<Object>((o1, o2) -> o1.getSupCompanyId().compareTo(o2.getSupCompanyId()));
        personSet.addAll(reportList);
        ArrayList<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        block13: for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String supCompanyId = ((KpiReport)finalDataList.get(i)).getSupCompanyId();
            KpiReport kpiquarterReport = (KpiReport)finalDataList.get(i);
            kpiquarterReport.setDataToTypeMapList(this.selectPointsOfSupCompanyId(supCompanyId, secondTitleList));
            kpiquarterReport.setProjectTypeList(this.selectPointsOfSupCompanyId(supCompanyId, supStatusList));
            for (int j = 0; CollectionUtils.isNotEmpty(supStatusDevelList) && j < supStatusDevelList.size(); ++j) {
                if (!supCompanyId.equals(((Map)supStatusDevelList.get(j)).get("supCompanyId"))) continue;
                kpiquarterReport.setDevel((String)((Map)supStatusDevelList.get(j)).get("devel"));
                continue block13;
            }
        }
        quarterReportShow.setFinalDataList(finalDataList);
        return quarterReportShow;
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void sendToSing(String id) {
        KpiForm kpiForm = this.queryObjById(id);
        if (kpiForm == null) {
            throw new CommonException("\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
        }
        if (!kpiForm.getFormState().equals(KpiFormStatus.DONE.getValue()) && !kpiForm.getFormState().equals(KpiFormStatus.REFUSED.getValue())) {
            throw new CommonException("\u53ea\u6709\u5b8c\u6210\u3001\u5ba1\u6279\u62d2\u7edd\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9001\u7b7e!");
        }
        ProcessStartVO vo = ProcessStartVO.newInstance((String)"jxsh", (String)kpiForm.getFormCode(), (String)kpiForm.getId(), (String)("supplierEFM?Action=View&formCode=" + kpiForm.getFormCode()));
        vo.setListenerClass(this.getClass());
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess != null) {
            kpiForm.setFormState(KpiFormStatus.APPROVING.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
        }
    }

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        KpiForm kpiForm = this.queryObjById(businessId);
        String assignee = StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        if (event.isFinished() && event.isPass()) {
            kpiForm.setFormState(KpiFormStatus.APPROVED.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
            Company company = CompanyUtils.currentCompany();
            User user = SpringSecurityUtils.getLoginUser();
            kpiForm.setCompany(company);
            kpiForm.setUser(user);
            this.finishFormAppove(kpiForm);
        } else if (event.isFinished() && !event.isPass()) {
            kpiForm.setFormState(KpiFormStatus.REFUSED.getValue());
            kpiForm.setLastUpdateTime(new Date());
            this.kpiFormMapper.updateByPrimaryKey(kpiForm);
            KpiScoreExample example = new KpiScoreExample();
            example.createCriteria().andFormCodeEqualTo(kpiForm.getFormCode()).andKpiFormIdEqualTo(kpiForm.getId());
            List KpiScoreArray = this.kpiScoreService.queryAllObjByExample((IExample)example);
            for (KpiScore kpiscore : KpiScoreArray) {
                kpiscore.setScoreState("0");
                kpiscore.setLastUpdateTime(new Date());
                kpiscore.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
                this.kpiScoreService.modifyObj(kpiscore);
            }
        }
    }

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    @Transactional
    public void finishFormAppove(KpiForm kpiForm) {
        KpiTemplate kpiTemplate;
        KpiForm form = this.queryObjById(kpiForm.getId());
        if (form == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u8bc4\u4f30\u8868\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", new Object[]{"\u8bc4\u4f30\u8868\u6570\u636e"});
        }
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        if ((kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(form.getKpiTemplateId())) == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", new Object[]{"\u8bc4\u4f30\u6a21\u677f\u6570\u636e"});
        }
        Date date = new Date();
        KpiForm kpiFormVO = new KpiForm();
        kpiFormVO.setId(kpiForm.getId());
        kpiFormVO.setFormCode(kpiForm.getFormCode());
        kpiFormVO.setFormState("4");
        kpiFormVO.setFormFactTime(date);
        kpiFormVO.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
        kpiFormVO.setLastUpdateTime(date);
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVO);
        KpiRankingExample kpiRankingExample = new KpiRankingExample();
        KpiRankingExample.Criteria rankingCriteria = kpiRankingExample.createCriteria();
        rankingCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        rankingCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        this.kpiRankingService.deleteByExample(kpiRankingExample);
        KpiFormAndCompanyExample kpiFormAndCompanyExample = new KpiFormAndCompanyExample();
        KpiFormAndCompanyExample.Criteria formAndCompanyCriteria = kpiFormAndCompanyExample.createCriteria();
        formAndCompanyCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        formAndCompanyCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        List kpiFormAndCompany = this.kpiFormAndCompanyService.queryAllObjByExample((IExample)kpiFormAndCompanyExample);
        KpiConfigurationExample example = new KpiConfigurationExample();
        List KpiConfigurationArray = this.kpiConfigurationService.queryAllObjByExample((IExample)example);
        for (KpiFormAndCompany formAndCompany : kpiFormAndCompany) {
            KpiRanking t = new KpiRanking();
            t.setSupCompanyId(formAndCompany.getSupCompanyId());
            t.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            KpiRanking lastKpiRanking = this.kpiRankingService.selectByCustom(t);
            KpiRanking currKpiRanking = new KpiRanking();
            currKpiRanking.setPurCompanyId(kpiForm.getCompany().getId());
            currKpiRanking.setPurCompanyCode(kpiForm.getCompany().getCompanyCode());
            currKpiRanking.setPurCompanyName(kpiForm.getCompany().getCompanyName());
            currKpiRanking.setPurUserId(kpiForm.getUser().getId());
            currKpiRanking.setPurUserName(kpiForm.getUser().getNickName());
            currKpiRanking.setKpiFormId(form.getId());
            currKpiRanking.setFormName(form.getFormName());
            currKpiRanking.setFormPublishTime(form.getFormStartTime());
            currKpiRanking.setFormFactTime(date);
            currKpiRanking.setSupCompanyId(formAndCompany.getSupCompanyId());
            currKpiRanking.setSupCompanySapCode(formAndCompany.getSupCompanySapCode());
            currKpiRanking.setSupCompanyName(formAndCompany.getSupCompanyName());
            currKpiRanking.setSupUserName(formAndCompany.getSupUserName());
            currKpiRanking.setSupUserId(formAndCompany.getSupUserId());
            currKpiRanking.setImportantFlag(formAndCompany.getImportantFlag());
            currKpiRanking.setCategory(formAndCompany.getCategory());
            currKpiRanking.setSalesMan(formAndCompany.getSalesMan());
            currKpiRanking.setDevelopmentManager(formAndCompany.getDevelopmentManager());
            currKpiRanking.setOnlineSrmFlag(formAndCompany.getOnlineSrmFlag());
            currKpiRanking.setCriticality(formAndCompany.getCriticality());
            currKpiRanking.setSymbiosis(formAndCompany.getSymbiosis());
            currKpiRanking.setProductImportance(formAndCompany.getProductImportance());
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setCreateTime(new Date());
            currKpiRanking.setLastUpdateTime(new Date());
            currKpiRanking.setLastUpdateUser(kpiForm.getUser().getNickName());
            currKpiRanking.setFormCode(kpiForm.getFormCode());
            currKpiRanking.setTemplateCode(kpiTemplate.getTemplateCode());
            currKpiRanking.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            currKpiRanking.setRankingScore(lastKpiRanking == null ? null : lastKpiRanking.getRankingScore());
            this.kpiRankingService.insertCustom(currKpiRanking);
            if (CollectionUtils.isNotEmpty((Collection)KpiConfigurationArray)) {
                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(kpiForm.getId()).andFormCodeEqualTo(kpiForm.getFormCode()).andSupCompanyIdEqualTo(formAndCompany.getSupCompanyId());
                KpiRanking KpiRankingEdit = (KpiRanking)this.kpiRankingService.queryAllObjByExample((IExample)rankingExample).get(0);
                if (KpiRankingEdit != null) {
                    String purCheckRank = "";
                    boolean qualifiedFlag = true;
                    for (KpiConfiguration configuration : KpiConfigurationArray) {
                        if (!((double)configuration.getStartScore().intValue() < Double.valueOf(KpiRankingEdit.getRankingScore())) || !((double)configuration.getEndScore().intValue() >= Double.valueOf(KpiRankingEdit.getRankingScore()))) continue;
                        purCheckRank = configuration.getLevel();
                        if (!configuration.getLevel().contains("\u5dee")) break;
                        qualifiedFlag = false;
                        break;
                    }
                    KpiRanking KpiRankingObj = new KpiRanking();
                    KpiRankingObj.setId(KpiRankingEdit.getId());
                    KpiRankingObj.setPurCheckRank(purCheckRank);
                    if (qualifiedFlag) {
                        KpiRankingObj.setQualifiedFlag(Constant.YES_INT);
                    } else {
                        KpiRankingObj.setQualifiedFlag(Constant.NO_INT);
                        this.createIimproveForm(KpiRankingEdit, projectId, companyId);
                    }
                    this.kpiRankingService.modifyObj(KpiRankingObj);
                }
            }
            this.sendInformationToSupplier(kpiForm, formAndCompany);
        }
        this.rankingByCategory(kpiFormAndCompany, kpiForm.getId());
        this.rankingByAll(kpiFormAndCompany, kpiForm.getId());
    }

    private void createIimproveForm(KpiRanking KpiRankingEdit, String projectId, String companyId) {
        KpiSupplierImprove kpiSupplierImprove = new KpiSupplierImprove();
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("IMPROVE_NO");
        String Content = "\u8d35\u53f8\u5728\u7ee9\u6548\u8003\u6838\u5355\u636e\uff1a" + KpiRankingEdit.getFormName() + " \u8003\u6838\u7ed3\u679c\u4e3a\u4e0d\u5408\u683c,\u8bf7\u6539\u5584!";
        kpiSupplierImprove.setImproveNo(billNo);
        User user = SpringSecurityUtils.getLoginUser();
        kpiSupplierImprove.setImproveContent(Content);
        kpiSupplierImprove.setImproveType("service");
        kpiSupplierImprove.setCreateUserId(user.getId());
        kpiSupplierImprove.setCreateUserName(user.getNickName());
        kpiSupplierImprove.setCreateTime(new Date());
        kpiSupplierImprove.setUpdateUserId(user.getId());
        kpiSupplierImprove.setUpdateUserName(user.getNickName());
        kpiSupplierImprove.setUpdateTime(new Date());
        kpiSupplierImprove.setStatus(ImproveStatusEnum.NEW.getValue());
        kpiSupplierImprove.setSendStatus(Constant.NO_INT);
        kpiSupplierImprove.setProjectId(projectId);
        kpiSupplierImprove.setCompanyId(companyId);
        kpiSupplierImprove.setSummaryUserid(SpringSecurityUtils.getLoginUserId());
        kpiSupplierImprove.setSupCompanyName(SpringSecurityUtils.getLoginUserName());
        kpiSupplierImprove.setSummaryDate(new Date());
        kpiSupplierImprove.setSupCompanyCode(KpiRankingEdit.getSupCompanySrmCode());
        kpiSupplierImprove.setSupCompanyName(KpiRankingEdit.getSupCompanyName());
        kpiSupplierImprove.setSupCompanySapCode(KpiRankingEdit.getSupCompanySapCode());
        this.kpiSupplierImproveService.addObj(kpiSupplierImprove);
    }

    private void rankingByCategory(List<KpiFormAndCompany> kpiFormAndCompanies, String formId) {
        Map<String, List<KpiFormAndCompany>> companyMap = kpiFormAndCompanies.stream().collect(Collectors.groupingBy(KpiFormAndCompany::getCategory));
        for (Map.Entry<String, List<KpiFormAndCompany>> entry : companyMap.entrySet()) {
            List<KpiFormAndCompany> companyList = entry.getValue();
            HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
            for (KpiFormAndCompany kpiFormAndCompany : companyList) {
                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId()).andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
                List kpiRankings = this.kpiRankingService.queryAllObjByExample((IExample)rankingExample);
                if (!CollectionUtils.isNotEmpty((Collection)kpiRankings)) continue;
                scoreMap.put(kpiFormAndCompany.getSupCompanySrmCode(), NumberUtils.toInt((String)((KpiRanking)kpiRankings.get(0)).getRankingScore(), (int)0));
            }
            Comparator<Map.Entry> scoreComparator = Comparator.comparingInt(Map.Entry::getValue);
            ArrayList list = new ArrayList(scoreMap.entrySet());
            Collections.sort(list, scoreComparator);
            Collections.reverse(list);
            int index = 1;
            for (Map.Entry entry2 : list) {
                String companyCode = (String)entry2.getKey();
                Integer score = (Integer)entry2.getValue();
                KpiRankingExample rankingExample = new KpiRankingExample();
                rankingExample.createCriteria().andKpiFormIdEqualTo(formId).andSupCompanySrmCodeEqualTo(companyCode);
                KpiRanking kpiRanking = new KpiRanking();
                kpiRanking.setCategoryRank(index);
                kpiRanking.setCategoryCount(list.size());
                this.kpiRankingService.updateByExampleSelective(kpiRanking, rankingExample);
                ++index;
            }
        }
    }

    private void rankingByAll(List<KpiFormAndCompany> kpiFormAndCompanies, String formId) {
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanies) {
            KpiRankingExample rankingExample = new KpiRankingExample();
            rankingExample.createCriteria().andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId()).andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
            List kpiRankings = this.kpiRankingService.queryAllObjByExample((IExample)rankingExample);
            if (!CollectionUtils.isNotEmpty((Collection)kpiRankings)) continue;
            scoreMap.put(kpiFormAndCompany.getSupCompanySrmCode(), NumberUtils.toInt((String)((KpiRanking)kpiRankings.get(0)).getRankingScore(), (int)0));
        }
        Comparator<Map.Entry> scoreComparator = Comparator.comparingInt(Map.Entry::getValue);
        ArrayList list = new ArrayList(scoreMap.entrySet());
        Collections.sort(list, scoreComparator);
        Collections.reverse(list);
        int index = 1;
        for (Map.Entry entry : list) {
            String companyCode = (String)entry.getKey();
            Integer score = (Integer)entry.getValue();
            KpiRankingExample rankingExample = new KpiRankingExample();
            rankingExample.createCriteria().andKpiFormIdEqualTo(formId).andSupCompanySrmCodeEqualTo(companyCode);
            KpiRanking kpiRanking = new KpiRanking();
            kpiRanking.setRankingCount(index);
            kpiRanking.setCompanyNumber(list.size());
            this.kpiRankingService.updateByExampleSelective(kpiRanking, rankingExample);
            ++index;
        }
    }

    private void sendInformationToSupplier(KpiForm kpiForm, KpiFormAndCompany formAndCompany) {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("formCode", kpiForm.getFormCode());
        com.els.base.core.entity.user.User user = this.companyUserRefService.queryMainUserOfCompany(formAndCompany.getSupCompanyId());
        if (null != user) {
            Message message = Message.init(msg).setCompanyCode(kpiForm.getPurCompanyCode()).setSenderId(kpiForm.getPurUserId()).setBusinessTypeCode("KPIFORM_PUR_SEND_INFORMATION").addReceiverId(user.getId()).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    public List<String> queryCompanySapCode(String year, String month) {
        return this.kpiFormMapper.selectDistinctCompanySapCode(year, month);
    }

    @Transactional
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void addAll(List<KpiForm> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiFormMapper.insertSelective((KpiForm)item);
        });
    }

    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void deleteByExample(KpiFormExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiFormMapper.deleteByExample(arg0);
    }
}

