/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiOriginalScoreMapper;
import com.els.base.performance.entity.KpiOriginalScore;
import com.els.base.performance.entity.KpiOriginalScoreExample;
import com.els.base.performance.service.KpiOriginalScoreService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiOriginalScoreService")
public class KpiOriginalScoreServiceImpl
implements KpiOriginalScoreService {
    @Resource
    protected KpiOriginalScoreMapper kpiOriginalScoreMapper;

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void addObj(KpiOriginalScore t) {
        this.kpiOriginalScoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void addAll(List<KpiOriginalScore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiOriginalScoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiOriginalScoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void deleteByExample(KpiOriginalScoreExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiOriginalScoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void modifyObj(KpiOriginalScore t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiOriginalScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiOriginalScore"}, keyGenerator="redisKeyGenerator")
    public KpiOriginalScore queryObjById(String id) {
        return this.kpiOriginalScoreMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiOriginalScore"}, keyGenerator="redisKeyGenerator")
    public List<KpiOriginalScore> queryAllObjByExample(KpiOriginalScoreExample example) {
        return this.kpiOriginalScoreMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiOriginalScore"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiOriginalScore> queryObjByPage(KpiOriginalScoreExample example) {
        PageView<KpiOriginalScore> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiOriginalScoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiOriginalScore"}, allEntries=true)
    public void updateByExampleSelective(KpiOriginalScoreExample example, KpiOriginalScore score) {
        this.kpiOriginalScoreMapper.updateByExampleSelective(score, example);
    }
}

