/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiRankingMapper;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiRankingService")
public class KpiRankingServiceImpl
implements KpiRankingService {
    @Resource
    protected KpiRankingMapper kpiRankingMapper;

    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void addObj(KpiRanking t) {
        this.kpiRankingMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void addAll(List<KpiRanking> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiRankingMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void insertCustom(KpiRanking t) {
        this.kpiRankingMapper.insertCustom(t);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public int updateByExampleSelective(KpiRanking kpiRanking, KpiRankingExample example) {
        return this.kpiRankingMapper.updateByExampleSelective(kpiRanking, example);
    }

    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiRankingMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void deleteByExample(KpiRankingExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiRankingMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void modifyObj(KpiRanking t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiRankingMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public KpiRanking queryObjById(String id) {
        return this.kpiRankingMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public List<KpiRanking> queryAllObjByExample(KpiRankingExample example) {
        return this.kpiRankingMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiRanking> queryObjByPage(KpiRankingExample example) {
        PageView<KpiRanking> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiRankingMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public KpiRanking selectByCustom(KpiRanking t) {
        return this.kpiRankingMapper.selectByCustom(t);
    }
}

